/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Utils;

public class LevelManager {
    private static final Logger log = LogManager.getLogger();
    private static final String LEVELS_FILE_NAME = "./levels";
    private static Map<Integer, Integer> levels = new HashMap<Integer, Integer>();

    public static int getLevel(int cid) {
        Integer result = levels.get(cid);
        return result != null ? result : 0;
    }

    public static void updateLevels(String values, boolean save) {
        HashMap<Integer, Integer> newLevels = new HashMap<Integer, Integer>();
        StringTokenizer st = new StringTokenizer(values, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(9);
            if (pos <= 0) continue;
            int cid = Utils.parseInt((String)token.substring(0, pos));
            int level = Utils.parseInt((String)token.substring(pos + 1));
            if (cid <= 0 || level <= 0) continue;
            newLevels.put(cid, level);
        }
        levels = newLevels;
        if (save) {
            try {
                FileOutputStream fos = new FileOutputStream(LEVELS_FILE_NAME);
                fos.write(values.getBytes("ISO8859-1"));
                fos.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        try {
            File file = new File(LEVELS_FILE_NAME);
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                byte[] data = Utils.readByBlock((InputStream)fis);
                fis.close();
                LevelManager.updateLevels(new String(data, "ISO8859-1"), false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

