/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.StopableThread;

public class UpdateSuspendedSetter
extends StopableThread {
    private static Logger logger = LogManager.getLogger((String)"processor");
    private DialUpRadiusProcessor processor;
    private int maxUpdateTimeout = 900;

    public UpdateSuspendedSetter(DefaultServerSetup setup, DialUpRadiusProcessor processor) {
        this.processor = processor;
        this.maxUpdateTimeout = setup.getInt("max.update.timeout", this.maxUpdateTimeout);
        logger.info("UPDATE mode SLEEP setter, timeout=" + this.maxUpdateTimeout);
        this.start();
    }

    public void run() {
        while (this.working) {
            try {
                long now = System.currentTimeMillis();
                for (DialUpNas nas : this.processor.getNasList().nases()) {
                    if (nas.getWorkMode() != 1) continue;
                    for (DialUpNasConnection con : nas.connections()) {
                        long stopTime;
                        long timeAfterLastUpdate;
                        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                        if (con.getStatus() != NasConnection.Status.working || (timeAfterLastUpdate = (now - (stopTime = session.getStopTime().getTimeInMillis())) / 1000L) <= (long)this.maxUpdateTimeout) continue;
                        session.addLogInfo("Set status SUSPENDED on UpdateSuspendedSetter, time after last update: " + timeAfterLastUpdate);
                        con.setStatus(NasConnection.Status.suspended);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                UpdateSuspendedSetter.sleep((long)30000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info("Stopping UpdateSuspendSetter");
    }
}

