/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.dialup.server.DetailCompressRules;
import ru.bitel.bgbilling.modules.dialup.server.TrafficSelector;
import ru.bitel.bgbilling.modules.dialup.server.mail.MailTaskTrafficProcessor;
import ru.bitel.bgbilling.modules.dialup.server.traffic.AddressUseCache;
import ru.bitel.bgbilling.modules.dialup.server.traffic.ServiceLinkFinder;
import ru.bitel.bgbilling.modules.dialup.server.traffic.SessionTrafficCache;
import ru.bitel.bgbilling.modules.dialup.server.traffic.Traffic;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class TrafficProcessor
extends RunTask {
    private int mid = -1;
    private String email;
    private Calendar _date1;
    private Calendar _date2;
    private Calendar startMonth;
    private Calendar endMonth;
    private StringBuffer report;
    private ServiceLinkFinder serviceFinder;
    private TrafficSelector trafficSelector;
    private AddressUseCache addressUseCache;
    private DetailCompressRules detailCompressRules;
    private static final Logger log = LogManager.getLogger((String)"scheduler");
    private Connection con;
    private Connection conSlave;

    public TrafficProcessor(String email, Calendar date1, Calendar date2, int mid) {
        this.email = email;
        this._date1 = date1;
        this._date2 = date2;
        this.mid = mid;
        this.startMonth = (Calendar)this._date1.clone();
        this.startMonth.set(5, 1);
        this.endMonth = (Calendar)this._date2.clone();
        this.endMonth.set(5, this.endMonth.getActualMaximum(5));
    }

    public String getDescription() {
        return "\u041c\u043e\u0434\u0443\u043b\u044c DialUp. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0440\u0430\u0444\u0444\u0438\u043a\u0430. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.mid + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"MM.yyyy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            log.info("DialUp traffic process started..");
            log.info("Period: " + TimeUtils.formatPeriod((Calendar)this._date1, (Calendar)this._date2));
            ModuleSetup moduleSetup = new ModuleSetup(this.conSlave, this.mid);
            this.detailCompressRules = new DetailCompressRules(this.mid);
            this.trafficSelector = new TrafficSelector(this.conSlave, this.mid, log);
            this.serviceFinder = new ServiceLinkFinder((Preferences)moduleSetup);
            this.addressUseCache = new AddressUseCache();
            SessionTrafficCache serviceAmountCache = new SessionTrafficCache();
            this.report = new StringBuffer(10000);
            this.report.append("\u0417\u0430\u043f\u0443\u0441\u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0440\u0430\u0444\u0438\u043a\u043e\u0432 => ");
            this.report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
            this.report.append("\n");
            this.report.append("\n\u041f\u0435\u0440\u0438\u043e\u0434: " + TimeUtils.formatPeriod((Calendar)this._date1, (Calendar)this._date2));
            String query = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this._date1.getTime(), (int)this.mid);
            String loginTable = "user_login_" + this.mid;
            if (ServerUtils.tableExists((Connection)this.conSlave, (String)logSessionTableName)) {
                for (TrafficSelector.NasData nas : this.trafficSelector.getNasIdList()) {
                    try {
                        this.trafficSelector.setNasId(nas.getId());
                    }
                    catch (Exception e) {
                        log.error(e.toString());
                        this.report.append("\n" + e.toString());
                        continue;
                    }
                    this.addressUseCache.clearData();
                    query = "SELECT session.id, session.session_start, session.session_stop, session.ipaddr, session.login_name, session.nas_port, login.cid FROM " + logSessionTableName + " AS session INNER JOIN " + loginTable + " AS login ON session.lid=login.id WHERE nas_id=? AND session_start>=? AND session_start<?";
                    query = query + " ORDER BY id";
                    ps = this.conSlave.prepareStatement(query);
                    ps.setInt(1, nas.getId());
                    ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this._date1));
                    ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)this._date2)));
                    rs = ps.executeQuery();
                    log.info("DialUp traffic processing session selected for nas " + nas.getId() + ", start process..");
                    while (rs.next()) {
                        int sessionId = rs.getInt(1);
                        long sessionStart = rs.getTimestamp(2).getTime();
                        long sessionStop = rs.getTimestamp(3).getTime();
                        long ipaddr = rs.getLong(4);
                        String login = rs.getString(5);
                        String port = rs.getString(6).trim();
                        int contractId = rs.getInt(7);
                        String realm = "default";
                        int pos = login.indexOf(64);
                        if (pos > 0 && pos < login.length() - 1) {
                            realm = login.substring(pos + 1);
                        }
                        this.addressUseCache.addCacheEntry(ipaddr, sessionStart, sessionStop + (long)(moduleSetup.getInt("delay.stop", 0) * 1000), sessionId, realm, port, contractId);
                    }
                    ps.close();
                    Calendar startDayHour = (Calendar)this._date1.clone();
                    startDayHour.set(11, 0);
                    TimeUtils.clear_MIN_MIL_SEC((Calendar)startDayHour);
                    Calendar endDayHour = (Calendar)this._date2.clone();
                    endDayHour.set(11, 23);
                    TimeUtils.clear_MIN_MIL_SEC((Calendar)endDayHour);
                    while (TimeUtils.hourDelta((Calendar)startDayHour, (Calendar)endDayHour) >= 0) {
                        FlowReader reader;
                        log.info("Processing NAS " + nas.getId() + " hour " + TimeUtils.format((Calendar)startDayHour, (String)"dd.MM.yy HH"));
                        IPHourlyDataLog dataLog = this.trafficSelector.getHourBinaryLog(startDayHour);
                        this.addressUseCache.setHour(startDayHour.getTimeInMillis());
                        int hourOfDay = startDayHour.get(11);
                        while ((reader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                            FlowArray f;
                            while ((f = reader.readChunk()) != null) {
                                int size = f.size;
                                for (int i = 0; i < size; ++i) {
                                    Data flow = f.array[i];
                                    AddressUseCache.CacheEntry cacheEntry = null;
                                    int direct = -1;
                                    long address = -1L;
                                    int port = -1;
                                    long time = flow.getMilliseconds();
                                    long srcAddress = flow.getSrcAddress();
                                    int srcPort = flow.getSrcPort();
                                    long dstAddress = flow.getDstAddress();
                                    int dstPort = flow.getDstPort();
                                    long octets = flow.getOctets();
                                    cacheEntry = this.addressUseCache.getAddessSession(time, dstAddress);
                                    if (cacheEntry != null) {
                                        direct = 2;
                                        address = srcAddress;
                                        port = srcPort;
                                        this.processDirect(serviceAmountCache, nas, octets, cacheEntry, direct, address, port, hourOfDay);
                                    }
                                    if ((cacheEntry = this.addressUseCache.getAddessSession(time, srcAddress)) == null) continue;
                                    direct = 1;
                                    address = dstAddress;
                                    port = dstPort;
                                    this.processDirect(serviceAmountCache, nas, octets, cacheEntry, direct, address, port, hourOfDay);
                                }
                            }
                        }
                        if (hourOfDay == 23) {
                            serviceAmountCache.flushCache(this.con, this.mid, startDayHour);
                        }
                        startDayHour.add(11, 1);
                        log.info("OK");
                    }
                }
            } else {
                this.report.append("\n\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + logSessionTableName);
            }
            this.report.append("\n\n\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0442\u0440\u0430\u0444\u0438\u043a\u043e\u0432 => ");
            this.report.append(TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy HH:mm:ss"));
            log.info("DialUp traffic process result: \n");
            log.info(this.report.toString());
            new MailMsg((Preferences)this.setup).sendMessage(new MailTaskTrafficProcessor().setModuleId(this.mid).setRecipients(this.email).setSubject("DialUP traffic process result").addTextPart("text", this.report.toString()));
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
        }
    }

    private void processDirect(SessionTrafficCache serviceAmountCache, TrafficSelector.NasData nasId, long octets, AddressUseCache.CacheEntry cacheEntry, int direct, long address, int port, int hour) throws Exception {
        int sid;
        if (address > 0L && (sid = this.serviceFinder.getServiceId(direct, address, port)) > 0) {
            SessionTrafficCache.SessionData sessionData = serviceAmountCache.getSessionData(cacheEntry.sessionId);
            if (sessionData == null) {
                List<Traffic> trafficConfig = nasId.getTrafficConfig(cacheEntry.realm, cacheEntry.port);
                if (trafficConfig == null) {
                    throw new BGException("Not found trafficConfig NAS: " + nasId + "; realm: " + cacheEntry.realm + "; port: " + cacheEntry.port);
                }
                sessionData = new SessionTrafficCache.SessionData(cacheEntry.contractId, trafficConfig, this.detailCompressRules);
                serviceAmountCache.addSessionData(cacheEntry.sessionId, sessionData);
            }
            sessionData.addAmount(sid, hour, octets);
        }
    }
}

