/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.contract;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.client.contract.ContractPanel_Documents;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.table.BGTableModel;

public class DocumentsEditorPanel
extends BGUPanel {
    private static final String CLIENT_DOCUMENTS_CONTRACT_FILE_UPLOAD_EXTENSIONS = "client.documents.contract.file.upload.extensions";
    private static final String CLIENT_DOCUMENTS_MAX_FILE_SIZE = "client.documents.contract.file.max.size";
    private BGTextField documentTitleTextfield = new BGTextField();
    private BGTextField documentCommentTextfield = new BGTextField();
    private BGComboBox<DocumentType> typeComboBox = new BGComboBox();
    private BGComboBox<DocumentJournal> journalComboBox = new BGComboBox();
    private BGComboBox<KeyValue> showInLkComboBox = new BGComboBox();
    private BGComboBox<DocumentStatus> statusComboBox = new BGComboBox();
    private BGTextField statusCommentTextfield = new BGTextField(8);
    private BGButton setStatusButton = new BGButton("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
    private BGUTable statusLogTable;
    private StatusLogTableModel statusLogTableModel;
    private JButton printFileButton = new JButton(ClientUtils.getIcon((String)"print.png"));
    private JButton downloadFileButton = new JButton(ClientUtils.getIcon((String)"item_down.png"));
    private JButton uploadFileButton = new JButton(ClientUtils.getIcon((String)"item_up.png"));
    private JButton deleteFilesButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private JButton openFileButton = new JButton(ClientUtils.getIcon((String)"open.png"));
    private JButton sendLinkFilesButton = new JButton(ClientUtils.getIcon((String)"mail.png"));
    private BGUTable fileTable;
    private FileTableModel fileTableModel;
    private Directory<UserInfo> userDirectory;
    private Directory<DocumentJournal> journalDirectory;
    private Directory<DocumentType> typeDirectory;
    private Directory<DocumentStatus> statusDirectory;
    private ContractPanel_Documents parentPanel;
    private DocumentsService documentsService;
    private Document currentDocument;
    private List<BGServerFile> filesToUpload = new ArrayList<BGServerFile>();
    private List<File> selectedFiles = new ArrayList<File>();
    private File currentDirectory;
    private boolean createCurrentDirectory = false;
    private int contractId;
    private Preferences pluginParameters;

    public DocumentsEditorPanel(ClientContext context, ContractPanel_Documents parent) {
        super(context);
        this.parentPanel = parent;
        this.pluginParameters = ClientSetup.getInstance().getPluginParameterPreferences(((ClientContext)this.getContext()).getModule());
    }

    protected void jbInit() throws Exception {
        Dimension tableDimension = new Dimension(200, 150);
        this.documentsService = (DocumentsService)((ClientContext)this.getContext()).getPort(DocumentsService.class);
        this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class, 0);
        this.journalDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentJournal.class);
        this.typeDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentType.class);
        this.statusDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentStatus.class);
        this.statusComboBox.setModel(new DefaultComboBoxModel<DocumentStatus>(this.statusDirectory.list().toArray(new DocumentStatus[0])));
        this.journalComboBox.setModel(new DefaultComboBoxModel<DocumentJournal>(this.journalDirectory.list().toArray(new DocumentJournal[0])));
        this.typeComboBox.setModel(new DefaultComboBoxModel<DocumentType>(this.typeDirectory.list().toArray(new DocumentType[0])));
        this.showInLkComboBox.setModel(new DefaultComboBoxModel<KeyValue>(new KeyValue[]{new KeyValue("on", "\u0434\u0430"), new KeyValue("off", "\u043d\u0435\u0442")}));
        JPanel fieldPanel = new JPanel(new GridBagLayout());
        fieldPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        fieldPanel.add((Component)this.documentTitleTextfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        fieldPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        fieldPanel.add((Component)this.documentCommentTextfield, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        fieldPanel.add((Component)this.getEditPanel(), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.statusLogTableModel = new StatusLogTableModel();
        this.statusLogTable = new BGUTable((TableModel)((Object)this.statusLogTableModel));
        this.setStatusButton.setToolTipText("\u041d\u0430\u0436\u043c\u0438\u0442\u0435, \u0447\u0442\u043e\u0431\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        JPanel statusCommentPanel = new JPanel(new GridBagLayout());
        statusCommentPanel.add((Component)this.statusComboBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        statusCommentPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        statusCommentPanel.add((Component)this.statusCommentTextfield, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        statusCommentPanel.add((Component)this.setStatusButton, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        JScrollPane statusHistoryScrollPane = new JScrollPane((Component)this.statusLogTable);
        statusHistoryScrollPane.setMinimumSize(tableDimension);
        statusHistoryScrollPane.setPreferredSize(tableDimension);
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0430\u0442\u0443\u0441"));
        statusPanel.add((Component)statusCommentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        statusPanel.add((Component)new JLabel("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441\u0430:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 3), 0, 0));
        statusPanel.add((Component)statusHistoryScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.fileTableModel = new FileTableModel();
        this.printFileButton.setToolTipText("\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
        this.uploadFileButton.setToolTipText("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440");
        this.downloadFileButton.setToolTipText("\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u043d\u0430 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440");
        this.deleteFilesButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.openFileButton.setToolTipText("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u043c \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u043c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0438");
        this.sendLinkFilesButton.setToolTipText("\u041e\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0444\u0430\u0439\u043b\u044b \u043f\u043e \u043f\u043e\u0447\u0442\u0435");
        this.fileTable = new BGUTable((TableModel)((Object)this.fileTableModel));
        this.fileTable.setToolTipText("\u0414\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0438/\u0438\u043b\u0438 \u0438\u043c\u0435\u043d\u0438 \u0444\u0430\u0439\u043b\u0430 \u0434\u0432\u0430\u0436\u0434\u044b \u0449\u0435\u043b\u043a\u043d\u0438\u0442\u0435 \u043d\u0430 \u044f\u0447\u0435\u0439\u043a\u0435 \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0438/\u0438\u043b\u0438 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0435 \u0441 \u0444\u0430\u0439\u043b\u043e\u043c.");
        this.fileTable.setSelectionMode(2);
        JScrollPane fileTableJScrollPane = new JScrollPane((Component)this.fileTable);
        fileTableJScrollPane.setMaximumSize(tableDimension);
        fileTableJScrollPane.setPreferredSize(tableDimension);
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.add((Component)this.openFileButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)this.printFileButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)this.uploadFileButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)this.downloadFileButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)this.deleteFilesButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        toolbarPanel.add((Component)this.sendLinkFilesButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel filePanel = new JPanel(new GridBagLayout());
        filePanel.setBorder((Border)new BGTitleBorder("\u0424\u0430\u0439\u043b\u044b"));
        filePanel.add((Component)toolbarPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        filePanel.add((Component)fileTableJScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel documentPanel = new JPanel(new GridBagLayout());
        documentPanel.add((Component)fieldPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        documentPanel.add((Component)statusPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        documentPanel.add((Component)filePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        documentPanel.add(Box.createGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JScrollPane scrollPane = new JScrollPane(documentPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.CANCEL});
        buttonPanel.addActionListener(actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if (actionCommand.equals("ok")) {
                this.performAction("ok");
            } else {
                this.setData(null);
                this.setVisible(false);
                this.filesToUpload.clear();
                this.selectedFiles.clear();
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432"));
        this.add(scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(Box.createHorizontalStrut(800), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setStatusButton.addActionListener(actionEvent -> this.performAction("setStatus"));
        this.uploadFileButton.addActionListener(actionEvent -> this.performAction("uploadFile"));
        this.printFileButton.addActionListener(actionEvent -> this.performAction("files.printFile"));
        this.downloadFileButton.addActionListener(actionEvent -> this.performAction("files.DownloadFile"));
        this.deleteFilesButton.addActionListener(actionEvent -> this.performAction("files.DeleteFile"));
        this.openFileButton.addActionListener(actionEvent -> this.performAction("files.OpenFile"));
        this.sendLinkFilesButton.addActionListener(actionEvent -> this.performAction("files.SendLinkFiles"));
    }

    private JPanel getEditPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.typeComboBox, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0416\u0443\u0440\u043d\u0430\u043b:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.journalComboBox, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0432 \u041b\u041a:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.showInLkComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setData(Document document) {
        this.currentDocument = document;
        this.performAction("refresh");
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            block8: {
                if (this.currentDocument != null) {
                    try {
                        File directory;
                        this.documentTitleTextfield.setText(this.currentDocument.getTitle());
                        this.documentCommentTextfield.setText(this.currentDocument.getComment());
                        this.statusComboBox.setSelectedItem((Object)this.statusDirectory.get(this.currentDocument.getStatusId()));
                        this.typeComboBox.setSelectedItem((Object)this.typeDirectory.get(this.currentDocument.getTypeId()));
                        this.journalComboBox.setSelectedItem((Object)this.journalDirectory.get(this.currentDocument.getJournalId()));
                        this.showInLkComboBox.setSelectedIndex(this.currentDocument.isShowInLK() ? 0 : 1);
                        this.statusLogTableModel.setData(this.documentsService.getDocumentStatusLogList(this.currentDocument.getId()));
                        this.fileTableModel.setData(this.documentsService.getDocumentFileList(this.currentDocument.getId()));
                        JSONObject additionalParams = new JSONObject(this.documentsService.getAdditionalParams(this.contractId));
                        if (additionalParams.length() <= 0) break block8;
                        String dir = additionalParams.optString("dir");
                        String regexp = additionalParams.optString("regexp");
                        this.createCurrentDirectory = additionalParams.optBoolean("create");
                        if (Utils.notBlankString((String)dir) && Utils.notBlankString((String)regexp) && (directory = new File(dir)).isDirectory() && directory.exists() && directory.canRead()) {
                            this.currentDirectory = null;
                            File[] list = directory.listFiles();
                            if (list != null) {
                                for (File file : list) {
                                    if (!file.getName().matches(regexp)) continue;
                                    this.currentDirectory = file;
                                    break;
                                }
                            }
                            if (this.currentDirectory == null && this.createCurrentDirectory) {
                                this.currentDirectory = new File(additionalParams.optString("file"));
                            }
                        }
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    this.documentTitleTextfield.setText("");
                    this.documentCommentTextfield.setText("");
                    this.typeComboBox.setSelectedIndex(0);
                    this.journalComboBox.setSelectedIndex(0);
                    this.statusComboBox.setSelectedIndex(0);
                    this.showInLkComboBox.setSelectedIndex(0);
                    this.fileTableModel.setData(null);
                }
            }
            this.statusCommentTextfield.setText("");
        });
        new AbstractBGUPanel.DefaultAction("setStatus", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (DocumentsEditorPanel.this.currentDocument != null) {
                    DocumentStatus selectedStatus = (DocumentStatus)DocumentsEditorPanel.this.statusComboBox.getSelectedItem();
                    if (selectedStatus != null) {
                        DocumentsEditorPanel.this.currentDocument.setStatusId(selectedStatus.getId());
                    }
                    if (!DocumentsEditorPanel.this.documentsService.updateDocumentStatus(DocumentsEditorPanel.this.currentDocument.getId(), DocumentsEditorPanel.this.currentDocument.getStatusId(), DocumentsEditorPanel.this.statusCommentTextfield.getText())) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u0436\u0435 \u0431\u044b\u043b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0440\u0435\u0436\u0434\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                        return;
                    }
                    DocumentsEditorPanel.this.statusLogTableModel.setData(DocumentsEditorPanel.this.documentsService.getDocumentStatusLogList(DocumentsEditorPanel.this.currentDocument.getId()));
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0427\u0442\u043e\u0431\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u043f\u0435\u0440\u0432\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("ok", "OK"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DocumentType selectedType;
                if (DocumentsEditorPanel.this.currentDocument == null) {
                    DocumentsEditorPanel.this.currentDocument = new Document();
                }
                DocumentsEditorPanel.this.currentDocument.setComment(DocumentsEditorPanel.this.documentCommentTextfield.getText());
                DocumentsEditorPanel.this.currentDocument.setTitle(DocumentsEditorPanel.this.documentTitleTextfield.getText());
                DocumentJournal selectedJournal = (DocumentJournal)DocumentsEditorPanel.this.journalComboBox.getSelectedItem();
                if (selectedJournal != null) {
                    DocumentsEditorPanel.this.currentDocument.setJournalId(selectedJournal.getId());
                }
                if ((selectedType = (DocumentType)DocumentsEditorPanel.this.typeComboBox.getSelectedItem()) != null) {
                    DocumentsEditorPanel.this.currentDocument.setTypeId(selectedType.getId());
                }
                DocumentsEditorPanel.this.currentDocument.setContractId(DocumentsEditorPanel.this.contractId);
                DocumentsEditorPanel.this.currentDocument.setShowInLK(DocumentsEditorPanel.this.showInLkComboBox.getSelectedIndex() == 0);
                DocumentsEditorPanel.this.currentDocument.setId(DocumentsEditorPanel.this.documentsService.updateDocument(DocumentsEditorPanel.this.currentDocument));
                if (!DocumentsEditorPanel.this.filesToUpload.isEmpty()) {
                    DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                    TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                    for (int i = 0; i < DocumentsEditorPanel.this.selectedFiles.size(); ++i) {
                        File file = DocumentsEditorPanel.this.selectedFiles.get(i);
                        if (i >= DocumentsEditorPanel.this.filesToUpload.size()) continue;
                        BGServerFile serverFile = DocumentsEditorPanel.this.filesToUpload.get(i);
                        serverFile.setOwnerId(DocumentsEditorPanel.this.currentDocument.getId());
                        transferData.uploadFile("ru.bitel.bgbilling.plugins.documents/uploadDocumentFile", serverFile, file);
                    }
                }
                DocumentsEditorPanel.this.selectedFiles.clear();
                DocumentsEditorPanel.this.filesToUpload.clear();
                DocumentsEditorPanel.this.setVisible(false);
                DocumentsEditorPanel.this.parentPanel.setData();
            }
        };
        new AbstractBGUPanel.DefaultAction("uploadFile", "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent e) {
                BGFileChooser chooser = new BGFileChooser((Component)((Object)DocumentsEditorPanel.this.parentPanel));
                chooser.setCurrentDirectory(DocumentsEditorPanel.this.currentDirectory);
                chooser.setMultiSelectionEnabled(true);
                String extAndDescriptionString = DocumentsEditorPanel.this.pluginParameters.get(DocumentsEditorPanel.CLIENT_DOCUMENTS_CONTRACT_FILE_UPLOAD_EXTENSIONS);
                if (Utils.notBlankString((String)extAndDescriptionString)) {
                    chooser.setAcceptAllFileFilterUsed(false);
                    String[] extentionGroups = extAndDescriptionString.split(";");
                    if (extentionGroups.length > 0) {
                        for (String extentionDescriptionItem : extentionGroups) {
                            Object[] parts = extentionDescriptionItem.contains("-") ? extentionDescriptionItem.split("-") : new String[]{extentionDescriptionItem.trim(), extentionDescriptionItem.trim()};
                            if (parts.length != 2) continue;
                            chooser.addChoosableFileFilter((FileFilter)new BGFileFilter(((String)parts[0]).trim(), ((String)parts[1]).trim()));
                        }
                    }
                }
                if (chooser.showOpenDialog() == 0) {
                    String errorMessage;
                    File[] currentSelection = chooser.getSelectedFiles();
                    ArrayList<String> errorSizeFileNameList = new ArrayList<String>();
                    ArrayList<String> errorExtentionFileNameList = new ArrayList<String>();
                    long maxFileSize = DocumentsEditorPanel.this.pluginParameters.getLong(DocumentsEditorPanel.CLIENT_DOCUMENTS_MAX_FILE_SIZE, -1L);
                    for (File file : currentSelection) {
                        String fileExtension;
                        BGFileFilter bgFileFilter;
                        String filterExtension;
                        long fileSize = file.length();
                        if (maxFileSize > 0L && fileSize > maxFileSize) {
                            errorSizeFileNameList.add(file.getName());
                            continue;
                        }
                        FileFilter selectedFileFilter = chooser.getFileFilter();
                        if (selectedFileFilter instanceof BGFileFilter && !(filterExtension = (bgFileFilter = (BGFileFilter)selectedFileFilter).getExt()).contains(fileExtension = file.getName().substring(file.getName().lastIndexOf(".") + 1))) {
                            errorExtentionFileNameList.add(file.getName());
                            continue;
                        }
                        BGServerFile bgServerFile = new BGServerFile();
                        bgServerFile.setContractId(DocumentsEditorPanel.this.contractId);
                        bgServerFile.setDate(new Date());
                        bgServerFile.setTitle(file.getName());
                        bgServerFile.setComment("");
                        bgServerFile.setSize(fileSize);
                        DocumentsEditorPanel.this.filesToUpload.add(bgServerFile);
                        DocumentsEditorPanel.this.selectedFiles.add(file);
                        DocumentsEditorPanel.this.fileTableModel.addRow(bgServerFile);
                    }
                    if (errorSizeFileNameList.size() > 0) {
                        errorMessage = "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0424\u0430\u0439\u043b" + (errorSizeFileNameList.size() > 1 ? "\u044b " : " ") + errorSizeFileNameList + " \u043d\u0435 \u0431\u044b\u043b" + (errorSizeFileNameList.size() > 1 ? "\u0438 " : " ") + " \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d" + (errorSizeFileNameList.size() > 1 ? "\u044b" : "") + ", \u0442.\u043a. \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + maxFileSize + " \u0431\u0430\u0439\u0442";
                        BGToolTip.showErrorMessage((JComponent)DocumentsEditorPanel.this.uploadFileButton, (String)errorMessage, (int)7000);
                    }
                    if (errorExtentionFileNameList.size() > 0) {
                        errorMessage = "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0424\u0430\u0439\u043b" + (errorExtentionFileNameList.size() > 1 ? "\u044b " : " ") + errorExtentionFileNameList + " \u043d\u0435 \u0431\u044b\u043b" + (errorExtentionFileNameList.size() > 1 ? "\u0438 " : " ") + " \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d" + (errorExtentionFileNameList.size() > 1 ? "\u044b" : "") + ", \u0438\u0437-\u0437\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043d\u0430 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430!";
                        BGToolTip.showErrorMessage((JComponent)DocumentsEditorPanel.this.uploadFileButton, (String)errorMessage, (int)7000);
                    }
                }
            }
        };
        new AbstractBGUPanel.MenuAction("files.printFile", "\u041f\u0435\u0447\u0430\u0442\u044c \u0444\u0430\u0439\u043b\u0430"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                BGServerFile selectedFile = (BGServerFile)DocumentsEditorPanel.this.fileTableModel.getSelectedRow();
                if (selectedFile != null) {
                    File file = null;
                    if (!DocumentsEditorPanel.this.filesToUpload.isEmpty()) {
                        for (int i = 0; i < DocumentsEditorPanel.this.filesToUpload.size(); ++i) {
                            BGServerFile serverFile = DocumentsEditorPanel.this.filesToUpload.get(i);
                            if (!serverFile.getTitle().equals(selectedFile.getTitle())) continue;
                            file = DocumentsEditorPanel.this.selectedFiles.get(i);
                            break;
                        }
                    }
                    if (file == null) {
                        file = DocumentsEditorPanel.this.documentsService.getFileNetShare(selectedFile.getId(), selectedFile.getTitle());
                    }
                    if (file == null) {
                        DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                        TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                        String serverTitle = selectedFile.getTitle();
                        String preffix = serverTitle.substring(0, serverTitle.lastIndexOf("."));
                        String suffix = serverTitle.substring(serverTitle.lastIndexOf("."));
                        File tmpFile = File.createTempFile(preffix, suffix);
                        transferData.downloadFile("ru.bitel.bgbilling.plugins.documents/downloadDocumentFile", selectedFile.getId(), DocumentsEditorPanel.this.contractId, tmpFile);
                        file = tmpFile;
                    }
                    if (file != null) {
                        try {
                            Desktop.getDesktop().print(file);
                            return;
                        }
                        catch (Exception e) {
                            System.err.println(e.getMessage());
                            try {
                                Desktop.getDesktop().open(file);
                                return;
                            }
                            catch (Exception e2) {
                                System.err.println(e2.getMessage());
                            }
                        }
                    }
                } else {
                    ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                }
            }
        };
        new AbstractBGUPanel.MenuAction("files.OpenFile", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                BGServerFile selectedFile = (BGServerFile)DocumentsEditorPanel.this.fileTableModel.getSelectedRow();
                if (selectedFile != null) {
                    File file;
                    if (!DocumentsEditorPanel.this.filesToUpload.isEmpty()) {
                        for (int i = 0; i < DocumentsEditorPanel.this.filesToUpload.size(); ++i) {
                            BGServerFile serverFile = DocumentsEditorPanel.this.filesToUpload.get(i);
                            if (!serverFile.getTitle().equals(selectedFile.getTitle())) continue;
                            ClientUtils.openFile((File)DocumentsEditorPanel.this.selectedFiles.get(i));
                            return;
                        }
                    }
                    if ((file = DocumentsEditorPanel.this.documentsService.getFileNetShare(selectedFile.getId(), selectedFile.getTitle())) != null && file.exists()) {
                        ClientUtils.openFile((File)file);
                    } else {
                        DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                        TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                        String serverTitle = selectedFile.getTitle();
                        String preffix = serverTitle.substring(0, serverTitle.lastIndexOf("."));
                        String suffix = serverTitle.substring(serverTitle.lastIndexOf("."));
                        File tmpFile = File.createTempFile(preffix, suffix);
                        transferData.downloadFile("ru.bitel.bgbilling.plugins.documents/downloadDocumentFile", selectedFile.getId(), DocumentsEditorPanel.this.contractId, tmpFile);
                        ClientUtils.openFile((File)tmpFile);
                    }
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                }
            }
        };
        new AbstractBGUPanel.MenuAction("files.DownloadFile", "\u0412\u044b\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List selectedFiles = DocumentsEditorPanel.this.fileTableModel.getSelectedRows();
                if (selectedFiles.size() != 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u043e\u043b\u044c\u043a\u043e 1 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return;
                }
                BGFileChooser chooser = new BGFileChooser((Component)((Object)DocumentsEditorPanel.this.parentPanel));
                if (DocumentsEditorPanel.this.currentDirectory != null) {
                    if (!(!DocumentsEditorPanel.this.createCurrentDirectory || DocumentsEditorPanel.this.currentDirectory.exists() && DocumentsEditorPanel.this.currentDirectory.isDirectory() || DocumentsEditorPanel.this.currentDirectory.mkdirs())) {
                        JOptionPane.showMessageDialog((Component)BGClient.getFrame(), "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043a\u0430\u0442\u0430\u043b\u043e\u0433 " + DocumentsEditorPanel.this.currentDirectory.getName(), "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                    }
                    chooser.setCurrentDirectory(DocumentsEditorPanel.this.currentDirectory);
                }
                chooser.setMultiSelectionEnabled(false);
                File dir = chooser.getCurrentDirectory();
                File selfile = new File(dir.getAbsoluteFile() + File.separator + ((BGServerFile)selectedFiles.get(0)).getTitle());
                chooser.setSelectedFile(selfile);
                if (chooser.showSaveDialog() == 0) {
                    File file = chooser.getSelectedFile();
                    DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                    TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                    transferData.downloadFile("ru.bitel.bgbilling.plugins.documents/downloadDocumentFile", ((BGServerFile)selectedFiles.get(0)).getId(), DocumentsEditorPanel.this.contractId, file);
                }
            }
        };
        new AbstractBGUPanel.MenuAction("files.SendFile", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u043f\u043e \u043f\u043e\u0447\u0442\u0435"){

            public void actionPerformedImpl(ActionEvent actionEvent) {
                PropertyChangeListener propertyChangeListener = evt -> {
                    if (evt.getPropertyName().equals("selectEmail")) {
                        List files = DocumentsEditorPanel.this.fileTableModel.getSelectedRows();
                        if (files == null || files.size() == 0) {
                            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438!");
                            return;
                        }
                        try {
                            ArrayList filesIds = new ArrayList();
                            files.forEach(file -> filesIds.add(file.getId()));
                            List<String> emailsList = Arrays.asList(String.valueOf(evt.getNewValue()).split(","));
                            DocumentsEditorPanel.this.documentsService.sendFileByEmail(emailsList, filesIds);
                            ClientUtils.showMessageDialog((Object)"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b", (String)"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
                        }
                        catch (BGException e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                        }
                    }
                };
                BGEmailDialog emailDialog = new BGEmailDialog();
                emailDialog.addPropertyChangeListener(propertyChangeListener);
                emailDialog.loadEmailListFromContractParameter(DocumentsEditorPanel.this.contractId, 0);
                emailDialog.setVisible(true);
                emailDialog.removePropertyChangeListener(propertyChangeListener);
            }
        };
        new AbstractBGUPanel.MenuAction("files.SendLinkFiles", "\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u043d\u0430 \u0444\u0430\u0439\u043b\u044b \u043f\u043e \u043f\u043e\u0447\u0442\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                LeastTimeEditor editor = new LeastTimeEditor("\u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 c\u0441\u044b\u043b\u043a\u0438", 0);
                editor.open();
                int leastTime = editor.getData();
                PropertyChangeListener propertyChangeListener = evt -> {
                    List bgServerFiles = DocumentsEditorPanel.this.fileTableModel.getSelectedRows();
                    if (bgServerFiles.isEmpty()) {
                        bgServerFiles = DocumentsEditorPanel.this.fileTableModel.getRows();
                    }
                    if (bgServerFiles.isEmpty()) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u0442 \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
                    } else {
                        try {
                            List<Integer> fileIds = bgServerFiles.stream().map(BGServerFile::getId).toList();
                            List<String> emailsList = Arrays.asList(String.valueOf(evt.getNewValue()).split(","));
                            DocumentsEditorPanel.this.documentsService.sendDocumentLinkFiles(emailsList, DocumentsEditorPanel.this.currentDocument.getId(), fileIds, leastTime);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                };
                BGEmailDialog emailDialog = new BGEmailDialog();
                emailDialog.addPropertyChangeListener(propertyChangeListener);
                emailDialog.loadEmailListFromContractParameter(DocumentsEditorPanel.this.contractId, 0);
                emailDialog.setVisible(true);
                emailDialog.removePropertyChangeListener(propertyChangeListener);
            }
        };
        new AbstractBGUPanel.MenuAction("files.DeleteFile", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b"){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                List files = DocumentsEditorPanel.this.fileTableModel.getSelectedRows();
                if (files != null && files.size() > 0) {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b(\u044b)?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                        if (DocumentsEditorPanel.this.selectedFiles != null) {
                            Iterator deleteFilesIterator = files.iterator();
                            Iterator<BGServerFile> uploadFilesIterator = DocumentsEditorPanel.this.filesToUpload.iterator();
                            while (deleteFilesIterator.hasNext()) {
                                BGServerFile delFile = (BGServerFile)deleteFilesIterator.next();
                                while (uploadFilesIterator.hasNext()) {
                                    BGServerFile uploadFile = uploadFilesIterator.next();
                                    if (!delFile.getTitle().equals(uploadFile.getTitle())) continue;
                                    deleteFilesIterator.remove();
                                    uploadFilesIterator.remove();
                                }
                            }
                        }
                        ArrayList<Integer> fileIdsList = new ArrayList<Integer>();
                        for (BGServerFile bgServerFile : files) {
                            fileIdsList.add(bgServerFile.getId());
                        }
                        DocumentsEditorPanel.this.documentsService.deleteDocumentFiles(fileIdsList);
                        if (DocumentsEditorPanel.this.currentDocument != null) {
                            DocumentsEditorPanel.this.fileTableModel.setData(DocumentsEditorPanel.this.documentsService.getDocumentFileList(DocumentsEditorPanel.this.currentDocument.getId()));
                        } else {
                            DocumentsEditorPanel.this.fileTableModel.getRows().remove(DocumentsEditorPanel.this.fileTableModel.getSelectedRow());
                            DocumentsEditorPanel.this.fileTableModel.fireTableDataChanged();
                        }
                    }
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b(\u044b) \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                }
            }
        };
    }

    class StatusLogTableModel
    extends BGTableModel<DocumentStatusLogItem> {
        public StatusLogTableModel() {
            super(StatusLogTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 125, 150, 170, "statusDate", false, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 200, 200, "status", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, 200, 300, "user", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(DocumentStatusLogItem val, int column) throws BGException {
            return switch (column) {
                case 1 -> {
                    DocumentStatus status = (DocumentStatus)DocumentsEditorPanel.this.statusDirectory.get(val.getStatusId());
                    yield status != null ? status.getTitle() : "<\u0421\u0442\u0430\u0442\u0443\u0441 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
                case 3 -> {
                    UserInfo user = (UserInfo)DocumentsEditorPanel.this.userDirectory.get(val.getUserId());
                    yield user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
                default -> super.getValue((Object)val, column);
            };
        }
    }

    class FileTableModel
    extends BGTableModel<BGServerFile> {
        public FileTableModel() {
            super("files");
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430", -1, 200, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0437\u043c\u0435\u0440", 90, 90, 90, "size", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438", 150, 150, 150, "date", false, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 200, 200, "userId", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }

        public Object getValue(BGServerFile val, int column) {
            try {
                if (column == 4) {
                    UserInfo user = (UserInfo)DocumentsEditorPanel.this.userDirectory.get(val.getUserId());
                    return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
                return super.getValue((Object)val, column);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return null;
            }
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            BGServerFile selectedFile = (BGServerFile)DocumentsEditorPanel.this.fileTableModel.getSelectedRow();
            String oldComment = selectedFile.getComment();
            String oldTitle = selectedFile.getTitle();
            switch (columnIndex) {
                case 0: {
                    String title = (String)value;
                    if (!Utils.notBlankString((String)title) || oldTitle.equals(title)) break;
                    selectedFile.setTitle(title);
                    break;
                }
                case 1: {
                    String comment = (String)value;
                    if (oldComment.equals(comment)) break;
                    selectedFile.setComment(comment);
                    break;
                }
            }
            if (!oldComment.equals(selectedFile.getComment()) || !oldTitle.equals(selectedFile.getTitle())) {
                try {
                    DocumentsEditorPanel.this.documentsService.updateDocumentFile(selectedFile);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }
    }

    class LeastTimeButton
    extends JToggleButton {
        public LeastTimeButton(String text, String actionCommand, ButtonGroup buttonGroup) {
            super(text);
            this.setActionCommand(actionCommand);
            buttonGroup.add(this);
        }
    }

    class LeastTimeEditor
    extends BGEditorDialog<Integer> {
        private ButtonGroup buttonGroup;
        private LeastTimeButton button01;
        private LeastTimeButton button02;
        private LeastTimeButton button03;
        private LeastTimeButton button04;
        private LeastTimeButton button05;
        private LeastTimeButton button06;
        private LeastTimeButton button07;
        private LeastTimeButton button08;
        private LeastTimeButton button09;
        private LeastTimeButton button10;
        private LeastTimeButton button11;
        private LeastTimeButton button12;
        private LeastTimeButton button13;
        private LeastTimeButton button14;
        private LeastTimeButton button15;
        private LeastTimeButton button16;
        private LeastTimeButton button17;
        private LeastTimeButton button18;
        private LeastTimeButton button19;
        private LeastTimeButton button20;

        public LeastTimeEditor(String title, Integer data) {
            super(title, (Object)data);
            this.buttonGroup = new ButtonGroup();
            this.button01 = new LeastTimeButton("5 \u043c\u0438\u043d", "300", this.buttonGroup);
            this.button02 = new LeastTimeButton("10 \u043c\u0438\u043d", "600", this.buttonGroup);
            this.button03 = new LeastTimeButton("20 \u043c\u0438\u043d", "1200", this.buttonGroup);
            this.button04 = new LeastTimeButton("30 \u043c\u0438\u043d", "1800", this.buttonGroup);
            this.button05 = new LeastTimeButton("1 \u0447\u0430\u0441", "3600", this.buttonGroup);
            this.button06 = new LeastTimeButton("3 \u0447\u0430\u0441\u0430", "10800", this.buttonGroup);
            this.button07 = new LeastTimeButton("5 \u0447\u0430\u0441\u043e\u0432", "18000", this.buttonGroup);
            this.button08 = new LeastTimeButton("12 \u0447\u0430\u0441\u043e\u0432", "43200", this.buttonGroup);
            this.button09 = new LeastTimeButton("1 \u0434\u0435\u043d\u044c", "86400", this.buttonGroup);
            this.button10 = new LeastTimeButton("3 \u0434\u043d\u044f", "259200", this.buttonGroup);
            this.button11 = new LeastTimeButton("5 \u0434\u043d\u0435\u0439", "432000", this.buttonGroup);
            this.button12 = new LeastTimeButton("15 \u0434\u043d\u0435\u0439", "1296000", this.buttonGroup);
            this.button13 = new LeastTimeButton("1 \u043c\u0435\u0441\u044f\u0446", "2592000", this.buttonGroup);
            this.button14 = new LeastTimeButton("3 \u043c\u0435\u0441\u044f\u0446\u0430", "7776000", this.buttonGroup);
            this.button15 = new LeastTimeButton("6 \u043c\u0435\u0441\u044f\u0446\u0435\u0432", "15552000", this.buttonGroup);
            this.button16 = new LeastTimeButton("9 \u043c\u0435\u0441\u044f\u0446\u0435\u0432", "23328000", this.buttonGroup);
            this.button17 = new LeastTimeButton("1 \u0433\u043e\u0434", "31536000", this.buttonGroup);
            this.button18 = new LeastTimeButton("3 \u0433\u043e\u0434\u0430", "94608000", this.buttonGroup);
            this.button19 = new LeastTimeButton("5 \u043b\u0435\u0442", "157680000", this.buttonGroup);
            this.button20 = new LeastTimeButton("\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u0430\u044f", "0", this.buttonGroup);
            this.button20.setSelected(true);
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.button01, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button02, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button03, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button04, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 20, 5), 0, 0));
            this.panel.add((Component)this.button05, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button06, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button07, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button08, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 20, 5), 0, 0));
            this.panel.add((Component)this.button09, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button10, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button11, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button12, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 20, 5), 0, 0));
            this.panel.add((Component)this.button13, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button14, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button15, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button16, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 20, 5), 0, 0));
            this.panel.add((Component)this.button17, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button18, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button19, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.button20, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 20, 5), 0, 0));
        }

        public boolean doApply() throws Exception {
            this.data = Integer.valueOf(this.buttonGroup.getSelection().getActionCommand());
            return super.doApply();
        }

        public Integer getData() {
            return (Integer)super.getData();
        }
    }
}

