/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.file;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.documents.server.bean.DocumentDao;
import ru.bitel.bgbilling.plugins.documents.server.filestorage.DocumentsFileStorage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;

public class FileUtils {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.documents");

    public void downloadDocumentFile(HttpServletRequest request, HttpServletResponse response) throws BGException {
        int fileId = Utils.parseInt((String)request.getHeader("bgbilling-file-id"));
        int contractId = Utils.parseInt((String)request.getHeader("bgbilling-contract-id"));
        if (fileId <= 0) {
            throw new BGIllegalArgumentException();
        }
        FileStorage documentsFileStorage = this.getFileStorage();
        BGServerFile serverFile = documentsFileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        try (DocumentDao documentDao = new DocumentDao(Setup.getSetup().getDBConnection());){
            serverFile.setContractId(documentDao.getDocumentOwnerId(serverFile.getOwnerId()));
        }
        if (serverFile.getContractId() != contractId) {
            throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; cid = " + contractId + "; file_cid = " + serverFile.getContractId());
        }
        JSONObject serverFileJson = new JSONObject();
        BGServerFile.toJSON((BGServerFile)serverFile, (JSONObject)serverFileJson);
        response.setContentType("application/octet-stream");
        response.setHeader("bgbilling-file-info", Base64.encode((String)serverFileJson.toString()));
        try {
            Path path = Paths.get(documentsFileStorage.getFileName(fileId), new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).", (Throwable)new FileNotFoundException());
            }
            response.getOutputStream().write(Files.readAllBytes(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void uploadDocumentFile(BGServerFile serverFile, InputStream inputStream) throws BGException {
        try {
            Path path = Files.createTempFile("aaa", "bbb", new FileAttribute[0]);
            Files.write(path, Utils.readByBlock((InputStream)inputStream), new OpenOption[0]);
            this.uploadDocumentFile(serverFile, path);
        }
        catch (IOException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
        }
    }

    public void uploadDocumentFile(BGServerFile serverFile, Path path) throws BGException {
        FileStorage documentsFileStorage = this.getFileStorage();
        documentsFileStorage.updateFile(serverFile);
        if (serverFile.getId() > 0) {
            try {
                String rootPath = this.plugin.getSetup().get("file.net.share.root.path");
                if (!Utils.isEmptyString((String)rootPath)) {
                    String fileExtension = serverFile.getTitle().substring(serverFile.getTitle().lastIndexOf(".") + 1);
                    documentsFileStorage.saveFile(serverFile.getId(), path, fileExtension);
                }
                documentsFileStorage.saveFile(serverFile.getId(), path, null);
            }
            catch (Exception e) {
                documentsFileStorage.deleteFile(serverFile.getId());
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
            }
        } else {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
        }
    }

    public FileStorage getFileStorage() throws BGException {
        return new DocumentsFileStorage(Setup.getSetup().getDBConnection());
    }
}

