/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class PackageTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"package.png");
    private JPanel editor;
    private JLabel view;
    private BGComboBox<IdTitle> packageCb;
    private int packageId;
    private Directory packageDir;

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.packageDir = this.getDirManager().getDirectory("package");
    }

    protected JPanel getEditorPanel() {
        if (this.editor == null) {
            this.editor = new JPanel();
            this.packageCb = new BGComboBox();
            this.buildDirectoryCombo(this.packageDir, (JComboBox)this.packageCb);
            this.editor.add(new JLabel("\u041f\u0430\u043a\u0435\u0442: "));
            this.editor.add((Component)this.packageCb);
        }
        return this.editor;
    }

    public Component getView() {
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        this.extractData();
        String packageTitle = this.packageDir.getValue(this.packageId);
        StringBuilder sb = new StringBuilder();
        sb.append("\u041f\u0430\u043a\u0435\u0442 ");
        if (packageTitle != null) {
            sb.append(packageTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.packageCb, this.packageId);
    }

    protected void serializeData() {
        this.packageId = this.getIdFromDirectoryCombo((JComboBox)this.packageCb);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("package", String.valueOf(this.packageId));
        this.setDataInHash(data);
    }

    private void extractData() {
        Map data = this.getDataInHash();
        this.packageId = Utils.parseInt((String)((String)data.get("package")));
    }
}

