/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Package;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.PackageContract;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ActionUpdateContractPackage
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        PackageManager packageManager = new PackageManager(this.con, this.plugin);
        int packageId = this.getIntParameter("id", -1);
        Package pkg = packageManager.getPackage(packageId);
        if (pkg != null) {
            Date now = new Date();
            Charge charge = new Charge();
            charge.setContractId(this.cid);
            charge.setDate(now);
            charge.setTypeId(pkg.getChargeId());
            charge.setSum(pkg.getSumma());
            charge.setComment(pkg.getTitle() + " [" + pkg.getCount() + "\u043e\u0431\u0440. \u0437\u0430 " + pkg.getPeriod() + "\u0434\u043d.]");
            new ChargeDao(this.con).update((Object)charge);
            PackageContract packageContract = new PackageContract();
            packageContract.setId(-1);
            packageContract.setChargeId(charge.getId());
            packageContract.setContractId(this.cid);
            packageContract.setPackageId(pkg.getId());
            packageContract.setCount(pkg.getCount());
            packageContract.setCountUse(0);
            packageContract.setDateFrom(now);
            packageContract.setDateTo(new Date(now.getTime() + 86400000L * (long)pkg.getPeriod()));
            packageContract.setSumma(pkg.getSumma());
            packageContract.setUserId(this.userId.intValue());
            packageManager.updatePackageContract(packageContract);
            ServerUtils.commitConnection((Connection)this.con);
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.updateBalance(charge.getDate(), this.cid);
            bu.close();
            this.context.publishAfterCommit((Event)new ChargeEvent(0, charge));
            this.context.publishAfterCommit((Event)new ContractBalanceChangedEvent(this.cid, 4, charge.getSum()));
        }
    }
}

