/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;

public class ActionGetTopicList
extends AppsAbstractAction {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    public void execute() throws BGException {
        int count;
        boolean archive = "archive".equals(this.getParameter("mode"));
        boolean needInit = Utils.parseBoolean((String)this.getParameter("needInit"), (boolean)true);
        TopicListFilter topicListFilter = new TopicListFilter();
        topicListFilter.setContractId(this.contractId);
        topicListFilter.setClosed(archive);
        topicListFilter.setPage(new Page(1, 666));
        topicListFilter.setAllMessage(true);
        topicListFilter.setNewUserMessage(false);
        topicListFilter.setNewManagerMessage(true);
        topicListFilter.setTopicId(this.getIntParameter("topicId", -1));
        topicListFilter.setTitle(this.getParameter("topicName"));
        topicListFilter.setPeriod(this.getPeriod());
        topicListFilter.setSearchString(this.getParameter("searchString"));
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        this.actionMap.put("topicList", topicManager.getTopicList(topicListFilter));
        if (!archive && needInit) {
            this.actionMap.put("statusMap", topicManager.getStatusMap());
            HelpDeskDirectoryManager manager = new HelpDeskDirectoryManager(this.con, this.plugin);
            int groupId = manager.getContractGroupId(this.contractId);
            if (groupId > 0) {
                Map<Integer, List<Integer>> map = manager.getSubCategoryIds(groupId);
                this.actionMap.put("categoryMap", map);
                ArrayList<IdTitle> categoryList = new ArrayList<IdTitle>(map.size());
                HashSet<Integer> subCategorySet = new HashSet<Integer>();
                for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
                    int idCategory = entry.getKey();
                    String categoryTitle = manager.getCategoryTitle(idCategory);
                    categoryList.add(new IdTitle(idCategory, categoryTitle));
                    subCategorySet.addAll((Collection<Integer>)entry.getValue());
                }
                this.actionMap.put("categoryList", categoryList);
                this.actionMap.put("subCategoryList", manager.getSubcategory(subCategorySet));
            }
        }
        if (!archive && (count = topicManager.getManagersNewMessagesCount(this.contractId)) > 0) {
            this.actionMap.put("unreadMessages", count);
        }
    }
}

