/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.DetailRecord;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RangeCleaner;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateDAO;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.RecalculateTask;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxRecalculateManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficMaxTarifficationManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficRangeRecalculateManager;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.TrafficRangeTarrificationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeRecalculateManager;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Pair;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.TaskDistrubuter;
import ru.bitel.common.worker.ThreadContextFactory;

public class SessionRecalculateTarifficationManager<R extends RangeRecalculateManager>
implements Runnable {
    private static final Logger logger = LogManager.getLogger();
    protected String sessionAccountLogTableName;
    protected String sessionLogTableName;
    protected final String sessionLogDetailTableName;
    protected final String servTableName;
    protected int idDivizor;
    protected int idRemainder;
    protected Set<Integer> cids;
    protected Date dateFrom;
    protected Date dateTo;
    protected final Setup setup;
    protected PreparedStatement detailPS;
    protected ResultSet detailRS;
    protected TrafficMaxRecalculateManager maxRecalculateManager;
    protected R rangeRecalculateManager;
    protected Set<Integer> affectedContracts = Collections.newSetFromMap(new ConcurrentHashMap());
    protected Map<Integer, BigDecimal> accountMapForContract = new HashMap<Integer, BigDecimal>();
    protected Map<Long, InetConnectionRuntime> connectionMapForContract = new HashMap<Long, InetConnectionRuntime>();
    protected int roundingScale;
    protected int roundingMode;
    protected boolean needSlave = true;
    private Set<Integer> inetServiceSet;
    public final Accounting accounting;
    protected Connection conForDetail = null;
    private final int maxDetailFetch;
    private boolean calculateOk = false;

    @Override
    public void run() {
        try {
            BGNestedContext.push((String)"recalculate");
            this.recalculate();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.calculateOk = false;
        }
        finally {
            BGNestedContext.pop();
        }
    }

    public SessionRecalculateTarifficationManager(Accounting accounting, int idDivizor, int idRemainder, Set<Integer> cids, Date dateFrom, Date dateTo) throws BGException {
        this.accounting = accounting;
        this.idDivizor = idDivizor;
        this.idRemainder = idRemainder;
        this.cids = cids;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.setup = accounting.setup;
        this.maxDetailFetch = accounting.setup.getInt("session.recalculate.max.detail.fetch", 100000);
        this.sessionAccountLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)dateFrom, (int)accounting.moduleId);
        this.sessionLogDetailTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)dateFrom, (int)accounting.moduleId);
        this.sessionLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)dateFrom, (int)accounting.moduleId);
        this.servTableName = "inet_serv_" + accounting.moduleId;
        accounting.tariffContext.maxTrafficManager = new TrafficMaxTarifficationManager(accounting.moduleId, dateFrom);
        accounting.tariffContext.rangedTrafficManager = new TrafficRangeTarrificationManager(accounting.moduleId, dateFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate() throws BGException {
        logger.info("starting " + this.getClass().getName());
        ServerContext context = (ServerContext)ServerContext.get();
        ConnectionSet connectionSet = context.getConnectionSet();
        Connection con = connectionSet.getConnection();
        this.conForDetail = this.needSlave ? this.accounting.setup.getDBSlaveConnectionFromPool() : this.accounting.setup.getDBConnectionFromPool();
        InetServRuntimeMap inetServRuntimeMap = this.accounting.inetServRuntimeMap;
        InetDeviceRuntimeMap deviceRuntimeMap = this.accounting.deviceMap;
        try {
            ThreadContextFactory<InetTariffWorkerContext> threadContextFactory = new ThreadContextFactory<InetTariffWorkerContext>(){

                public InetTariffWorkerContext newThreadContext() {
                    return new InetTariffWorkerContext(SessionRecalculateTarifficationManager.this.accounting.setup, SessionRecalculateTarifficationManager.this.accounting.moduleId);
                }
            };
            TaskDistrubuter taskDistrubuter = new TaskDistrubuter(3, this.setup, (ThreadContextFactory)threadContextFactory, "recalculate");
            Statement st = con.createStatement();
            TrafficMaxDao.checkTables(con, st, this.dateFrom, this.accounting.moduleId);
            st.close();
            logger.debug("max traffs ineted ");
            this.initDetailPSAndRS(this.dateFrom, this.conForDetail);
            logger.debug("ps inited ");
            int currentContractId = -1;
            logger.debug("starting recalculate ");
            RecalculateTask currentTask = null;
            List<DetailRecord> records = null;
            while ((records = this.loadDetailFromBD()) != null && records.size() > 0) {
                boolean taskChanged = false;
                for (DetailRecord record : records) {
                    if (currentContractId != record.getContractId()) {
                        if (!taskChanged) {
                            if (currentTask != null) {
                                taskDistrubuter.putNextTask((Callable)currentTask);
                            }
                            currentTask = this.createTask(inetServRuntimeMap, deviceRuntimeMap);
                            taskChanged = true;
                        }
                        currentContractId = record.getContractId();
                    }
                    currentTask.addRecord(record);
                }
                records.clear();
            }
            if (currentTask != null) {
                taskDistrubuter.putNextTask(currentTask);
            }
            taskDistrubuter.finish();
            this.removeAllExtraData(con);
            this.detailPS.close();
            this.calculateOk = true;
            logger.info("end " + this.getClass().getName());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            this.calculateOk = false;
        }
        finally {
            try {
                this.freeResources();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ServerUtils.closeConnection((Connection)this.conForDetail);
        }
    }

    protected List<DetailRecord> loadDetailFromBD() throws SQLException {
        ArrayList<DetailRecord> result = new ArrayList<DetailRecord>();
        while (this.detailRS.next()) {
            int contractId = this.detailRS.getInt("contractId");
            long connectionId = this.detailRS.getLong("connectionId");
            long sessionId = this.detailRS.getLong("sessionId");
            int day = this.detailRS.getInt("day");
            int hour = this.detailRS.getInt("hour");
            int trafficTypeId = this.detailRS.getInt("trafficTypeId");
            long amount = this.detailRS.getLong("amount");
            int deviceState = this.detailRS.getInt("deviceState");
            if (this.detailRS.wasNull()) {
                deviceState = InetServState.STATE_ENABLE.getCode();
            }
            DetailRecord detailRecord = new DetailRecord(contractId, connectionId, sessionId, day, hour, trafficTypeId, amount, deviceState);
            result.add(detailRecord);
            if (result.size() <= this.maxDetailFetch) continue;
            return result;
        }
        return result;
    }

    protected RecalculateDAO initDAO(Connection con) throws SQLException {
        RecalculateDAO dao = new RecalculateDAO(this.dateFrom, this.dateTo, this.accounting.moduleId, con);
        dao.init();
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllExtraData(Connection con) throws BGException, SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        RecalculateDAO recalculateDAO = this.initDAO(con);
        this.initMaxAndRangeManagers(con);
        try (BalanceDao balanceDao = new BalanceDao(con);){
            recalculateDAO.removeAllExtraData(this.getInetServiceSet(), this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            this.maxRecalculateManager.removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            ((RangeCleaner)this.rangeRecalculateManager).removeAllExtraData(this.dateFrom, this.cids, this.idDivizor, this.idRemainder, this.affectedContracts);
            recalculateDAO.removeExtraContractAccount(this.cids, yy, mm, this.getInetServiceSet(), this.affectedContracts);
            Set<Pair<Integer, Integer>> contractsForUpdateBalance = recalculateDAO.getContractsForUpdateBalance();
            for (Pair<Integer, Integer> pair : contractsForUpdateBalance) {
                Integer contractId = (Integer)pair.getFirst();
                Integer superContractId = (Integer)pair.getSecond();
                BigDecimal balanceAccount = balanceDao.setBalanceAccount(contractId.intValue(), superContractId.intValue(), yy, mm);
                this.accounting.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId.intValue(), 2, yy, mm, balanceAccount));
            }
        }
        finally {
            this.maxRecalculateManager.close();
            this.rangeRecalculateManager.close();
            recalculateDAO.recycle();
        }
    }

    protected RecalculateTask createTask(InetServRuntimeMap inetServRuntimeMap, InetDeviceRuntimeMap deviceRuntimeMap) throws SQLException {
        logger.debug("Add new task ");
        return new RecalculateTask(this, this.accounting);
    }

    protected void initMaxAndRangeManagers(Connection con) throws SQLException {
        this.maxRecalculateManager = new TrafficMaxRecalculateManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.maxTrafficManager);
        this.rangeRecalculateManager = new TrafficRangeRecalculateManager(con, this.dateFrom, this.dateTo, this.accounting.moduleId, this.accounting.tariffContext.rangedTrafficManager);
    }

    protected void initDetailPSAndRS(Date month, Connection con) throws SQLException {
        String query = "SELECT serv.contractId, session.connectionId, detail.sessionId, detail.day, detail.hour, detail.trafficTypeId, SUM(detail.amount) as amount,  session.deviceState  FROM " + this.sessionLogDetailTableName + " AS detail INNER JOIN " + this.sessionLogTableName + " AS session ON detail.sessionId = session.id INNER JOIN " + this.servTableName + " AS serv ON session.servId = serv.id ";
        query = query + " WHERE 1 = 1 ";
        query = query + this.addDetailFilter();
        query = query + " AND " + (String)(this.cids.size() > 0 ? " serv.contractId IN (" + Utils.toString(this.cids) + ")" : " serv.contractId % ? = ? ");
        query = query + " AND detail.day > 0 ";
        query = query + " GROUP BY serv.contractId, detail.day, detail.hour, session.connectionId, detail.sessionId, detail.trafficTypeId  ORDER BY serv.contractId, detail.day, detail.hour, session.connectionId, detail.sessionId, detail.trafficTypeId ";
        this.detailPS = con.prepareStatement(query, 1003, 1007);
        int idx = this.addDetailFilterParams(this.detailPS);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(this.detailPS, idx, this.cids, this.idDivizor, this.idRemainder);
        this.detailPS.setFetchSize(Integer.MIN_VALUE);
        this.detailRS = this.detailPS.executeQuery();
    }

    protected int addDetailFilterParams(PreparedStatement ps) throws SQLException {
        return 1;
    }

    protected String addDetailFilter() {
        return "";
    }

    public Set<Integer> getInetServiceSet() {
        if (this.inetServiceSet == null) {
            List list = ModuleCache.getInstance().getModuleServicesList(this.accounting.moduleId);
            this.inetServiceSet = new HashSet<Integer>();
            this.inetServiceSet.addAll(list.stream().map(l -> l.getId()).collect(Collectors.toList()));
            if (this.inetServiceSet.size() == 0) {
                this.inetServiceSet.add(-1);
            }
        }
        return this.inetServiceSet;
    }

    public static int setDivizorAndRemainder(PreparedStatement ps, int idx, Set<Integer> cids, int idDivizor, int idRemainder) throws SQLException {
        if (cids.size() == 0) {
            ps.setInt(idx++, idDivizor);
            ps.setInt(idx++, idRemainder);
        }
        return idx;
    }

    public static String getSqlAndcidPartWithAffected(Set<Integer> cids, Set<Integer> affectedContracts) {
        return SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts, "");
    }

    public static String getSqlAndcidPartWithAffected(Set<Integer> cids, Set<Integer> affectedContracts, String tableName) {
        Object andCidPartWithAffected = "";
        andCidPartWithAffected = cids.size() > 0 ? " AND " + tableName + "cid IN (" + Utils.toString(cids) + ")" : " AND " + tableName + "cid % ? = ? ";
        andCidPartWithAffected = (String)andCidPartWithAffected + " AND " + tableName + "cid NOT IN (" + (affectedContracts.size() > 0 ? Utils.toString(affectedContracts) : " -1") + " )";
        return andCidPartWithAffected;
    }

    protected void freeResources() throws SQLException {
    }

    public boolean isCalculateOk() {
        return this.calculateOk;
    }
}

