/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.bean;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.common.event.InetDeviceModifiedEvent;
import ru.bitel.bgbilling.modules.inet.common.event.InetDeviceTypeModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetReloadLocalEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortDao;

public class InetDeviceMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final ParameterMap EMPTY_CONFIG = new ParameterMap.DefaultParameterMap(Collections.emptyMap());
    private static final ConcurrentMap<Integer, InetDeviceMap> moduleMap = new ConcurrentHashMap<Integer, InetDeviceMap>();
    private final int moduleId;
    private volatile Map<Integer, InetDeviceMapItem> deviceMap;
    private volatile boolean nasRadiusFix = true;
    private final AtomicLong version = new AtomicLong();

    public static synchronized InetDeviceMap getInstance(int moduleId) throws BGException {
        InetDeviceMap result = (InetDeviceMap)moduleMap.get(moduleId);
        if (result == null) {
            result = new InetDeviceMap(moduleId);
            moduleMap.put(moduleId, result);
        }
        return result;
    }

    InetDeviceMap(int moduleId) throws BGException {
        this.moduleId = moduleId;
        EventProcessor.getInstance().addListener((EventListener)this, InetReloadLocalEvent.class, moduleId, null);
        EventProcessor.getInstance().addListener((EventListener)this, InetDeviceModifiedEvent.class);
        EventProcessor.getInstance().addListener((EventListener)this, InetDeviceTypeModifiedEvent.class);
    }

    public long getVersion() {
        return this.version.get();
    }

    private Map<Integer, InetDeviceMapItem> load() throws BGException {
        logger.info("(Re)loading InetDeviceMap");
        long start = System.currentTimeMillis();
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);){
            HashMap<Integer, InetDeviceMapItem> hashMap;
            try (InetDeviceDao inetDeviceDao = new InetDeviceDao(connectionSet.getConnection(), this.moduleId);){
                this.nasRadiusFix = moduleSetup.getInt("nas.radius.legacy.fix", 0) > 0;
                HashMap<String, String> bundleParams = new HashMap<String, String>();
                Preferences bundlePreferences = setup != null ? setup.getBundlePreferences() : null;
                for (Map.Entry e : bundlePreferences.entrySet()) {
                    String key = (String)e.getKey();
                    if ("db.driver".equals(key) || "db.url".equals(key) || "db.user".equals(key) || "db.pswd".equals(key) || "mq.url".equals(key) || "mq.user".equals(key) || "mq.pswd".equals(key)) continue;
                    bundleParams.put((String)e.getKey(), (String)e.getValue());
                }
                bundlePreferences = bundleParams.size() == 0 ? null : new Preferences(bundleParams, false, false);
                DevicePortDao devicePortDao = new DevicePortDao(connectionSet.getConnection(), this.moduleId);
                InetDevice rootDevice = inetDeviceDao.root(DeviceTreeFilter.builder().setLoadDeviceGroupLink(false).build(), false);
                Directory deviceTypeDir = ServerDirectoryFactory.newUnmodifiableDirectory(InetDeviceType.class, (Connection)connectionSet.getConnection(), (int)this.moduleId, (boolean)false);
                Map deviceTypeMap = Id.newMap((List)deviceTypeDir.list());
                GregorianCalendar closePeriod = new GregorianCalendar();
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)closePeriod);
                closePeriod.set(5, 1);
                ((Calendar)closePeriod).add(2, -6);
                HashMap<Integer, InetDeviceMapItem> idMap = new HashMap<Integer, InetDeviceMapItem>();
                this.loadDevice(bundlePreferences, (ParameterMap)moduleSetup, idMap, devicePortDao, deviceTypeMap, rootDevice, null, closePeriod.getTime());
                this.version.incrementAndGet();
                logger.info("Reloading of the device map completed for " + (System.currentTimeMillis() - start) + " ms");
                hashMap = idMap;
            }
            return hashMap;
        }
    }

    private void loadDevice(Preferences bundlePreferences, ParameterMap moduleSetup, Map<Integer, InetDeviceMapItem> idMap, DevicePortDao devicePortDao, Map<Integer, InetDeviceType> deviceTypeMap, InetDevice inetDevice, InetDeviceMapItem parent, Date closePeriod) throws BGException {
        int deviceTypeId = inetDevice.getDeviceTypeId();
        InetDeviceType inetDeviceType = deviceTypeMap.get(deviceTypeId);
        if (inetDeviceType == null) {
            inetDeviceType = (InetDeviceType)inetDevice.getDeviceType();
        }
        Preferences vars = new Preferences(false, false);
        vars.set("deviceId", String.valueOf(inetDevice.getId()));
        Object stringConfig = Utils.notBlankString((String)inetDevice.getInvConfig()) ? (Utils.notBlankString((String)inetDevice.getConfig()) ? inetDevice.getInvConfig() + "\n" + inetDevice.getConfig() : inetDevice.getInvConfig()) : (Utils.notBlankString((String)inetDevice.getConfig()) ? inetDevice.getConfig() : "");
        Object config = null;
        ParameterMap selfConfig = null;
        if (Utils.notBlankString((String)stringConfig)) {
            config = new Preferences((ParameterMap)vars, (String)stringConfig, "\n", false, false);
        }
        if (inetDeviceType != null && Utils.notBlankString((String)inetDeviceType.getConfig())) {
            config = config != null ? new Preferences((ParameterMap)vars, inetDeviceType.getConfig(), "\n", false, false).inherit(config) : new Preferences((ParameterMap)vars, inetDeviceType.getConfig(), "\n", false, false);
        }
        if (parent != null) {
            if (config != null) {
                selfConfig = config;
                config = parent.config.inherit(config);
            } else {
                selfConfig = EMPTY_CONFIG;
                config = parent.config;
            }
        } else {
            if (config == null) {
                config = new Preferences((ParameterMap)vars, (String)stringConfig, "\n", false, false);
            }
            selfConfig = config;
            if (moduleSetup != null) {
                config = moduleSetup.inherit(config);
            }
            if (bundlePreferences != null) {
                config = bundlePreferences.inherit(config);
            }
        }
        if (this.nasRadiusFix) {
            Preferences fix = new Preferences(false, false);
            this.fix((ParameterMap)config, fix, "radius.", "nas.radius.");
            this.fix((ParameterMap)config, fix, "nas.radius.", "radius.");
            this.fix((ParameterMap)config, fix, "nas.radius.realm.reject.", "radius.disable.");
            config = fix.inherit(config);
        }
        Map<Integer, List<Integer>> flowAgentIfaceMap = InetDeviceMap.parseFlowAgentMap(inetDevice.getInvDeviceId(), inetDevice.getId(), config, devicePortDao);
        InetDeviceMapItem holder = new InetDeviceMapItem(parent, inetDevice, (ParameterMap)config, selfConfig, flowAgentIfaceMap);
        idMap.put(inetDevice.getId(), holder);
        InetDeviceMapItem iteratorParent = parent;
        while (iteratorParent != null) {
            iteratorParent.descendantIds0.add(inetDevice.getId());
            iteratorParent = iteratorParent.parent;
        }
        List children = inetDevice.getChildren();
        if (children != null && children.size() > 0) {
            for (InetDevice child : children) {
                if (child.getDateTo() != null && child.getDateTo().before(closePeriod)) {
                    logger.info("Skip load device:" + child.getId() + " and it children due to close period");
                    continue;
                }
                this.loadDevice(bundlePreferences, moduleSetup, idMap, devicePortDao, deviceTypeMap, child, holder, closePeriod);
            }
        }
    }

    public void fix(ParameterMap params, Preferences fix, String prefixOld, String prefixNew) {
        for (Map.Entry e : params.entrySet()) {
            String paramKey = (String)e.getKey();
            if (!paramKey.startsWith(prefixOld)) continue;
            String suffix = paramKey.substring(prefixOld.length(), paramKey.length());
            fix.set(prefixNew + suffix, (String)e.getValue());
        }
    }

    public static Map<Integer, List<Integer>> parseFlowAgentMap(int invDeviceId, int deviceId, ParameterMap config, DevicePortDao devicePortDao) throws BGException {
        String flowAgentLink;
        boolean fixed;
        if (logger.isDebugEnabled()) {
            logger.debug("parseFlowAgentMap for deviceId=" + deviceId);
        }
        boolean bl = fixed = (flowAgentLink = config.get("flow.agent.link", "")).contains(";") || flowAgentLink.split("\\s*:\\s*").length <= 2;
        if (logger.isDebugEnabled()) {
            logger.debug("flowAgentLink=" + flowAgentLink + "; fixed=" + fixed);
        }
        Map<Integer, List<Integer>> result = new HashMap<Integer, List<Integer>>();
        for (String param : flowAgentLink.split(fixed ? "\\s*;\\s*" : "\\s*,\\s*")) {
            if (logger.isDebugEnabled()) {
                logger.debug("param=" + param);
            }
            if (Utils.isBlankString((String)param)) continue;
            Object[] pair = param.split("\\s*:\\s*");
            if (logger.isDebugEnabled()) {
                logger.debug("pair=" + Utils.toString((Object[])pair, (String)","));
            }
            if (pair.length == 2) {
                int agentDeviceId = Utils.parseInt((String)pair[0]);
                List ifaceList = Utils.toIntegerList((String)pair[1]);
                if (logger.isDebugEnabled()) {
                    logger.debug("agentDeviceId=" + agentDeviceId + "; ifaceList=" + ifaceList);
                }
                if (agentDeviceId > 0 && ifaceList.size() > 0) {
                    List<Integer> list = result.get(agentDeviceId);
                    if (list == null) {
                        list = new ArrayList<Integer>();
                        result.put(agentDeviceId, list);
                    }
                    list.addAll(ifaceList);
                    continue;
                }
            }
            logger.error("Error in parameter \"flow.agent.link\"=" + config.get("flow.agent.link", ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("result.size()=" + result.size());
        }
        if (result.size() == 0) {
            List ifaceList = devicePortDao.list(invDeviceId, -1, false, false, null);
            ArrayList<Integer> ifaces = new ArrayList<Integer>();
            int size = ifaceList.size();
            for (int i = 0; i < size; ++i) {
                ifaces.add(((DeviceInterface)ifaceList.get(i)).getPort());
            }
            result = ifaces.size() == 0 || ifaces.size() == 1 && (Integer)ifaces.get(0) == -1 ? Collections.singletonMap(deviceId, Collections.singletonList(-1)) : Collections.singletonMap(deviceId, ifaces);
        }
        if (logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            result.forEach((k, v) -> buf.append(k).append("=").append(v).append("; "));
            logger.debug("result=" + buf.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetDeviceMapItem get(int deviceId) throws BGException {
        Map<Integer, InetDeviceMapItem> deviceMap = this.deviceMap;
        if (deviceMap == null) {
            InetDeviceMap inetDeviceMap = this;
            synchronized (inetDeviceMap) {
                deviceMap = this.deviceMap = this.load();
            }
        }
        return deviceMap.get(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, InetDeviceMapItem> getMap() throws BGException {
        Map<Integer, InetDeviceMapItem> deviceMap = this.deviceMap;
        if (deviceMap == null) {
            InetDeviceMap inetDeviceMap = this;
            synchronized (inetDeviceMap) {
                deviceMap = this.deviceMap = this.load();
            }
        }
        return deviceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        InetDeviceMap inetDeviceMap = this;
        synchronized (inetDeviceMap) {
            this.deviceMap = null;
        }
    }

    public class InetDeviceMapItem {
        final InetDeviceMapItem parent;
        final InetDevice device;
        final ParameterMap config;
        final ParameterMap selfConfig;
        final Set<Integer> descendantIds0;
        final Set<Integer> descendantIds;
        private final Set<Integer> ancestorAndThisIds0;
        private final Set<Integer> ancestorAndThisIds;
        final Set<Integer> ancestorIds;
        final Map<Integer, List<Integer>> flowAgentIfaceMap;

        public InetDeviceMapItem(InetDeviceMapItem parent, InetDevice device, ParameterMap config, ParameterMap selfConfig, Map<Integer, List<Integer>> flowAgentIfaceMap) {
            this.parent = parent;
            this.device = device;
            this.config = config;
            this.selfConfig = selfConfig;
            this.flowAgentIfaceMap = flowAgentIfaceMap;
            this.descendantIds0 = new HashSet<Integer>();
            this.descendantIds = Collections.unmodifiableSet(this.descendantIds0);
            this.ancestorAndThisIds0 = new HashSet<Integer>();
            if (device.getId() > 0) {
                this.ancestorAndThisIds0.add(device.getId());
            }
            if (parent != null) {
                this.ancestorAndThisIds0.addAll(parent.ancestorAndThisIds);
            }
            this.ancestorAndThisIds = Collections.unmodifiableSet(this.ancestorAndThisIds0);
            this.ancestorIds = parent != null ? parent.ancestorAndThisIds : Collections.emptySet();
        }

        public InetDeviceMapItem getParent() {
            return this.parent;
        }

        public InetDevice getDevice() {
            return this.device;
        }

        public ParameterMap getConfig() {
            return this.config;
        }

        public ParameterMap getSelfConfig() {
            return this.selfConfig;
        }

        public Map<Integer, List<Integer>> getFlowAgentIfaceMap() {
            return this.flowAgentIfaceMap;
        }

        public Set<Integer> getDescendantIds() {
            return this.descendantIds;
        }

        public Set<Integer> getAncestorIds() {
            return this.ancestorIds;
        }

        public InetDeviceMapItem findRoot(Set<Integer> rootDeviceTypeId) {
            if (rootDeviceTypeId.contains(this.device.getDeviceTypeId())) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.findRoot(rootDeviceTypeId);
            }
            return this;
        }
    }
}

