/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAccountingPeriod;
import ru.bitel.bgbilling.modules.inet.common.service.AccountingPeriodService;
import ru.bitel.bgbilling.modules.inet.server.bean.InetAccountingPeriodDao;
import ru.bitel.bgbilling.modules.inet.server.event.InetAccountingPeriodModifiedEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.inet.common.service.AccountingPeriodService")
public class AccountingPeriodServiceImpl
extends AbstractService
implements AccountingPeriodService {
    private InetAccountingPeriodDao inetAccountingPeriodDao;

    @PostConstruct
    void init() throws BGException {
        this.inetAccountingPeriodDao = new InetAccountingPeriodDao(this.getConnection(), this.moduleId, this.userId);
    }

    public List<InetAccountingPeriod> periodList(int contractId) throws BGException {
        return this.inetAccountingPeriodDao.list(contractId);
    }

    public int periodUpdate(InetAccountingPeriod period) throws BGException {
        InetAccountingPeriod oldItem = (InetAccountingPeriod)this.inetAccountingPeriodDao.getAndUpdate((Id)period);
        this.context.publishAfterCommit((Event)new InetAccountingPeriodModifiedEvent(this.moduleId, period.getContractId(), this.userId, oldItem, period));
        return period.getId();
    }

    public void periodDelete(int id) throws BGException {
        InetAccountingPeriod oldItem = (InetAccountingPeriod)this.inetAccountingPeriodDao.getAndDelete(id);
        if (oldItem != null) {
            this.context.publishAfterCommit((Event)new InetAccountingPeriodModifiedEvent(this.moduleId, oldItem.getContractId(), this.userId, oldItem, null));
        }
    }

    public void periodWrap(InetAccountingPeriod period, int cidTo, Date dateOpen) throws BGException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateOpen);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
        cal.add(14, -1);
        Date closeDate = cal.getTime();
        if (TimeUtils.dateBefore((Date)period.getDateTo(), (Date)dateOpen)) {
            return;
        }
        InetAccountingPeriod newPeriod = period.clone();
        newPeriod.setContractId(cidTo);
        newPeriod.setId(0);
        if (TimeUtils.dateBefore((Date)dateOpen, (Date)period.getDateFrom())) {
            this.periodDelete(period.getId());
        } else {
            period.setDateTo(closeDate);
            newPeriod.setDateFrom(dateOpen);
            this.periodUpdate(period);
        }
        this.periodUpdate(newPeriod);
    }
}

