/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.level;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.tariff.level.DeviceLevelEvent;

public class DeviceLevelManager
implements EventListener<DeviceLevelEvent> {
    private static final Logger logger = LogManager.getLogger();
    protected final int moduleId;
    protected final boolean realtime;
    private final ConcurrentMap<Integer, Integer> levelMap = new ConcurrentHashMap<Integer, Integer>();
    private final InetDeviceMap deviceMap;

    public DeviceLevelManager(int moduleId, boolean realtime) throws BGException {
        this.moduleId = moduleId;
        this.realtime = realtime;
        this.deviceMap = InetDeviceMap.getInstance(moduleId);
        if (realtime) {
            try {
                File stateFile = new File("data/state");
                stateFile = new File(stateFile, "deviceLevelMap.ser");
                if (stateFile.exists()) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(stateFile));
                    Map map = (Map)in.readObject();
                    in.close();
                    for (Map.Entry e : map.entrySet()) {
                        this.levelMap.putIfAbsent((Integer)e.getKey(), (Integer)e.getValue());
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            EventProcessor.getInstance().addListener((EventListener)this, DeviceLevelEvent.class, moduleId, null);
        }
    }

    public synchronized void notify(DeviceLevelEvent e, EventListenerContext ctx) throws BGException {
        if (e.getDeviceId() == 0 && e.getLevel() == 0) {
            logger.info("Clear levels for all deviceIds");
            this.levelMap.clear();
            return;
        }
        logger.info("Set level=" + e.getLevel() + " for deviceId=" + e.getDeviceId());
        if (e.getLevel() <= 0) {
            this.levelMap.remove(e.getDeviceId());
        } else {
            this.levelMap.put(e.getDeviceId(), e.getLevel());
        }
    }

    public static void setLevel(int moduleId, int deviceId, int level) throws BGException {
        EventProcessor.getInstance().publish((Event)new DeviceLevelEvent(moduleId, deviceId, level));
    }

    public ConcurrentMap<Integer, Integer> getLevelMap() {
        return this.levelMap;
    }

    public int getLevel(int deviceId) {
        InetDeviceMap.InetDeviceMapItem deviceItem;
        if (this.levelMap.size() == 0) {
            return 0;
        }
        Integer level = (Integer)this.levelMap.get(deviceId);
        if (level != null) {
            return level;
        }
        try {
            deviceItem = this.deviceMap.get(deviceId);
            if (deviceItem == null) {
                return 0;
            }
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return 0;
        }
        for (deviceItem = deviceItem.getParent(); deviceItem != null; deviceItem = deviceItem.getParent()) {
            level = (Integer)this.levelMap.get(deviceItem.getDevice().getId());
            if (level == null) continue;
            return level;
        }
        return 0;
    }

    public void persist() {
        try {
            File stateFile = new File("data/state");
            stateFile.mkdirs();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(stateFile, "deviceLevelMap.ser")));
            out.writeObject(new HashMap<Integer, Integer>(this.levelMap));
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

