/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.action;

import bitel.billing.server.ActionConType;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperReport;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.bgbilling.modules.ipn.common.bean.BGDecimalFormat;
import ru.bitel.bgbilling.modules.ipn.server.Module;
import ru.bitel.bgbilling.modules.ipn.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.ipn.server.bean.AddressRangeManager;
import ru.bitel.bgbilling.modules.ipn.server.bean.ClientStatManager;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGMapCollectionDataSource;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

@ActionConType(value=2)
public class ActionGetJasperStatData
extends ActionBase {
    final DecimalFormat format = new BGDecimalFormat("###,###,###,###.##");

    public void doAction() throws SQLException, BGException {
        String sid = this.getParameter("sid");
        String aid = this.getParameter("aid");
        int year = this.getIntParameter("year", 0);
        int day = this.getIntParameter("day", 0);
        int month = this.getIntParameter("month", 0);
        int unit = this.getIntParameter("unit", 0x100000);
        ClientStatManager manager = new ClientStatManager(this.con, this.mid);
        manager.fillData(this.cid, aid, sid, year, month, day);
        SortedMap<Integer, Long> values = manager.getStatData();
        ArrayList dataSource = new ArrayList(50);
        Long sum = 0L;
        for (Map.Entry<Integer, Long> entry : values.entrySet()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("colX", entry.getKey().toString());
            String str = this.format.format((double)entry.getValue().longValue() / (double)unit);
            str = str.replaceAll(" ", "");
            row.put("colY", Double.valueOf(str));
            sum = sum + entry.getValue();
            dataSource.add(row);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object totalString = this.format.format((double)sum.longValue() / (double)unit);
        String unitStr = "";
        switch (unit) {
            case 1: {
                unitStr = "\u0431\u0430\u0439\u0442";
                break;
            }
            case 1024: {
                unitStr = "K\u0431";
                break;
            }
            case 0x100000: {
                unitStr = "\u041c\u0431";
                break;
            }
            case 0x40000000: {
                unitStr = "\u0413\u0431";
            }
        }
        totalString = (String)totalString + unitStr;
        params.put("sum", totalString);
        String labelX = "";
        String period = "";
        if (month > 0 && day > 0) {
            labelX = "\u0447\u0430\u0441\u044b";
            cal = new GregorianCalendar(year, month - 1, day);
            period = TimeUtils.format((Calendar)cal, (String)"dd.MM.yyyy");
        } else if (month > 0 && day == 0) {
            labelX = "\u0434\u043d\u0438";
            cal = new GregorianCalendar(year, month - 1, 1);
            period = TimeUtils.format((Calendar)cal, (String)"MM.yyyy");
        } else if (month == 0 && day == 0) {
            labelX = "\u043c\u0435\u0441\u044f\u0446\u044b";
            cal = new GregorianCalendar(year, 0, 1);
            period = TimeUtils.format((Calendar)cal, (String)"yyyy \u0433");
        }
        params.put("labelX", labelX);
        params.put("labelY", unitStr);
        params.put("period", period);
        List services = ModuleCache.getInstance().getModuleServicesList(this.mid);
        Object serviceString = "";
        HashSet<String> selectedSids = new HashSet<String>();
        if (sid != null) {
            this.getSetFromString(sid, selectedSids);
        }
        Iterator it = services.iterator();
        while (it.hasNext()) {
            Service srv = (Service)it.next();
            if (!selectedSids.contains(String.valueOf(srv.getId()))) continue;
            serviceString = (String)serviceString + srv.getTitle();
            if (!it.hasNext()) continue;
            serviceString = (String)serviceString + ";";
        }
        params.put("services", serviceString);
        HashSet<String> selectedAdrs = new HashSet<String>();
        if (aid != null) {
            this.getSetFromString(aid, selectedAdrs);
        }
        AddressRangeManager man = new AddressRangeManager(this.con, this.mid);
        List<AddressRange> addrList = man.getContractAddressRange(this.cid);
        Object adressString = "";
        Iterator<AddressRange> it2 = addrList.iterator();
        while (it2.hasNext()) {
            AddressRange ar = it2.next();
            if (!selectedAdrs.contains(String.valueOf(ar.getId()))) continue;
            adressString = (String)adressString + ar.toString(man.getSourceIface(ar));
            if (!it2.hasNext()) continue;
            adressString = (String)adressString + ";";
        }
        params.put("adresses", adressString);
        URL url = Module.class.getResource("templates/template_stat.xml");
        JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)this.setup, (URL)url);
        try {
            OutputStream out = this.getResponseOut();
            JasperFillManager.fillReportToStream((JasperReport)report, (OutputStream)out, params, (JRDataSource)new BGMapCollectionDataSource(dataSource));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getSetFromString(String sid, Set<String> result) {
        String[] sidArray;
        for (String s : sidArray = sid.split(",")) {
            result.add(s.trim());
        }
    }
}

