/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.server.bean.Gate;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class GatePortManager {
    private String tableName = null;
    protected int mid = -1;
    protected Connection con;

    public GatePortManager(Connection con, int mid) {
        this.mid = mid;
        this.con = con;
        this.tableName = "ipn_gate_contract_port_" + mid;
    }

    public List<Map<String, Object>> getGatePortMaps(int contractId) throws BGException {
        HashMap resultMap = new HashMap();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT * FROM " + this.tableName + " AS ports");
            query.append(" LEFT JOIN ipn_gate_" + this.mid + " AS gate");
            query.append(" ON gate.id = ports.gid");
            query.append(" WHERE cid = " + contractId);
            query.append(" ORDER by ports.port ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int gid = rs.getInt("gid");
                HashMap<String, Object> ports = (HashMap<String, Object>)resultMap.get(gid);
                if (ports == null) {
                    ports = new HashMap<String, Object>();
                    ports.put("gateId", rs.getInt("gid"));
                    ports.put("gateName", rs.getString("host") + " : " + rs.getString("port") + " [ " + rs.getString("comment") + " ]");
                    resultMap.put(gid, ports);
                }
                int port = rs.getInt("port");
                Object pt = (String)ports.get("ports");
                pt = !Utils.isEmptyString((String)pt) ? (String)pt + "," : "";
                pt = (String)pt + port;
                ports.put("ports", pt);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map e : resultMap.values()) {
            result.add(e);
        }
        return result;
    }

    public List<Map<String, Object>> getPortMonitorMap(int gid) throws BGException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT ports.port, ports.cid, contract.title FROM " + this.tableName + " AS ports");
            query.append(" LEFT JOIN contract ON contract.id=ports.cid");
            query.append(" WHERE ports.gid =" + gid);
            query.append(" ORDER by ports.port ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("cid", rs.getInt("cid"));
                map.put("title", rs.getString("title"));
                map.put("port", rs.getInt("port"));
                result.add(map);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public Map<String, Object> getGatePortMap(int cid, int gid) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT * FROM " + this.tableName + " AS ports");
            query.append(" LEFT JOIN ipn_gate_" + this.mid + " AS gate");
            query.append(" ON gate.id = ports.gid");
            query.append(" WHERE cid = " + cid);
            query.append(" AND gid = " + gid);
            query.append(" ORDER by ports.port ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            ArrayList<Integer> portList = new ArrayList<Integer>();
            while (rs.next()) {
                result.put("gateId", rs.getInt("gid"));
                result.put("gateName", rs.getString("host"));
                portList.add(rs.getInt("port"));
            }
            rs.close();
            ps.close();
            result.put("ports", portList);
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public boolean updateGatePorts(int cid, int gid, List<Integer> ports) throws BGException {
        boolean autoCommit = false;
        try {
            autoCommit = this.con.getAutoCommit();
            ServerUtils.setAutoCommit((Connection)this.con, (boolean)false);
            this.deleteGatePorts(cid, gid);
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO " + this.tableName);
            query.append(" (cid, gid, port) VALUES(?, ?,? ) ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ps.setInt(2, gid);
            for (Integer port : ports) {
                ps.setInt(3, port);
                ps.executeUpdate();
            }
            ps.close();
            this.con.commit();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.setAutoCommit((Connection)this.con, (boolean)autoCommit);
        }
        return true;
    }

    public boolean deleteGatePorts(int cid, int gid) throws BGException {
        try {
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM " + this.tableName);
            query.append(" WHERE cid = " + cid);
            query.append(" AND gid = " + gid);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return true;
    }

    public List<Integer> findFreePorts(int cid, int gid, int count, List<List<Integer>> rangeList) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (rangeList.size() == 0) {
            return result;
        }
        int min = rangeList.get(0).get(0);
        int max = rangeList.get(rangeList.size() - 1).get(1);
        List<Integer> existPorts = this.getGatePorts(cid, gid);
        Object portsStr = "";
        if (existPorts.size() > 0) {
            for (Integer port : existPorts) {
                if (!Utils.isEmptyString((String)portsStr)) {
                    portsStr = (String)portsStr + ",";
                }
                portsStr = (String)portsStr + port;
            }
        }
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT * FROM " + this.tableName + " AS ports");
            query.append(" LEFT JOIN ipn_gate_" + this.mid + " AS gate");
            query.append(" ON gate.id = ports.gid");
            query.append(" WHERE gid = " + gid);
            if (existPorts.size() > 0) {
                query.append(" AND ports.port NOT IN ( " + (String)portsStr + ")");
            }
            query.append(" ORDER BY ports.port");
            int value = min;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            int idx = 0;
            boolean isNext = true;
            boolean f = false;
            for (int i = 0; i < count; ++i) {
                if (!isNext) {
                    if (max - value >= count - i && !f) {
                        for (int j = 1; j <= count - i; ++j) {
                            result.add(value + j);
                        }
                        break;
                    }
                    return new ArrayList<Integer>();
                }
                while (true) {
                    if (!rs.next()) {
                        isNext = false;
                        break;
                    }
                    int port = rs.getInt("port");
                    if (port != value) break;
                    List<Integer> list = rangeList.get(idx);
                    int r2 = list.get(1);
                    if (++value <= r2) continue;
                    if (++idx >= rangeList.size()) {
                        f = true;
                        break;
                    }
                    list = rangeList.get(idx);
                    value = list.get(0);
                }
                if (f || value > max) continue;
                result.add(value);
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public List<Gate> getAvailableGates(int cid) throws BGException {
        ArrayList<Gate> result = new ArrayList<Gate>();
        try {
            StringBuffer query = new StringBuffer();
            query.append(" SELECT gate.* FROM ipn_gate_" + this.mid + " AS gate");
            query.append(" WHERE gate.id IN ");
            query.append(" ( SELECT fwid FROM ipn_user_gate_" + this.mid + " AS user_gate");
            query.append(" WHERE user_gate.cid =  " + cid + " )");
            query.append(" AND  gate.id  NOT IN ");
            query.append(" (SELECT gid FROM " + this.tableName + " AS ports");
            query.append(" WHERE ports.cid = " + cid + " )");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Gate gate = new Gate();
                GateManager.loadFromResultSet(rs, gate, false);
                result.add(gate);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public boolean portsExists(int cid, int gid, List<Integer> ports) throws BGException {
        boolean result = false;
        if (ports.size() == 0) {
            return result;
        }
        try {
            Object portString = "";
            for (Integer port : ports) {
                if (!Utils.isEmptyString((String)portString)) {
                    portString = (String)portString + ",";
                }
                portString = (String)portString + port;
            }
            StringBuffer query = new StringBuffer();
            query.append("SELECT COUNT(*) FROM " + this.tableName);
            query.append(" WHERE gid = " + gid);
            query.append(" AND cid  != " + cid);
            query.append(" AND port IN ( " + (String)portString + ")");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<Integer> getGatePorts(int cid, int gid) throws BGException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM " + this.tableName);
            query.append(" WHERE gid = " + gid);
            query.append(" AND cid  = " + cid);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getInt("port"));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

