/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffLabelService;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class MegafonContractProductPanel
extends BGUPanel {
    private MegafonService megafonService;
    private MegafonContractService megafonContractService;
    private ProductTableModel tableModel;
    private List<MegafonProduct> products;
    AbstractBGUPanel.DefaultAction activate = new AbstractBGUPanel.DefaultAction("activate", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c", ClientUtils.getIcon((String)"fugue/present--plus")){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            new ProductEditorDialog("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", null, (ClientContext)MegafonContractProductPanel.this.getContext()).open();
        }
    };
    AbstractBGUPanel.DefaultAction deactivate = new AbstractBGUPanel.DefaultAction("deactivate", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c", ClientUtils.getIcon((String)"fugue/present--minus")){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            MegafonContractProduct contractProduct = (MegafonContractProduct)MegafonContractProductPanel.this.tableModel.getSelectedRow();
            if (contractProduct != null) {
                new ProductEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", contractProduct, (ClientContext)MegafonContractProductPanel.this.getContext());
            }
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new ProductTableModel();
        BGUTable productTable = new BGUTable((TableModel)((Object)this.tableModel));
        BGDialogToolBar toolBar = new BGDialogToolBar();
        BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this));
        toolBar.compact();
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)productTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.products = this.getMegafonService().getProductList();
            this.tableModel.setData(this.getMegafonContractService().getContractProductList(null, ((ClientContext)this.getContext()).getContractId(), null).getList());
        });
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private MegafonContractService getMegafonContractService() {
        if (this.megafonContractService == null) {
            this.megafonContractService = (MegafonContractService)((ClientContext)this.getContext()).getPort(MegafonContractService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonContractService;
    }

    private final class ProductTableModel
    extends BGTableModel<MegafonContractProduct> {
        public ProductTableModel() {
            super("megafonContractProductTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, -1, -1, "productId", false);
            this.addColumn("MSISDN", -1, 100, -1, "msisdn", false);
            this.addColumn("\u0414\u043e\u043f. MSISDN", -1, 100, -1, "additionalMsisdn", false);
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 100, -1, "status", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430", -1, 100, -1, "dateFrom", false);
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f", -1, 100, -1, "dateTo", false);
            this.addColumn("MNP \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "mnpOrderComment", false);
        }

        public Object getValueAt(MegafonContractProduct val, int column) throws BGException {
            return switch (column) {
                case 0 -> {
                    MegafonProduct product = MegafonContractProductPanel.this.products.stream().filter(p -> p.getId() == val.getProductId()).findFirst().orElse(null);
                    if (product != null) {
                        yield product.getTitle();
                    }
                    yield "<\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>";
                }
                case 3 -> val.getStatus().getComment();
                case 4 -> {
                    if (val.getStartTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getStartTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                case 5 -> {
                    if (val.getEndTime() != null) {
                        yield TimeUtils.format((LocalDateTime)val.getEndTime(), (String)"dd.MM.yyyy HH:mm:ss");
                    }
                    yield "";
                }
                default -> super.getValueAt((Object)val, column);
            };
        }
    }

    private final class ProductEditorDialog
    extends BGEditorDialog<MegafonContractProduct> {
        private final BGUComboBox<MegafonProduct> productsComboBox;
        private final JTextField msisdn;
        private final JTextField additionalMsisdn;
        private final BGControlPanelPeriod periodPanel;
        private final JButton checkAllowActivate;
        private final JButton sendMNPRequest;
        private final JTextArea conflicts;
        private final JButton forceActivate;
        private final JPanel activationConflictsInfoPanel;
        private final BGUComboBox<TariffPlan> tariffs;
        private boolean activateIsAllow;

        public ProductEditorDialog(String title, MegafonContractProduct data, ClientContext context) {
            super(title, (Object)data, context);
            this.productsComboBox = new BGUComboBox();
            this.msisdn = new JTextField();
            this.additionalMsisdn = new JTextField();
            this.periodPanel = new BGControlPanelPeriod();
            this.checkAllowActivate = new JButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438");
            this.sendMNPRequest = new JButton("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 MNP-\u043f\u0440\u043e\u0446\u0435\u0441\u0441");
            this.conflicts = new JTextArea();
            this.forceActivate = new JButton("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e");
            this.tariffs = new BGUComboBox();
            this.activateIsAllow = false;
            this.productsComboBox.setData(MegafonContractProductPanel.this.products);
            this.loadTariffs();
            this.productsComboBox.addItemListener(e -> this.loadTariffs());
            this.checkAllowActivate.addActionListener(e -> this.checkAllowActivate());
            this.sendMNPRequest.addActionListener(e -> this.sendMNPRequest());
            this.activationConflictsInfoPanel = this.activationConflictsInfoPanel();
            this.activationConflictsInfoPanel.setVisible(false);
            this.forceActivate.addActionListener(e -> this.productActivate());
        }

        public void doDialogPanel() {
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            this.panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442"), constraints);
            this.panel.add((Component)this.productsComboBox, constraints);
            this.panel.add((Component)new JLabel("MSISDN"), constraints);
            this.panel.add((Component)this.msisdn, constraints);
            this.panel.add((Component)new JLabel("\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 MSISDN"), constraints);
            this.panel.add((Component)this.additionalMsisdn, constraints);
            this.panel.add((Component)this.periodPanel, constraints);
            this.panel.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444"), constraints);
            this.panel.add((Component)this.tariffs, constraints);
            this.panel.add((Component)this.checkAllowActivate, constraints);
            this.panel.add((Component)this.activationConflictsInfoPanel, constraints);
            this.sendMNPRequest.setEnabled(false);
            if (this.data != null) {
                this.productsComboBox.setSelectedItem((Object)this.productsComboBox.getData().stream().filter(p -> p.getId() == ((MegafonContractProduct)this.data).getProductId()).findFirst().get());
                this.msisdn.setText(((MegafonContractProduct)this.data).getMsisdn());
                this.additionalMsisdn.setText(((MegafonContractProduct)this.data).getAdditionalMsisdn());
                if (((MegafonContractProduct)this.data).getStartTime() != null) {
                    this.periodPanel.setDateFrom(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)((MegafonContractProduct)this.data).getStartTime()));
                }
                if (((MegafonContractProduct)this.data).getEndTime() != null) {
                    this.periodPanel.setDateTo(TimeUtils.convertLocalDateTimeToDate((LocalDateTime)((MegafonContractProduct)this.data).getEndTime()));
                }
                this.loadTariffs();
            }
        }

        private void loadTariffs() {
            MegafonProduct selectedProduct = (MegafonProduct)this.productsComboBox.getSelectedItem();
            if (selectedProduct == null) {
                return;
            }
            try {
                this.tariffs.setData(((TariffLabelService)this.clientContext.getPort(TariffLabelService.class, 0)).getTariffListByLabelId(selectedProduct.getTariffLabelId()));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        private void checkAllowActivate() {
            try {
                if (MegafonContractProductPanel.this.getMegafonContractService().checkAllowActivateProduct(this.getProductFromForm())) {
                    this.activateIsAllow = true;
                    BGToolTip.showMessage((JComponent)this.checkAllowActivate, (String)"\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430");
                } else {
                    this.sendMNPRequest.setEnabled(true);
                }
            }
            catch (Exception e) {
                this.sendMNPRequest.setEnabled(true);
                this.activateIsAllow = false;
                String error = e.getLocalizedMessage();
                if (!error.contains("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b:")) {
                    ClientUtils.showErrorMessageDialog((String)e.getMessage());
                }
                this.conflicts.setText(error);
                this.activationConflictsInfoPanel.setVisible(true);
                this.optionPane.getDialog().pack();
            }
        }

        private MegafonContractProduct getProductFromForm() {
            MegafonContractProduct contractProduct = new MegafonContractProduct();
            contractProduct.setContractId(((ClientContext)MegafonContractProductPanel.this.getContext()).getContractId());
            contractProduct.setProductId(this.productsComboBox.getSelectedItem() != null ? ((MegafonProduct)this.productsComboBox.getSelectedItem()).getId() : -1);
            contractProduct.setMsisdn(Utils.maskNull((String)this.msisdn.getText()).trim());
            contractProduct.setAdditionalMsisdn(Utils.maskNull((String)this.additionalMsisdn.getText()).trim());
            contractProduct.setStartTime(this.periodPanel.getDateFrom() != null ? TimeUtils.convertDateToLocalDateTime((Date)this.periodPanel.getDateFrom()) : null);
            contractProduct.setEndTime(this.periodPanel.getDateTo() != null ? TimeUtils.convertDateToLocalDateTime((Date)this.periodPanel.getDateTo()) : null);
            TariffPlan tariffPlan = (TariffPlan)this.tariffs.getSelectedItem();
            contractProduct.setTariffId(tariffPlan == null ? 0 : tariffPlan.getId());
            return contractProduct;
        }

        private JPanel activationConflictsInfoPanel() {
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u044b \u0438 \u043e\u0448\u0438\u0431\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0435 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)new JScrollPane(this.conflicts), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            p.add((Component)this.forceActivate, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            p.setPreferredSize(new Dimension(500, 300));
            return p;
        }

        private void sendMNPRequest() {
        }

        public boolean doApply() throws Exception {
            if (!this.activateIsAllow) {
                throw new BGException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430 \u0438\u043b\u0438 \u043d\u0435 \u0431\u044b\u043b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!");
            }
            this.productActivate();
            return true;
        }

        private void productActivate() {
            try {
                MegafonContractProductPanel.this.getMegafonContractService().productActivateRequest(this.getProductFromForm());
                this.optionPane.getDialog().dispose();
                MegafonContractProductPanel.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }
}

