/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscriptionStatusPeriod;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class MegogoContractSubscriptionStatusPeriodDao
extends AbstractIdDao<MegogoContractSubscriptionStatusPeriod> {
    public MegogoContractSubscriptionStatusPeriodDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_subscription_status_period");
    }

    public List<MegogoContractSubscriptionStatusPeriod> getList(int idSub, int status, boolean dateToIsNull, Date date) throws BGException {
        return this.getList(idSub, status, dateToIsNull, new Period(date, date));
    }

    public List<MegogoContractSubscriptionStatusPeriod> getList(int idSub, int status, boolean dateToIsNull, Period period) throws BGException {
        List list;
        block12: {
            String query = "SELECT * FROM " + this.tableName + " WHERE idSub=" + idSub;
            if (status > 0) {
                query = query + " AND status=" + status;
            }
            if (dateToIsNull) {
                query = query + " AND dateTo IS NULL";
            }
            if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                query = query + " AND DATE(dateFrom)<=? AND ( dateTo IS NULL OR DATE(dateTo)>=? )";
            }
            query = query + " ORDER BY id DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                    ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                ResultSet rs = ps.executeQuery();
                list = this.getListFromRS(rs);
                if (ps == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    protected MegogoContractSubscriptionStatusPeriod getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoContractSubscriptionStatusPeriod statusPeriod = new MegogoContractSubscriptionStatusPeriod();
        statusPeriod.setId(rs.getInt("id"));
        statusPeriod.setIdSub(rs.getInt("idSub"));
        statusPeriod.setStatus(rs.getInt("status"));
        statusPeriod.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        statusPeriod.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        return statusPeriod;
    }

    protected void updateImpl(MegogoContractSubscriptionStatusPeriod statusPeriod) throws BGException, SQLException {
        if (statusPeriod != null) {
            String query = null;
            PreparedStatement ps = null;
            if (statusPeriod.getId() < 1) {
                query = "INSERT INTO " + this.tableName + " SET idSub=?, status=?, dateFrom=?, dateTo=? ";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET idSub=?, status=?, dateFrom=?, dateTo=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, statusPeriod.getId());
            }
            ps.setInt(1, statusPeriod.getIdSub());
            ps.setInt(2, statusPeriod.getStatus());
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)statusPeriod.getDateFrom()));
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)statusPeriod.getDateTo()));
            ps.executeUpdate();
            if (statusPeriod.getId() < 1) {
                statusPeriod.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
    }
}

