/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.bean;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Key;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.modules.mobile.server.api.MobileApi;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileResultAuthentication;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileToken;
import ru.bitel.bgbilling.modules.mobile.server.dao.MobileTokenDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class MobileAuthentication {
    private static final Logger logger = LogManager.getLogger();
    private int moduleId;
    private ModuleSetup moduleSetup;
    private String action;
    private MobileResultAuthentication result = null;

    public MobileAuthentication(int moduleId, ModuleSetup moduleSetup, String action) {
        this.moduleId = moduleId;
        this.action = action;
        this.moduleSetup = moduleSetup;
    }

    /*
     * Exception decompiling
     */
    public MobileResultAuthentication authentication(HttpServletRequest request, Connection con, Map<String, Object> map) throws BGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkModuleOnContract(Connection con, int contractId) throws BGException {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(con, Integer.valueOf(contractId));
        logger.debug("checkModuleOnContract for contractId=" + contractId + " => " + contractRuntime);
        return contractRuntime == null ? false : contractRuntime.getModuleIds().contains(this.moduleId);
    }

    private String checkSubContract(int subContractId, ContractDao contractDao) throws BGException {
        if (subContractId > 0) {
            Contract subContract = (Contract)contractDao.get(subContractId);
            if (subContract == null) {
                return "Sub Contract is null";
            }
            if (subContract.isSub() && subContract.getSuperCid() == this.result.getContract().getId()) {
                this.result.setContract(subContract);
                return null;
            }
            return "Sub contracact it's not sub or token incorrect !";
        }
        return null;
    }

    private int checkRefreshToken(HttpServletRequest request, Connection con, ContractDao contractDao, MobileTokenDao tokenDao, SecretKey secretKey, String refreshToken, Map<String, Object> map, int subContractId) throws BGException {
        int accessCode = -1;
        int contractId = -1;
        try {
            Jws jws = Jwts.parser().setSigningKey((Key)secretKey).parseClaimsJws(refreshToken);
            contractId = (Integer)((Claims)jws.getBody()).get((Object)"cid");
            this.result.setContract((Contract)contractDao.get(contractId));
            if (this.result.getContract() != null) {
                int tokenId = Utils.parseInt((String)((JwsHeader)jws.getHeader()).getKeyId(), (int)-1);
                if (tokenId < 1) {
                    accessCode = 13;
                    return accessCode;
                }
                MobileToken refreshMobToken = (MobileToken)tokenDao.get(tokenId);
                if (refreshMobToken == null) {
                    accessCode = 14;
                    return accessCode;
                }
                if ("tokenDeauthorize".equals(this.action)) {
                    this.deauthorizeToken(request, con, tokenDao, tokenId, contractId);
                    accessCode = 4;
                } else {
                    String jwsAccess = this.getAccessJWS(secretKey, contractId);
                    String jwsRefresh = this.getRefreshJWS(secretKey, contractId, refreshMobToken, tokenDao);
                    map.put("ajwt", jwsAccess);
                    map.put("rjwt", jwsRefresh);
                    accessCode = 3;
                    this.checkSubContract(subContractId, contractDao);
                }
            }
        }
        catch (ExpiredJwtException e2) {
            accessCode = 12;
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e2) {
            logger.error("Refresh token, cid =  " + contractId + " " + e2.getMessage());
            accessCode = 13;
        }
        return accessCode;
    }

    private String getAccessJWS(SecretKey secretKey, int contractId) {
        Calendar lifetime = Calendar.getInstance();
        int minutes = this.rangeInt(this.moduleSetup.getInt("token.access.lifetime.minutes", 60), 10, 2880, 60);
        lifetime.add(12, minutes);
        JwtBuilder jwtBuilder = Jwts.builder().setIssuedAt(new Date()).setExpiration(lifetime.getTime());
        return jwtBuilder.claim("cid", (Object)contractId).signWith((Key)secretKey).compact();
    }

    private String getRefreshJWS(SecretKey secretKey, int contractId, MobileToken tokenRefreshOld, MobileTokenDao tokenDao) throws BGException {
        int tokenId;
        Calendar lifetime = Calendar.getInstance();
        int day = this.rangeInt(this.moduleSetup.getInt("token.refresh.lifetime.days", 30), 1, 180, 30);
        lifetime.add(6, day);
        Date lifetimeDate = lifetime.getTime();
        int n = tokenId = tokenRefreshOld != null ? tokenRefreshOld.getId() : -1;
        if (tokenId < 1) {
            MobileToken token = new MobileToken();
            token.setContractId(contractId);
            token.setExpiredDate(lifetimeDate);
            tokenDao.update((Object)token);
            tokenId = token.getId();
        }
        JwtBuilder jwtBuilder = Jwts.builder().setIssuedAt(new Date()).setExpiration(lifetimeDate);
        return jwtBuilder.claim("cid", (Object)contractId).setHeaderParam("kid", (Object)("" + tokenId)).signWith((Key)secretKey).compact();
    }

    private void deauthorizeToken(HttpServletRequest request, Connection con, MobileTokenDao tokenDao, int tokenId, int contractId) throws BGException {
        tokenDao.delete(tokenId);
        String pushToken = request.getParameter("pushToken");
        if (Utils.notBlankString((String)pushToken)) {
            MobileApi mobileApi = new MobileApi((ParameterMap)this.moduleSetup, con, this.moduleId);
            mobileApi.removeLink(contractId, pushToken);
            mobileApi.close();
        }
    }

    private int rangeInt(int value, int min, int max, int defaultValue) {
        if (value > max || value < min) {
            return defaultValue;
        }
        return value;
    }
}

