/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.oper.sovintel;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import ru.bitel.bgbilling.modules.phone.server.bean.oper.Operator;
import ru.bitel.bgbilling.modules.phone.server.oper.sovintel.SovintelReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class InvoiceReport
extends SovintelReport {
    public InvoiceReport(Operator operator, Date month, int id) {
        super(operator, month, id);
    }

    @Override
    public void getData(Connection con, OutputStream out) {
        try {
            String sessionTable;
            String[] positions;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, "Cp1251"));
            CSVWriter printer = new CSVWriter((Writer)writer, ';', '\"');
            int mid = this.oper.getModuleId();
            Preferences operSetup = this.oper.getOperatorSetup();
            int billModuleId = operSetup.getInt("bill.moduleId", 0);
            String contract = operSetup.get("contract", "UNDEF");
            int lastPayDay = operSetup.getInt("lastPayDay", 25);
            String locationCode = operSetup.get("location.code", "0");
            HashMap<Integer, Integer> positionServiceMap = new HashMap<Integer, Integer>();
            for (String pos : positions = operSetup.get("bill.positions", "").split("\\s*,\\s*")) {
                String[] posV = pos.split("\\s*:\\s*", 2);
                positionServiceMap.put(Utils.parseInt((String)posV[0]), Utils.parseInt((String)posV[1]));
            }
            Calendar monthCalendar = TimeUtils.convertDateToCalendar((Date)this.month);
            Calendar lastPayDate = (Calendar)monthCalendar.clone();
            lastPayDate.add(2, 1);
            lastPayDate.set(5, lastPayDay);
            String lastPayDateString = TimeUtils.format((Calendar)lastPayDate, (String)"dd.MM.yyyy '0:00'");
            Calendar lastMonthDay = TimeUtils.getEndMonth((Calendar)monthCalendar);
            String lastMonthDayString = TimeUtils.format((Calendar)lastMonthDay, (String)"dd.MM.yyyy '0:00'");
            String invoiceTable = "bill_invoice_data_" + billModuleId;
            if (!ServerUtils.tableExists((Connection)con, (String)invoiceTable)) {
                writer.write("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + invoiceTable + "!\n");
                ((Writer)writer).flush();
            }
            if (!ServerUtils.tableExists((Connection)con, (String)(sessionTable = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this.month, (int)mid)))) {
                writer.write("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u0430 " + sessionTable + "!\n");
                ((Writer)writer).flush();
            }
            boolean sub = true;
            StringBuilder query = new StringBuilder(200).append("SELECT");
            if (sub) {
                query.append(" sub_contract.title, ");
            } else {
                query.append(" contract.title, ");
            }
            query.append(" bill.format_number, bill.create_dt, bill.xml FROM ");
            query.append(invoiceTable);
            query.append(" as bill ");
            if (sub) {
                query.append(" INNER JOIN contract AS sub_contract ON bill.cid=sub_contract.id");
                query.append(" INNER JOIN contract ON contract.id=sub_contract.scid ");
            } else {
                query.append(" INNER JOIN contract ON bill.cid=contract.id");
            }
            query.append(" WHERE bill.yy=? AND bill.mm=?");
            int index = 1;
            XMLInputFactory xmlif = XMLUtils.newXMLInputFactory();
            PreparedStatement ps = con.prepareStatement(query.toString());
            ps.setInt(1, monthCalendar.get(1));
            ps.setInt(2, monthCalendar.get(2));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                XMLUtils.BGXMLEventReader reader = XMLUtils.newXMLEventReader((XMLInputFactory)xmlif, (InputStream)new ByteArrayInputStream(rs.getBytes(4)));
                for (StartElement pos : reader.iterable("/data/bill/pos")) {
                    String positionIdString = reader.getAttributeValue(pos, "position_id");
                    int positionId = Utils.parseInt((String)positionIdString);
                    String cost = reader.getAttributeValue(pos, "summ");
                    String quantity = reader.getAttributeValue(pos, "quantity");
                    int billingServiceId = positionId;
                    Integer operServiceId = (Integer)positionServiceMap.get(positionId);
                    if (operServiceId == null) {
                        if (positionServiceMap.size() != 0) continue;
                        operServiceId = billingServiceId;
                    }
                    printer.writeNext(new String[]{String.valueOf(index++), contract, rs.getString(1), rs.getString(2), rs.getString(2), TimeUtils.format((Date)rs.getDate(3), (String)"dd.MM.yyyy HH:mm"), lastPayDateString, "0", "2", String.valueOf(operServiceId), lastMonthDayString, cost, quantity, locationCode, "1"}, false);
                }
            }
            ps.close();
            Map<Integer, Integer> operToBillingServiceMap = this.oper.getOperToBillingServiceMap();
            String sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this.month, (int)mid);
            query.setLength(0);
            query.append("SELECT SUM(cost), SUM(round_session_time), session.sid FROM contract LEFT JOIN " + sessionTableName + " as session ON session.cid=contract.id");
            query.append(" AND session.sid IN (");
            query.append(Utils.toString(operToBillingServiceMap.values()));
            query.append(") WHERE contract.fc=0 GROUP BY session.sid");
            ps = con.prepareStatement(query.toString());
            rs = ps.executeQuery();
            block5: while (rs.next()) {
                int operServiceId = rs.getInt(3);
                if (operServiceId <= 0) continue;
                for (Map.Entry<Integer, Integer> e : operToBillingServiceMap.entrySet()) {
                    if (e.getValue() != operServiceId) continue;
                    operServiceId = e.getKey();
                    printer.writeNext(new String[]{String.valueOf(index++), contract, "\u0421\u0447\u0435\u0442 \u0444\u0430\u043a\u0442\u0443\u0440\u0430 \u0443\u0441\u043b\u0443\u0433 \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044e", "", "", lastMonthDayString, lastPayDateString, "0", "2", String.valueOf(operServiceId), lastMonthDayString, Utils.formatCost((BigDecimal)rs.getBigDecimal(1)), String.valueOf(rs.getLong(2) / 60L), locationCode, "1"});
                    continue block5;
                }
            }
            ps.close();
            printer.flush();
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getFileName() {
        return this.getOperCode() + "_BIL_" + TimeUtils.format((Date)this.month, (String)"yyyy_MM") + ".csv";
    }

    @Override
    public String getTitle() {
        return "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u043c \u0441\u0447\u0435\u0442\u0430\u043c-\u0444\u0430\u043a\u0442\u0443\u0440\u0430\u043c, \u0430\u043a\u0442\u0430\u043c, \u0423\u041f\u0414";
    }

    @Override
    public int getType() {
        return 2;
    }

    public static void main(String[] args) throws FileNotFoundException {
        XMLInputFactory xmlif = XMLUtils.newXMLInputFactory();
        XMLUtils.BGXMLEventReader reader = XMLUtils.newXMLEventReader((XMLInputFactory)xmlif, (InputStream)new FileInputStream("/home/amir/Desktop/aaaa.xml"));
        for (StartElement pos : reader.iterable("/data")) {
            System.out.println(pos);
        }
    }
}

