/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.dialup;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Traffic
extends BGJasperReport {
    public Report_Traffic() {
        this.id = "dialup_traffic";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            Calendar date1 = TimeUtils.parseCalendar((String)filter.getStringParam("date1"), (String)"dd.MM.yyyy");
            Calendar date2 = TimeUtils.parseCalendar((String)filter.getStringParam("date2"), (String)"dd.MM.yyyy");
            int hour1 = Utils.parseInt((String)filter.getStringParam("hour1"), (int)-1);
            int hour2 = Utils.parseInt((String)filter.getStringParam("hour2"), (int)-1);
            String groups = filter.getStringParam("gr");
            String sids = filter.getStringParam("sids");
            int mode = Utils.parseInt((String)filter.getStringParam("mode"), (int)1);
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            if (date1 != null && groups != null && mid > 0) {
                String tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)date1.getTime(), (int)mid);
                BGDataSource data = new BGDataSource();
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                    long groupMask = Utils.enumToMask((String)groups);
                    StringBuffer query = new StringBuffer(300);
                    query.append("SELECT t3.title AS c1, SUM( t1.amount ) AS c2 FROM ");
                    query.append(tableName);
                    query.append(" AS t1, contract AS t2, service AS t3 ");
                    query.append(" WHERE t1.cid=t2.id AND t1.sid=t3.id ");
                    if (groupMask != 0L) {
                        query.append(" AND t2.gr & ");
                        query.append(groupMask);
                        query.append(" > 0 ");
                    }
                    if (sids != null && sids.length() > 0) {
                        query.append(" AND t1.sid IN ( ");
                        query.append(sids);
                        query.append(" ) ");
                    }
                    query.append(" AND TO_DAYS(t1.dtime)>=TO_DAYS('");
                    query.append(TimeUtils.format((Calendar)date1, (String)"yyyy-MM-dd"));
                    query.append("') AND TO_DAYS(t1.dtime)<=TO_DAYS('");
                    query.append(TimeUtils.format((Calendar)date2, (String)"yyyy-MM-dd"));
                    query.append("')");
                    if (hour1 >= 0) {
                        query.append(" AND HOUR(t1.dtime)>=");
                        query.append(hour1);
                    }
                    if (hour2 >= 0) {
                        query.append(" AND HOUR(t1.dtime)<=");
                        query.append(hour2);
                    }
                    query.append(" GROUP BY t1.sid");
                    PreparedStatement ps = this.con.prepareStatement(query.toString());
                    ResultSet rs = ps.executeQuery();
                    DecimalFormat df = new DecimalFormat("###,###,###,###,###,###,###,###");
                    long itog = 0L;
                    while (rs.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        row.put("col1", rs.getString(1));
                        row.put("col2", df.format(rs.getLong(2) / (mode == 1 ? 0x100000L : 3600L)));
                        itog += rs.getLong(2);
                        data.addRow(row);
                    }
                    rs.close();
                    ps.close();
                    params.put("sum", df.format(itog).toString());
                }
                this.fillReportToStream("dialup_traffic", out, params, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

