/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.ipn;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Telekey_1
extends BGJasperReport {
    public Report_Telekey_1() {
        this.id = "ipn_contract_traffic_account";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            BGReportFilter filter = this.createBGReportFilter();
            int unit = Utils.parseInt((String)filter.getStringParam("unit"), (int)0);
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            String services = filter.getStringParam("services");
            Calendar date = TimeUtils.parseCalendar((String)filter.getStringParam("date"), (String)"dd.MM.yyyy");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("addInfo", " \u0433\u043e\u0434: " + date.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date.get(2)]);
            int del = 1;
            switch (unit) {
                case 1: {
                    del = 1024;
                    params.put("unit", "\u041a\u0411");
                    break;
                }
                case 2: {
                    del = 0x100000;
                    params.put("unit", "\u041c\u0411");
                    break;
                }
                case 3: {
                    del = 0x40000000;
                    params.put("unit", "\u0413\u0411");
                    break;
                }
                case 4: {
                    params.put("unit", "\u0427\u0430\u0441\u044b");
                }
            }
            DecimalFormat df = new DecimalFormat("### ### ### ### ##0.00");
            BGDataSource bds = new BGDataSource();
            String table = ServerUtils.getModuleMonthTableName((String)"ipn_contract_data", (Date)date.getTime(), (int)mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)table)) {
                StringBuffer query = new StringBuffer("SELECT contract.title, contract.comment, service.title, SUM(");
                if (unit == 4) {
                    query.append("account.hh");
                } else {
                    query.append("account.amount");
                }
                query.append(") as amount FROM " + table + " AS account LEFT JOIN contract ON account.cid=contract.id LEFT JOIN service ON account.sid=service.id");
                StringBuffer filterString = new StringBuffer();
                if (services != null && services.length() > 0 && !services.contains(";")) {
                    filterString.append(" WHERE account.sid IN (");
                    filterString.append(services);
                    filterString.append(")");
                }
                query.append(filterString);
                query.append(" GROUP BY account.cid, account.sid");
                try {
                    HashMap<String, Object> row;
                    double amount;
                    PreparedStatement ps = this.con.prepareStatement(query.toString());
                    ResultSet trafficRS = ps.executeQuery();
                    while (trafficRS.next()) {
                        amount = (double)trafficRS.getLong(4) / (double)del;
                        row = new HashMap<String, Object>();
                        row.put("contract", trafficRS.getString(1));
                        row.put("comment", trafficRS.getString(2));
                        row.put("service", trafficRS.getString(3));
                        row.put("amount", df.format(amount));
                        bds.addRow(row);
                    }
                    trafficRS.close();
                    ps.close();
                    query = new StringBuffer("SELECT service.title, SUM(");
                    if (unit == 4) {
                        query.append("account.hh");
                    } else {
                        query.append("account.amount");
                    }
                    query.append(") FROM " + table + " AS account LEFT JOIN contract ON account.cid=contract.id LEFT JOIN service ON account.sid=service.id ");
                    query.append(filterString);
                    query.append(" GROUP BY account.sid");
                    ps = this.con.prepareStatement(query.toString());
                    trafficRS = ps.executeQuery();
                    while (trafficRS.next()) {
                        amount = (double)trafficRS.getLong(2) / (double)del;
                        row = new HashMap();
                        row.put("contract", "\u00a0\u0418\u0442\u043e\u0433\u043e:");
                        row.put("comment", "");
                        row.put("service", trafficRS.getString(1));
                        row.put("amount", df.format(amount));
                        bds.addRow(row);
                    }
                    trafficRS.close();
                    ps.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            this.fillReportToStream(this.id, out, params, bds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

