/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.robokassa.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.robokassa.common.bean.Transaction;
import ru.bitel.bgbilling.modules.robokassa.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.robokassa.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="RobokassaExecutor", urlPatterns={"/robokassa/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final char CHAR_COLON = ':';
    private static final String PARAM_SIGNATURE_VALUE = "SignatureValue";
    private static final String PARAM_OUT_SUM = "OutSum";
    private static final String PARAM_INV_ID = "InvId";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        con = null;
        try {
            moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
            con = Setup.getSetup().getDBConnectionFromPool();
            moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            transactionId = request.getParameter("InvId");
            outSum = request.getParameter("OutSum");
            signatureValue = request.getParameter("SignatureValue");
            merchantPass2 = moduleSetup.get("robokassa.merchant.password.2", "");
            if (transactionId == null || outSum == null || signatureValue == null) ** GOTO lbl96
            signData = outSum + ':' + transactionId + ':' + merchantPass2;
            checkSignData = Utils.getDigest((String)signData, (String)"UTF-8");
            if (!signatureValue.equals(checkSignData)) ** GOTO lbl92
            transactionManager = new TransactionManager(con, moduleId);
            transaction = (Transaction)transactionManager.get(Utils.parseInt((String)transactionId));
            if (transaction == null) {
                ModuleExecutor.logger.error("Not found transaction for ID = " + transactionId);
                response.setStatus(500);
            }
            ** GOTO lbl-1000
            transactionManager.close();
            ** GOTO lbl33
        }
        catch (BGException ex) {
            block33: {
                try {
                    ModuleExecutor.logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable var19_26) {
                    ServerUtils.closeConnection(con);
                    throw var19_26;
                }
lbl33:
                // 1 sources

                ServerUtils.closeConnection((Connection)con);
                return;
lbl-1000:
                // 1 sources

                {
                    if (transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) ** GOTO lbl-1000
                    ModuleExecutor.logger.error("Transaction for ID = " + transactionId + " has status != 'created'");
                    response.setStatus(200);
                }
                transactionManager.close();
                ServerUtils.closeConnection((Connection)con);
                return;
lbl-1000:
                // 1 sources

                {
                    if (transaction.getPaymentId() <= 0) break block33;
                    ModuleExecutor.logger.error("Transaction for ID = " + transactionId + " has PaymentId > 0");
                    response.setStatus(200);
                }
                transactionManager.close();
                ServerUtils.closeConnection((Connection)con);
                return;
            }
            ** try [egrp 7[TRYBLOCK] [9 : 299->695)] { 
lbl49:
            // 1 sources

            transaction.setSum(new BigDecimal(outSum));
            transaction.setTransactionId(transactionId);
            transaction.setTransactionDate(new Date());
            transaction.setStatus(TransactionStatus.OK.getCode());
            paymentDate = transaction.getTransactionDate();
            if (paymentDate == null) {
                paymentDate = new Date();
                transaction.setTransactionDate(paymentDate);
            }
            payment = Payment.builder().setDate(paymentDate).setTypeId(moduleSetup.getInt("robokassa.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(moduleSetup.get("robokassa.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437 \u0420\u0424\u0418 \u0411\u0430\u043d\u043a\u0430 [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId()))).build();
            paymentDao = new PaymentDao(con);
            try {
                paymentDao.update((Object)payment);
                transaction.setPaymentId(payment.getId());
            }
            finally {
                paymentDao.close();
            }
            transactionManager.update(transaction);
            balanceUtils = new BalanceUtils(con);
            try {
                balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
            }
            finally {
                balanceUtils.close();
            }
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
            response.setContentType("text/plain");
            out = response.getWriter();
            try {
                out.print("OK");
                out.print(transactionId);
                out.flush();
            }
lbl89:
            // 1 sources

            finally {
                transactionManager.close();
            }
lbl92:
            // 1 sources

            ModuleExecutor.logger.error("Error check sign (in request check = '" + signatureValue + "' no equals calculate = '" + checkSignData + "' )");
            response.setStatus(500);
            ServerUtils.closeConnection((Connection)con);
            return;
lbl96:
            // 2 sources

            ServerUtils.closeConnection((Connection)con);
            return;
            ServerUtils.closeConnection((Connection)con);
            return;
        }
    }
}

