/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class RSCMServiceManager {
    private Connection con;
    private int moduleId;

    public RSCMServiceManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    private RSCMService getServiceFromRS(ResultSet rs) throws SQLException {
        return RSCMService.builder().setId(rs.getInt("id")).setServiceId(rs.getInt("sid")).setServiceTitle(rs.getString("title")).setUnit(rs.getString("unit")).setInstallmentData(rs.getString("installment")).build();
    }

    public List<RSCMService> getServiceList() {
        return this.getServiceList(null);
    }

    public List<RSCMService> getServiceList(Boolean isusing) {
        ArrayList<RSCMService> result = new ArrayList<RSCMService>();
        try {
            StringBuilder query = new StringBuilder("SELECT rscm.*, service.title FROM rscm_service_").append(this.moduleId).append(" AS rscm ").append(" LEFT JOIN service ON service.id=rscm.sid");
            if (isusing != null) {
                query.append(" WHERE service.isusing=").append(isusing != false ? 0 : 1);
            }
            query.append(" ORDER BY service.title");
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                result.add(this.getServiceFromRS(rs));
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateService(RSCMService rscmService) throws BGException {
        if (rscmService == null) {
            return;
        }
        boolean insert = rscmService.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + "rscm_service_" + this.moduleId + " SET sid=?, unit=?, installment=?" + (insert ? "" : " WHERE id=?");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            ps.setInt(parameterIndex++, rscmService.getServiceId());
            ps.setString(parameterIndex++, rscmService.getUnit());
            ps.setString(parameterIndex++, rscmService.getInstallmentData());
            if (!insert) {
                ps.setInt(parameterIndex++, rscmService.getId());
            }
            ps.executeUpdate();
            if (insert) {
                rscmService.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException();
        }
    }

    public void deleteService(int id) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM rscm_service_" + this.moduleId + " WHERE id=" + id);
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public RSCMService getService(int id) {
        RSCMService result = null;
        try (Statement st = this.con.createStatement();){
            String query = "SELECT rscm.*, service.title FROM rscm_service_" + this.moduleId + " as rscm LEFT JOIN service ON service.id=rscm.sid  WHERE rscm.id=" + id;
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                result = this.getServiceFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public RSCMService getServiceByServiceId(int serviceId) {
        RSCMService result = null;
        try (Statement st = this.con.createStatement();){
            String query = "SELECT rscm.*, service.title FROM rscm_service_" + this.moduleId + " as rscm LEFT JOIN service ON service.id=rscm.sid  WHERE rscm.sid=" + serviceId;
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                result = this.getServiceFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

