/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.client;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.rscm.client.RSCMUtils;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMServiceDto;
import ru.bitel.bgbilling.modules.rscm.common.service.RSCMService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ServicePropertiesServices
extends BGUPanel {
    private AbstractBGUPanel.DefaultAction loadInstallmentAction;
    private BGUTable serviceTable = null;
    private BGUTable installmentTable = null;
    private RSCMService rscmService = null;
    private JLabel recordsLabel = new JLabel();
    private ButtonGroup statusButtonGroup = new ButtonGroup();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonth periodPanel = new BGControlPanelMonth();
    private ContractServiceTableModel serviceTableModel = new ContractServiceTableModel();
    private ContractServiceInstallmentTableModel installmentTableModel = new ContractServiceInstallmentTableModel();

    protected void jbInit() throws Exception {
        this.serviceTable = new BGUTable((TableModel)((Object)this.serviceTableModel));
        this.serviceTable.setSelectionMode(0);
        this.serviceTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicePropertiesServices.this.performAction("edit");
                }
            }
        });
        this.periodPanel.addPropertyChangeListener(evt -> {
            if ("date".equals(evt.getPropertyName())) {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            }
        });
        this.pagePanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().startsWith("to")) {
                this.performAction("refresh");
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)this.serviceTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.getInstallmentPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.recordsLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getInstallmentPanel() {
        JMenuItem suspendMenuItem = new JMenuItem("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        suspendMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().suspendRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem resumeMenuItem = new JMenuItem("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c");
        resumeMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().resumeRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem closeMenuItem = new JMenuItem("\u0414\u043e\u0441\u0440\u043e\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0441\u0438\u0442\u044c");
        closeMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty() && ClientUtils.confirm((String)"\u0414\u043e\u0441\u0440\u043e\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0441\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438?", (String)"\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().closeRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem cancelMenuItem = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438");
        cancelMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().cancelRSCMContractServiceInstallment(installment.getId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        JMenuItem infoMenuItem = new JMenuItem("\u0414\u0430\u043d\u043d\u044b\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438");
        infoMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                JTextArea info = new JTextArea(20, 70);
                info.setMargin(new Insets(3, 3, 3, 3));
                info.setText(new JSONObject(((RSCMContractServiceInstallment)rows.get(0)).getInstallment()).toString(3));
                JScrollPane scrollPane = new JScrollPane(info);
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, "\u0414\u0430\u043d\u043d\u044b\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438", 1);
            }
        });
        JMenuItem deleteMenuItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteMenuItem.addActionListener(e -> {
            List rows = this.installmentTableModel.getSelectedRows();
            if (!rows.isEmpty()) {
                for (RSCMContractServiceInstallment installment : rows) {
                    try {
                        this.getRSCMService().deleteRSCMContractServiceInstallment(installment.getId(), ((ClientContext)this.getContext()).getContractId());
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
                this.performAction("refresh");
            }
        });
        this.installmentTable = new BGUTable((TableModel)((Object)this.installmentTableModel));
        this.installmentTable.setSelectionMode(0);
        this.installmentTable.getPopupMenu().add(suspendMenuItem);
        this.installmentTable.getPopupMenu().add(resumeMenuItem);
        this.installmentTable.getPopupMenu().add(closeMenuItem);
        this.installmentTable.getPopupMenu().add(cancelMenuItem);
        this.installmentTable.getPopupMenu().add(infoMenuItem);
        this.installmentTable.getPopupMenu().add(deleteMenuItem);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getStatusButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.installmentTable, (int)200, (int)200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatusButtonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 3, 0), 0, 0));
        for (RSCMContractServiceInstallmentStatus status : RSCMContractServiceInstallmentStatus.values()) {
            JToggleButton statusButton = new JToggleButton((Action)this.loadInstallmentAction);
            statusButton.setText(status.getTitle());
            statusButton.setActionCommand(String.valueOf(status.getCode()));
            statusButton.setSelected(status == RSCMContractServiceInstallmentStatus.IN_PROGRESS);
            this.statusButtonGroup.add(statusButton);
            panel.add((Component)statusButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private RSCMService getRSCMService() {
        if (this.rscmService == null) {
            this.rscmService = (RSCMService)((ClientContext)this.getContext()).getPort(RSCMService.class);
        }
        return this.rscmService;
    }

    protected void initActions() {
        this.loadInstallmentAction = new AbstractBGUPanel.DefaultAction("loadInstallment", "\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438"){

            public void actionPerformedImpl(ActionEvent event) throws Exception {
                int status = Utils.parseInt((String)ServicePropertiesServices.this.statusButtonGroup.getSelection().getActionCommand(), (int)1);
                SearchResult searchResult = ServicePropertiesServices.this.getRSCMService().searchRSCMContractServiceInstallment(((ClientContext)ServicePropertiesServices.this.getContext()).getContractId(), status, ServicePropertiesServices.this.installmentTable.getSort(), null);
                ServicePropertiesServices.this.installmentTableModel.setServices(((ModuleService)((ClientContext)ServicePropertiesServices.this.getContext()).getWebService(ModuleService.class, 0)).serviceList(((ClientContext)ServicePropertiesServices.this.getContext()).getModuleId()));
                ServicePropertiesServices.this.installmentTableModel.setData(searchResult.getList(), true);
            }
        };
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            LocalDate calendar = this.periodPanel.getLocalDate().withDayOfMonth(1);
            Period period = new Period(calendar, calendar.plusMonths(1L).minusDays(1L));
            SearchResult searchResult = this.getRSCMService().searchRSCMContractService(((ClientContext)this.getContext()).getContractId(), period, this.serviceTable.getSort(), this.pagePanel.getPage());
            this.serviceTableModel.setData(searchResult.getList(), true);
            this.pagePanel.setPage(searchResult.getPage());
            this.recordsLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.loadInstallmentAction.perform();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new EditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", new RSCMContractService()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.serviceTableModel.optSelectedRow().filter(a -> a.getInstallmentId() <= 0).ifPresentOrElse(a -> new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u043b\u0443\u0433\u0438", (RSCMContractService)a).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e")));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            RSCMContractService rscmContractService = (RSCMContractService)this.serviceTableModel.getSelectedRow();
            if (rscmContractService != null) {
                if (rscmContractService.getInstallmentId() > 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e");
                    return;
                }
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443\u0441\u043b\u0443\u0433\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.getRSCMService().deleteRSCMContractService(rscmContractService.getId(), ((ClientContext)this.getContext()).getContractId(), rscmContractService.getDate());
                    EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)this.getContext()).getContractId()));
                    this.performAction("refresh");
                }
            }
        });
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.periodPanel.setEnabled(enabled);
        this.serviceTable.setEnabled(enabled);
    }

    class ContractServiceTableModel
    extends AbstractTransactionTableModel<RSCMContractService> {
        public ContractServiceTableModel() {
            super(ContractServiceTableModel.class.getName(), RSCMContractService.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, "date", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430", Boolean.class, 100, 100, 100, "installment", true);
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 100, 100, 100, "amount", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u0415\u0434. \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f", 110, 110, 110, "unit", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RSCMContractService rscmContractService, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("installment".equals(identifier)) {
                return rscmContractService.getInstallmentId() > 0;
            }
            if ("amount".equals(identifier)) {
                if (rscmContractService.getAmountDown() == 1) {
                    return String.valueOf(rscmContractService.getAmountUp());
                }
                int amountDown = rscmContractService.getAmountDown();
                int n = amountDown = amountDown == 0 ? 100 : amountDown;
                if (rscmContractService.getAmountUp() % amountDown == 0) {
                    return String.valueOf(rscmContractService.getAmountUp() / amountDown);
                }
                return rscmContractService.getAmountUp() + "/" + amountDown;
            }
            return super.getValue((Object)rscmContractService, column);
        }
    }

    class ContractServiceInstallmentTableModel
    extends BGTableModel<RSCMContractServiceInstallment> {
        private Map<Integer, String> serviceMap;

        public ContractServiceInstallmentTableModel() {
            super(ContractServiceInstallmentTableModel.class.getName());
            this.serviceMap = new HashMap<Integer, String>();
        }

        public void setServices(List<Service> list) {
            HashMap<Integer, String> serviceMap = new HashMap<Integer, String>();
            if (list != null && !list.isEmpty()) {
                for (Service service : list) {
                    serviceMap.put(service.getId(), service.getGuiTitle());
                }
            }
            this.serviceMap = serviceMap;
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 130, 130, 130, "dateFrom", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043b\u0435\u0434. \u043f\u043b\u0430\u0442\u0435\u0436\u0430", 150, 150, 150, "dateNext", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 100, 100, -1, "serviceId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043b-\u0432\u043e", 70, 70, 70, "amount", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041f\u043b\u0430\u0442\u0435\u0436\u0438", 100, 100, 100, "paymentCount", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e", 100, 100, 100, "paymentSum", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", 100, 100, -1, "installment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RSCMContractServiceInstallment installment, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("serviceId".equals(identifier)) {
                return this.serviceMap.getOrDefault(installment.getServiceId(), "#" + installment.getServiceId());
            }
            if ("paymentCount".equals(identifier)) {
                JSONObject json = new JSONObject(installment.getInstallment());
                JSONArray payments = json.optJSONArray("paymentsArray");
                return installment.getPaymentCount() + " \u0438\u0437 " + (payments == null ? 0 : payments.length());
            }
            if ("status".equals(identifier)) {
                return installment.getStatus().getTitle();
            }
            if ("installment".equals(identifier)) {
                return RSCMUtils.getInstallmentDescription(new JSONObject(installment.getInstallment()));
            }
            if ("amount".equals(identifier)) {
                if (installment.getAmountDown() == 1) {
                    return String.valueOf(installment.getAmountUp());
                }
                if (installment.getAmountUp() % installment.getAmountDown() == 0) {
                    return String.valueOf(installment.getAmountUp() / installment.getAmountDown());
                }
                return installment.getAmountUp() + "/" + installment.getAmountDown();
            }
            if ("paymentSum".equals(identifier)) {
                int sum = 0;
                int parts = 0;
                JSONObject json = new JSONObject(installment.getInstallment());
                JSONArray paymentsArray = json.optJSONArray("paymentsArray");
                if (paymentsArray != null) {
                    int index;
                    for (index = 0; index < installment.getPaymentCount(); ++index) {
                        sum += paymentsArray.getInt(index);
                    }
                    for (index = 0; index < paymentsArray.length(); ++index) {
                        parts += paymentsArray.getInt(index);
                    }
                }
                return sum * installment.getAmountUp() / parts + "/" + installment.getAmountDown();
            }
            return super.getValue((Object)installment, column);
        }
    }

    class EditorDialog
    extends BGEditorDialog<RSCMContractService> {
        private JTabbedPane tabbedPane;
        private BGTextArea comment;
        private BGTextArea paymentDates;
        private JTextField amount;
        private BGUList<RSCMServiceDto> service;
        private BGUList<RSCMServiceDto> installment;
        private BGControlPanelDateNoB date;
        private BGControlPanelDateNoB paymentStartDate;
        private JPanel datePanel;
        private JPanel commentPanel;
        private JPanel paymentDatePanel;

        public EditorDialog(String title, RSCMContractService data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.comment = new BGTextArea(5, 15);
            this.paymentDates = new BGTextArea(5, 15);
            this.amount = new JTextField(17);
            this.service = new BGUList();
            this.installment = new BGUList();
            this.date = new BGControlPanelDateNoB();
            this.paymentStartDate = new BGControlPanelDateNoB();
            this.datePanel = null;
            this.commentPanel = null;
            this.paymentDatePanel = null;
        }

        public void doDialogPanel() {
            this.tabbedPane.add((Component)this.getServicePanel(), "\u0420\u0430\u0437\u043e\u0432\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438");
            this.tabbedPane.add((Component)this.getInstallmentPanel(), "\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0438");
            this.tabbedPane.addChangeListener(a -> {
                this.datePanel.setVisible(this.tabbedPane.getSelectedIndex() == 0);
                this.commentPanel.setVisible(this.tabbedPane.getSelectedIndex() == 0);
                this.paymentDatePanel.setVisible(this.tabbedPane.getSelectedIndex() == 1);
            });
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 3, 3), 0, 0));
            this.panel.add((Component)this.getRightEditPanel(), new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 17, 1, new Insets(0, 5, 3, 0), 0, 0));
            try {
                List list = ServicePropertiesServices.this.getRSCMService().getRSCMContractServiceList(false);
                this.service.setData(list.stream().filter(a -> !a.isInstallment()).toList());
                this.installment.setData(list.stream().filter(a -> a.isInstallment()).toList());
                if (((RSCMContractService)this.data).getId() > 0) {
                    list.stream().filter(i -> i.getId() == ((RSCMContractService)this.data).getServiceId()).forEach(i -> this.service.setSelectedValue(i, true));
                    this.date.setLocalDate(((RSCMContractService)this.data).getDate());
                    this.amount.setText(((RSCMContractService)this.data).getAmountUp() + "/" + ((RSCMContractService)this.data).getAmountDown());
                    this.comment.setText(((RSCMContractService)this.data).getComment());
                    this.tabbedPane.setEnabled(false);
                } else {
                    this.date.setLocalDate(null);
                    this.amount.setText("");
                    this.comment.setText("");
                }
                this.date.setEnabled(((RSCMContractService)this.data).getId() == 0);
                this.date.setButtonNow(((RSCMContractService)this.data).getId() == 0);
                this.amount.setEnabled(((RSCMContractService)this.data).getId() == 0 || ((RSCMContractService)this.data).getInstallmentId() < 1);
                this.service.setEnabled(((RSCMContractService)this.data).getId() == 0 || ((RSCMContractService)this.data).getInstallmentId() < 1 && ClientSetup.getInstance().getBoolean("dbinfo.rscm.service.list.enabled", false));
                this.paymentStartDate.setButtonNow(true);
                this.paymentDatePanel.setVisible(false);
                this.paymentDates.setEditable(false);
                this.paymentStartDate.addPropertyChangeListener(a -> this.showPaymetDates());
                this.installment.addListSelectionListener(a -> this.showPaymetDates());
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        private void showPaymetDates() {
            Object dates = "";
            RSCMServiceDto rscmServiceDto = (RSCMServiceDto)this.installment.getSelectedValue();
            LocalDate date = this.paymentStartDate.getLocalDate();
            if (date != null && rscmServiceDto != null) {
                switch (rscmServiceDto.getPaymentMode()) {
                    case "day": {
                        for (int index = 0; index < rscmServiceDto.getPayments(); ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusDays(1L);
                        }
                        break;
                    }
                    case "week": {
                        for (int index = 0; index < rscmServiceDto.getPayments(); ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusWeeks(1L);
                        }
                        break;
                    }
                    case "quarter": {
                        for (int index = 0; index < rscmServiceDto.getPayments(); ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusMonths(3L);
                        }
                        break;
                    }
                    case "month": {
                        for (int index = 0; index < rscmServiceDto.getPayments(); ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusMonths(1L);
                        }
                        break;
                    }
                    case "monthFirst": {
                        dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                        date = date.getDayOfMonth() == 1 ? date : date.withDayOfMonth(1).plusMonths(1L);
                        for (int index = 0; index < rscmServiceDto.getPayments() - 1; ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusMonths(1L);
                        }
                        break;
                    }
                    case "monthLast": {
                        dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                        date = date.getDayOfMonth() == date.lengthOfMonth() ? date : date.withDayOfMonth(date.lengthOfMonth());
                        for (int index = 0; index < rscmServiceDto.getPayments() - 1; ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusMonths(1L);
                            date = date.withDayOfMonth(date.lengthOfMonth());
                        }
                        break;
                    }
                    case "year": {
                        for (int index = 0; index < rscmServiceDto.getPayments(); ++index) {
                            dates = (String)dates + TimeUtils.format((LocalDate)date, (String)"dd.MM.yyyy") + "\n";
                            date = date.plusYears(1L);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected value: " + rscmServiceDto.getPaymentMode());
                    }
                }
            }
            this.paymentDates.setText((String)dates);
        }

        private JPanel getServicePanel() {
            this.service.setSelectionMode(0);
            this.service.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.service, (int)600, (int)300), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
            return panel;
        }

        private JPanel getInstallmentPanel() {
            this.installment.setSelectionMode(0);
            this.installment.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.installment, (int)600, (int)300), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1), 0, 0));
            return panel;
        }

        private JPanel getRightEditPanel() {
            this.amount.setHorizontalAlignment(0);
            this.date.setButtonNow(true);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0));
            panel.add((Component)this.amount, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.datePanel = this.getDatePanel();
            panel.add((Component)this.datePanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.commentPanel = this.getCommentPanel();
            panel.add((Component)this.commentPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.paymentDatePanel = this.getPaymentDatePanel();
            panel.add((Component)this.paymentDatePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDatePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            panel.add((Component)this.date, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getPaymentDatePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            panel.add((Component)this.paymentStartDate, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            panel.add((Component)new JLabel("\u0413\u0440\u0430\u0444\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.paymentDates), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getCommentPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 3, 3, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            LocalDate localDate;
            IdTitle idTitle = this.tabbedPane.getSelectedIndex() == 0 ? (IdTitle)this.service.getSelectedValue() : (IdTitle)this.installment.getSelectedValue();
            LocalDate localDate2 = localDate = this.tabbedPane.getSelectedIndex() == 0 ? this.date.getLocalDate() : this.paymentStartDate.getLocalDate();
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return false;
            }
            if (Utils.isEmptyString((String)this.amount.getText()) || "0".equals(this.amount.getText()) || !this.amount.getText().matches("^\\d+|\\d+\\/\\d+|\\d+[\\.\\,]\\d+$")) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e! (\u0446\u0435\u043b\u043e\u0435 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435, \u0434\u0440\u043e\u0431\u044c X/Y \u0438\u043b\u0438 \u0434\u0435\u0441\u044f\u0442\u0438\u0447\u043d\u043e\u0435 X.YY)");
                return false;
            }
            if (localDate == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430!");
                return false;
            }
            ((RSCMContractService)this.data).setDate(localDate);
            ((RSCMContractService)this.data).setContractId(((ClientContext)ServicePropertiesServices.this.getContext()).getContractId());
            ((RSCMContractService)this.data).setServiceId(idTitle.getId());
            ((RSCMContractService)this.data).setComment(this.comment.getText());
            String amountValue = this.amount.getText().replace(',', '.');
            if (amountValue.matches("^\\d+$")) {
                ((RSCMContractService)this.data).setAmountUp(Utils.parseInt((String)amountValue));
                ((RSCMContractService)this.data).setAmountDown(1);
            } else if (amountValue.matches("^\\d+\\/\\d+$")) {
                ((RSCMContractService)this.data).setAmountUp(Utils.parseInt((String)amountValue.replaceAll("^(\\d+)\\/\\d+$", "$1")));
                ((RSCMContractService)this.data).setAmountDown(Utils.parseInt((String)amountValue.replaceAll("^\\d+\\/(\\d+)$", "$1")));
            } else if (amountValue.matches("^\\d+\\.\\d+$")) {
                String frac = amountValue.replaceAll("^\\d+\\.(\\d+)$", "$1");
                BigDecimal down = BigDecimal.TEN.pow(frac.length());
                BigDecimal up = new BigDecimal(amountValue).multiply(down);
                ((RSCMContractService)this.data).setAmountUp(up.intValue());
                ((RSCMContractService)this.data).setAmountDown(down.intValue());
            }
            try {
                ServicePropertiesServices.this.getRSCMService().updateRSCMContractService((RSCMContractService)this.data);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, ((ClientContext)ServicePropertiesServices.this.getContext()).getContractId()));
                ServicePropertiesServices.this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return false;
            }
            return true;
        }
    }
}

