/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostRtspTransport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ForpostRtspTransportDao
extends AbstractDao<ForpostRtspTransport> {
    public ForpostRtspTransportDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_forpost_rtsp_transport");
    }

    public List<ForpostRtspTransport> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    protected ForpostRtspTransport getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ForpostRtspTransport(rs.getString("id"), rs.getString("name"));
    }

    protected void updateImpl(ForpostRtspTransport forpostRtspTransport) throws BGException {
        if (forpostRtspTransport != null) {
            try {
                int parameterIndex = 1;
                boolean insert = forpostRtspTransport.getId() != null;
                String sql = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET id=?, name=?" + (insert ? "" : " WHERE id=?");
                PreparedStatement ps = this.con.prepareStatement(sql);
                ps.setString(parameterIndex++, forpostRtspTransport.getId());
                ps.setString(parameterIndex++, forpostRtspTransport.getName());
                if (!insert) {
                    ps.setString(parameterIndex++, forpostRtspTransport.getId());
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(ps.toString());
                }
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public void searchForpostRtspTransports(SearchResult<ForpostRtspTransport> searchResult) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + (page != null ? page.sqlLimit() : ""), 1);){
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(ps.toString());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public void doSync(ForpostRtspTransport[] rtspTransports) throws BGException {
        if (rtspTransports == null) {
            return;
        }
        long now = System.currentTimeMillis();
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET id=?, name=?, sync_datetime=? ON DUPLICATE KEY UPDATE name=?, sync_datetime=?");
             PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE sync_datetime<>?");){
            for (ForpostRtspTransport forpostRtspTransport : rtspTransports) {
                int parameterIndex = 1;
                psInsert.setString(parameterIndex++, forpostRtspTransport.getId());
                psInsert.setString(parameterIndex++, forpostRtspTransport.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.setString(parameterIndex++, forpostRtspTransport.getName());
                psInsert.setLong(parameterIndex++, now);
                psInsert.executeUpdate();
            }
            psDelete.setLong(1, now);
            psDelete.executeUpdate();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

