/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.intercom;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercomFlat;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class SmartHouseIntercomFlatDao
extends AbstractIdDao<SmartHouseIntercomFlat> {
    private final String TABLE_STATUS_LOG;

    public SmartHouseIntercomFlatDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_intercom_flat");
        this.TABLE_STATUS_LOG = "smarthouse_intercom_flat_status_log_" + moduleId;
    }

    public List<SmartHouseIntercomFlat> list(int intercomId) throws SQLException, BGException {
        return this.list("intercom_id=?", "flat", new Object[]{intercomId});
    }

    public List<SmartHouseIntercomFlat> listByContractId(int contractId) throws SQLException, BGException {
        return this.list("contract_id=?", "flat", new Object[]{contractId});
    }

    public void insertSmartHouseIntercomFlatStatusLog(int intercomFlatId, LocalDateTime updateTime, boolean status, int userId) throws BGException {
        try (PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO `" + this.TABLE_STATUS_LOG + "` SET `id`=?, `update_date`=?, `status`=?, `user_id`=?");){
            int paramIndex = 1;
            psInsert.setInt(paramIndex++, intercomFlatId);
            psInsert.setTimestamp(paramIndex++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)updateTime));
            psInsert.setBoolean(paramIndex++, status);
            psInsert.setInt(paramIndex++, userId);
            psInsert.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void searchSmartHouseIntercomFlatStatusLogs(SearchResult<String> searchResult, int intercomFlatId) throws BGException {
        Page page = searchResult.getPage();
        List list = searchResult.getList();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS * FROM `" + this.TABLE_STATUS_LOG + "` WHERE `id`=?" + (page != null ? page.sqlLimit() : ""));){
            ps.setInt(1, intercomFlatId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JSONObject json = new JSONObject();
                    json.put("id", rs.getInt("id"));
                    json.put("updateDate", (Object)TimeUtils.formatTimestamp((Timestamp)rs.getTimestamp("update_date"), (String)"dd.MM.yyyy HH:mm:ss"));
                    json.put("status", (Object)rs.getString("status"));
                    json.put("userId", (Object)rs.getString("user_id"));
                    list.add(json.toString());
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected SmartHouseIntercomFlat getFromRS(ResultSet rs) throws SQLException, BGException {
        return (SmartHouseIntercomFlat)this.ormFromResultSet(rs, SmartHouseIntercomFlat.class);
    }

    protected void updateImpl(SmartHouseIntercomFlat smartHouseIntercomFlat) throws BGException, SQLException {
        this.ormUpdateImpl(smartHouseIntercomFlat, null, null, null, null);
    }
}

