/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTextDialog;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.SearchResult;

public class SormStatisticPanel
extends BGUPanel {
    protected BGUTable table;
    private BGTableModel<SormUploadStatistic> tableModel;
    private final JLabel recordCountLabel = new JLabel();
    private final BGControlPanelPages page = new BGControlPanelPages();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043e\u043a");
        this.page.setKey(((Object)((Object)this)).getClass().getName());
        this.tableModel = new BGTableModel<SormUploadStatistic>("\u0421\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043e\u043a"){

            protected void initColumns() {
                this.addColumn("ID \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c", -1, 200, 200, "sormProjectId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438", Column.DateTime.class, -1, 200, 200, "startUploadTime", true);
                this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438", Column.DateTime.class, -1, 200, 200, "endUploadTime", true);
                this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", -1, 200, 250, "contractUploadCount", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("ID \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 200, -1, "firstUploadContractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("ID \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, 200, -1, "lastUploadContractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430 FTP", -1, 200, -1, "uploadToFtpStatus", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
                this.addColumn("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u0430\u0439\u043b\u0430\u0445", -1, 250, -1, "filesInfoDescription", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }

            public Object getValue(SormUploadStatistic statistic, int column) throws BGException {
                return switch (column) {
                    case 6 -> {
                        if (statistic.getUploadToFtpStatus()) {
                            yield "\u0423\u0441\u043f\u0435\u0448\u043d\u043e";
                        }
                        yield "\u041d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + statistic.getFtpUploadErrorMessage();
                    }
                    case 7 -> statistic.getUploadFilesInfo();
                    default -> super.getValue((Object)statistic, column);
                };
            }
        };
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem tryUploadAgain = new JMenuItem("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441\u043d\u043e\u0432\u0430");
        tryUploadAgain.addActionListener(e -> {
            try {
                this.getService().tryUploadToFTPAgain((SormUploadStatistic)this.tableModel.getSelectedRow());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        popupMenu.add(tryUploadAgain);
        this.table = new BGUTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SormUploadStatistic selectedStatistic = (SormUploadStatistic)SormStatisticPanel.this.tableModel.getSelectedRow();
                if (selectedStatistic == null) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && !selectedStatistic.getUploadToFtpStatus()) {
                    popupMenu.show((Component)SormStatisticPanel.this.table, e.getX(), e.getY());
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int selectedColumnIndex = SormStatisticPanel.this.table.getSelectedColumn();
                    switch (selectedColumnIndex) {
                        case 4: 
                        case 5: {
                            int contractId = selectedColumnIndex == 4 ? selectedStatistic.getFirstUploadContractId() : selectedStatistic.getLastUploadContractId();
                            if (contractId <= 0) break;
                            BGClientBase.getFrame().getTabbedPane().addTab((BGTabPanel)new ContractEditor(contractId));
                            break;
                        }
                        case 6: {
                            SormStatisticPanel.this.createBGTextDialogWindow((String)(selectedStatistic.getUploadToFtpStatus() ? "\u0423\u0441\u043f\u0435\u0448\u043d\u043e" : "\u041d\u0435 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + selectedStatistic.getFtpUploadErrorMessage()));
                            break;
                        }
                        case 7: {
                            SormStatisticPanel.this.createBGTextDialogWindow(String.join((CharSequence)"\n", selectedStatistic.getUploadFilesInfo().split(";")));
                        }
                    }
                }
            }
        });
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void createBGTextDialogWindow(String text) {
        BGTextDialog dialog = new BGTextDialog();
        dialog.setModal(true);
        dialog.getTextArea().setEditable(false);
        dialog.getTextArea().setText(text);
        dialog.setVisible(true);
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addPropertyChangeListener(evt -> {
            if (this.tableModel.getRowCount() > 0) {
                try {
                    this.loadStatisticOfProject(((SormUploadStatistic)this.tableModel.getRows().get(0)).getSormProjectId());
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0);
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    public void loadStatisticOfProject(SormProject sormProject) throws BGException {
        if (sormProject == null) {
            return;
        }
        this.loadStatisticOfProject(sormProject.getId());
    }

    public void loadStatisticOfProject(int sormProjectId) throws BGException {
        SearchResult result = this.getService().getStatisticOfProject(sormProjectId, this.page.getPage());
        this.tableModel.setData(result.getList());
        this.page.setPage(result.getPage());
        this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + result.getPage().getRecordCount());
    }

    private SormService getService() {
        return (SormService)((ClientContext)this.getContext()).getPort(SormService.class, ((ClientContext)this.getContext()).getModuleId());
    }
}

