/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.service;

import jakarta.annotation.PreDestroy;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.tv.common.bean.ProlongationType;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvChannelSpec;
import ru.bitel.bgbilling.modules.tv.common.bean.TvServiceSpecChannelLink;
import ru.bitel.bgbilling.modules.tv.common.service.TvService;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.bean.TvChannelSpecDao;
import ru.bitel.bgbilling.modules.tv.server.task.TvRecalculator;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.tv.common.service.TvService")
public class TvServiceImpl
extends AbstractService
implements TvService {
    private TvChannelSpecDao tvChannelSpecDao = null;
    private ProductManager productManager = null;

    private TvChannelSpecDao getTvChannelSpecDao() {
        if (this.tvChannelSpecDao == null) {
            this.tvChannelSpecDao = new TvChannelSpecDao(this.getConnection(), this.moduleId);
            return this.tvChannelSpecDao;
        }
        return this.tvChannelSpecDao;
    }

    private ProductManager getProductManager() throws BGException {
        if (this.productManager == null) {
            this.productManager = new ProductManager(this.context, this.moduleId);
            return this.productManager;
        }
        return this.productManager;
    }

    @PreDestroy
    void destroy() {
        if (this.productManager != null) {
            this.productManager.close();
            this.productManager = null;
        }
    }

    public List<TvServiceSpecChannelLink> channelLinkList(int serviceSpecId, Date date) throws BGException {
        return null;
    }

    public void channelLinkUpdate(int serviceSpecId, List<TvServiceSpecChannelLink> linkList) throws BGException {
    }

    public List<TvChannelSpec> channelSpecList(int serviceSpecId, Date dateFrom, Date dateTo, String title) throws BGException {
        return this.getTvChannelSpecDao().list(serviceSpecId, dateFrom, dateTo, title, null);
    }

    public void channelSpecListUpdate(int serviceSpecId, List<TvChannelSpec> tvChannelSpecList) throws BGException {
        TvChannelSpecDao tvChannelSpecDao = this.getTvChannelSpecDao();
        List<TvChannelSpec> oldList = this.channelSpecList(serviceSpecId, null, null, null);
        for (TvChannelSpec tvChannelSpec : tvChannelSpecList) {
            tvChannelSpec.setServiceSpecId(serviceSpecId);
            tvChannelSpecDao.update((Entity)tvChannelSpec);
            oldList.remove(tvChannelSpec);
        }
        for (TvChannelSpec tvChannelSpec : oldList) {
            tvChannelSpecDao.delete(tvChannelSpec.getId());
        }
    }

    public int getProductSpecEntitySpecId() throws BGException {
        return this.getModuleSetup().getInt("productSpec.entitySpecId", 0);
    }

    public int getServiceSpecEntitySpecId() throws BGException {
        return this.getModuleSetup().getInt("serviceSpec.entitySpecId", 0);
    }

    public int getTvChannelSpecEntitySpecId() throws BGException {
        return this.getModuleSetup().getInt("tvChannelSpec.entitySpecId", 0);
    }

    public void recalculate(String email, Date dateFrom, Date dateTo, Set<Integer> contractGroupIds, Set<Integer> contractIds) throws BGException {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new TvRecalculator(this.moduleId, dateFrom, dateTo, contractGroupIds, contractIds, email));
    }

    public void prolongate(int contractId, BigDecimal balance, BigDecimal limit, ProlongationType prolongationType) throws BGException {
        this.getProductManager().productsProlongate(this.getConnectionSet(), contractId, balance, limit, prolongationType);
    }

    public BigDecimal precalculateAccount(int contractId, Date dateTo) throws BGException, BGMessageException, BGIllegalAccessException {
        return this.getProductManager().precalculateAccount(contractId, dateTo);
    }

    /*
     * Exception decompiling
     */
    public void groupOperationActivate(Set<Integer> contractIds, Date time, int productSpecId, int activationModeId, String description, String comment) throws BGIllegalArgumentException, BGMessageException, BGIllegalAccessException, BGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkCanActivateProductOnAccount(ProductOrderService productOrderService, ProductDao productDao, Integer contractId, TvAccount tvAccount, int productSpecId, int activationModeId, Date time, Date now) throws BGException, BGMessageException, BGIllegalAccessException, BGIllegalArgumentException {
        if (tvAccount.getParentId() > 0 || !TimeUtils.periodInRange((Date)now, (Date)now, (Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo()) || this.checkProductExists(productDao, contractId, tvAccount, time, productSpecId, activationModeId)) {
            return;
        }
        if (productOrderService.productOfferingGet(Integer.valueOf(this.moduleId), contractId.intValue(), tvAccount.getId(), productSpecId, activationModeId, time, true, false) == null) {
            throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
        }
    }

    private void activateProductOnAccount(ProductOrderService productOrderService, ProductDao productDao, Integer contractId, TvAccount tvAccount, int productSpecId, int activationModeId, Date time, Date now, String description, String comment) throws BGException, BGMessageException, BGIllegalAccessException, BGIllegalArgumentException {
        if (tvAccount.getParentId() > 0 || !TimeUtils.periodInRange((Date)now, (Date)now, (Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo()) || this.checkProductExists(productDao, contractId, tvAccount, time, productSpecId, activationModeId)) {
            return;
        }
        Product product = Product.builder().setContractId(contractId.intValue()).setAccountId(tvAccount.getId()).setProductSpecId(productSpecId).setActivationModeId(activationModeId).setDescription(Utils.maskNull((String)description)).setComment(Utils.maskNull((String)comment)).build();
        productOrderService.productActivate(product, time, false, true);
        this.context.commit();
    }

    private boolean checkProductExists(ProductDao productDao, Integer contractId, TvAccount tvAccount, Date time, int productSpecId, int activationModeId) throws BGException {
        List productList = productDao.list(this.moduleId, contractId.intValue(), tvAccount.getId(), false, null, null, time, null, false, false);
        for (Product product : productList) {
            if (product.getProductSpecId() != productSpecId || activationModeId > 0 && product.getActivationModeId() != activationModeId) continue;
            return true;
        }
        return false;
    }

    public void groupOperationDeactivate(Set<Integer> contractIds, Date time, int productSpecId, int activationModeId, boolean now) throws BGIllegalArgumentException, BGMessageException, BGIllegalAccessException, BGException {
        ProductOrderService productOrderService = (ProductOrderService)this.context.getService(ProductOrderService.class, 0);
        try (ProductDao productDao = new ProductDao(this.getConnection());){
            for (Integer contractId : contractIds) {
                List productList = productDao.list(this.moduleId, contractId.intValue(), 0, false, null, null, time, time, false, false);
                for (Product product : productList) {
                    if (product.getProductSpecId() != productSpecId || activationModeId > 0 && product.getActivationModeId() != activationModeId) continue;
                    productOrderService.productDeactivate(contractId.intValue(), product.getId(), time, false, true, now);
                    this.context.commit();
                }
            }
        }
    }

    public List<IdTitle> npayServiceList() throws BGException, BGMessageException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
            if (!"npay".equals(bgModule.getInstalledModule().getName())) continue;
            int moduleId = bgModule.getId();
            for (Service service : ModuleCache.getInstance().getModuleServicesList(moduleId)) {
                list.add(new IdTitle(service.getId(), bgModule.getTitle() + ": " + service.getTitle()));
            }
        }
        return list;
    }
}

