/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TvServiceCost
extends ServiceCost {
    public static final int PROLONGATION_REJECTED = 0;
    public static final int PROLONGATION_DELAYED = 1;
    public static final int PROLONGATION_APPROVED = 2;
    public static final int PROLONGATION_PROPORTIONAL = 3;
    private int productId;
    private int activationModeId;
    private Date activationTime;
    public Date prolongationTime;
    private ProductSpecRuntime productSpecRuntime;
    private ProductManager.Entry productItem;
    public int activationServiceId;
    public BigDecimal activationPrice = BigDecimal.ZERO;
    public boolean activationPriceExternal = false;
    public int prolongation = 0;
    public Date periodTimeFrom;
    public Date periodTimeTo;
    public int periodMode;
    public int periodAmount;
    public boolean periodAlign;
    public boolean periodProportional;
    public boolean ignoreBalance;
    public boolean dayToEndMonth;
    public BigDecimal ignoreBalanceSumma = BigDecimal.ZERO;
    public Set<Integer> contractStatusSet = new HashSet<Integer>();
    public Set<Integer> deviceStateSet = new HashSet<Integer>();

    public TvServiceCost newCost() {
        TvServiceCost result = new TvServiceCost();
        result.productId = this.productId;
        result.activationModeId = this.activationModeId;
        result.activationTime = this.activationTime;
        result.productSpecRuntime = this.productSpecRuntime;
        result.productItem = this.productItem;
        result.serviceId = this.serviceId;
        result.serviceStart = this.serviceStart;
        result.serviceEnd = this.serviceEnd;
        result.amount = this.amount;
        result.prolongationTime = this.prolongationTime;
        result.periodTimeFrom = this.periodTimeFrom;
        result.periodTimeTo = this.periodTimeTo;
        result.cost = this.cost;
        if (this.activationPriceExternal) {
            result.activationPrice = this.activationPrice;
            result.activationPriceExternal = true;
        } else {
            result.activationPrice = this.activationPrice;
        }
        return result;
    }

    protected String paramsToString() {
        StringBuilder result = new StringBuilder();
        result.append("pp: ");
        result.append(this.productId);
        result.append(":");
        result.append(this.productItem != null ? this.productItem.productPeriodId : 0);
        result.append("; sid: ");
        result.append(this.serviceId);
        result.append("; periodFrom: ");
        result.append(TimeUtils.formatFullDate((Date)this.periodTimeFrom));
        result.append("; periodTo: ");
        result.append(TimeUtils.formatFullDate((Date)this.periodTimeTo));
        result.append("; serviceStart: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceStart));
        result.append("; serviceEnd: ");
        result.append(TimeUtils.formatDate((Calendar)this.serviceEnd));
        result.append("; accPeriodDays: ");
        result.append(this.accountingPeriodDays);
        result.append("; amount: ");
        result.append(this.amount);
        result.append("; cost: ");
        result.append(this.cost);
        if (this.ignoreBalanceSumma != BigDecimal.ZERO) {
            result.append("; ignoreBalanceSumma: ");
            result.append(this.ignoreBalanceSumma);
        }
        if (!this.contractStatusSet.isEmpty()) {
            result.append("; contractStatusSet: ");
            result.append(Utils.toString(this.contractStatusSet));
        }
        if (!this.deviceStateSet.isEmpty()) {
            result.append("; deviceStateSet: ");
            result.append(Utils.toString(this.deviceStateSet));
        }
        return result.toString();
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int id) {
        this.productId = id;
    }

    public int getActivationModeId() {
        return this.activationModeId;
    }

    public void setActivationModeId(int activationModeId) {
        this.activationModeId = activationModeId;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public void setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
    }

    public ProductSpecRuntime getProductSpecRuntime() {
        return this.productSpecRuntime;
    }

    public void setProductSpecRuntime(ProductSpecRuntime productSpecRuntime) {
        this.productSpecRuntime = productSpecRuntime;
    }

    public ProductManager.Entry getProductItem() {
        return this.productItem;
    }

    public void setProductItem(ProductManager.Entry productItem) {
        this.productItem = productItem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TvServiceCost tvServiceCost = new TvServiceCost();

        private Builder() {
        }

        public Builder setServiceId(int serviceId) {
            this.tvServiceCost.serviceId = serviceId;
            return this;
        }

        public Builder setServiceStart(Calendar serviceStart) {
            this.tvServiceCost.serviceStart = serviceStart;
            return this;
        }

        public Builder setServiceStart(LocalDate serviceStart) {
            this.tvServiceCost.serviceStart = TimeUtils.convertLocalDateToCalendar((LocalDate)serviceStart);
            return this;
        }

        public Builder setServiceEnd(Calendar serviceEnd) {
            this.tvServiceCost.serviceEnd = serviceEnd;
            return this;
        }

        public Builder setServiceEnd(LocalDate serviceEnd) {
            this.tvServiceCost.serviceEnd = TimeUtils.convertLocalDateToCalendar((LocalDate)serviceEnd);
            return this;
        }

        public Builder setAmount(long amount) {
            this.tvServiceCost.amount = amount;
            return this;
        }

        public Builder setProductId(int id) {
            this.tvServiceCost.productId = id;
            return this;
        }

        public Builder setActivationModeId(int activationModeId) {
            this.tvServiceCost.activationModeId = activationModeId;
            return this;
        }

        public Builder setActivationTime(Date activationTime) {
            this.tvServiceCost.activationTime = activationTime;
            return this;
        }

        public Builder setProductSpecRuntime(ProductSpecRuntime productSpecRuntime) {
            this.tvServiceCost.productSpecRuntime = productSpecRuntime;
            return this;
        }

        public Builder setProductItem(ProductManager.Entry productItem) {
            this.tvServiceCost.productItem = productItem;
            return this;
        }

        public TvServiceCost build() {
            return this.tvServiceCost;
        }
    }
}

