/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapEditorForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class VoiceCostMapItemEditorForm
extends BGUPanel {
    private BGComboBox<VoiceGeographicCode> codeCombobox;
    private BGTextField itemCostTextField;
    private BGControlPanelPeriodNoB itemPeriod;
    private BGButtonPanel buttonPanel;
    private VoiceCostMapItem currentItem;
    private VoiceCostMapEditorForm parentPanel;
    private static final VoiceGeographicCode NOT_SELECTED_ITEM = new VoiceGeographicCode(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
    private BGTableModel<VoiceCostMapItem> codeHistoryTableModel;
    private BGUTable codeHistoryTable;

    public VoiceCostMapItemEditorForm(ClientContext context, VoiceCostMapEditorForm parent) {
        super((LayoutManager)new GridBagLayout(), context);
        this.parentPanel = parent;
    }

    protected void jbInit() throws Exception {
        this.setBorder(BorderFactory.createTitledBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.codeCombobox = new BGComboBox();
        this.codeCombobox.setEnabled(false);
        this.itemPeriod = new BGControlPanelPeriodNoB();
        this.itemCostTextField = new BGTextField(10);
        this.buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.RESET, BGButtonPanel.GLUE, BGButtonPanel.OK, BGButtonPanel.CANCEL});
        this.buttonPanel.addActionListener(e -> this.performAction(e.getActionCommand()));
        this.codeHistoryTableModel = new BGTableModel<VoiceCostMapItem>("costMapItems"){

            protected void initColumns() {
                this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, -1, 100, -1, "code", false);
                this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, 200, -1, "destinationTitle");
                this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u0441", -1, 130, 160, "dateFrom", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
                this.addColumn("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u043e", -1, 130, 160, "dateTo", false, (TableCellRenderer)DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
                this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c", -1, 160, 160, "itemCost", false, (TableCellRenderer)new DecimalTableCellRenderer(new DecimalFormat("###,###,###,##0.00000")));
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 200, -1, "comment");
            }
        };
        this.codeHistoryTable = new BGUTable(this.codeHistoryTableModel);
        JPanel codeHistoryPanel = new JPanel(new GridBagLayout());
        codeHistoryPanel.setBorder(BorderFactory.createTitledBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u043a\u043e\u0434\u0430"));
        codeHistoryPanel.add((Component)new JScrollPane((Component)this.codeHistoryTable), new GridBagConstraints(0, 0, 1, 2, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        Dimension d = new Dimension(codeHistoryPanel.getMinimumSize().width, 200);
        codeHistoryPanel.setPreferredSize(d);
        codeHistoryPanel.setMinimumSize(d);
        JPanel codeParamPanel = new JPanel(new GridBagLayout());
        codeParamPanel.add((Component)new JLabel("\u041a\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        codeParamPanel.add((Component)this.codeCombobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        codeParamPanel.add((Component)new JLabel("\u0426\u0435\u043d\u0430"), new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        codeParamPanel.add((Component)this.itemCostTextField, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        codeParamPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f "), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        codeParamPanel.add((Component)this.itemPeriod, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        this.add(codeParamPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 3, 3), 0, 0));
        this.add(codeHistoryPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 11, 7, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
    }

    protected void loadGeocodes() throws BGException {
        VoiceService geocodeService = (VoiceService)((ClientContext)this.getContext()).getPort(VoiceService.class);
        String data = geocodeService.getGeographicCodeTree(this.parentPanel.getOperatorId());
        VoiceGeographicCode root = (VoiceGeographicCode)VoiceCommonUtils.readFromHolder((byte[])Base64.getDecoder().decode(data));
        List codeList = root.toList();
        codeList.stream().forEach(n -> {
            n.setTitle(n.getCode() + " - " + n.getDestinationTitle());
            n.setCode(null);
            n.setDestinationTitle(null);
        });
        codeList.add(0, NOT_SELECTED_ITEM);
        this.codeCombobox.setModel((ComboBoxModel)new DefaultComboBoxModel<VoiceGeographicCode>(codeList.toArray(new VoiceGeographicCode[0])){});
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.loadGeocodes();
            this.codeCombobox.setEnabled(true);
            this.codeCombobox.setSelectedIndex(0);
            this.itemCostTextField.setText("");
            this.itemPeriod.setPeriod(null);
            this.parentPanel.getButtonPanel().setEnabled(false);
            this.codeHistoryTableModel.setData(null);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            this.loadGeocodes();
            this.codeCombobox.setEnabled(false);
            this.codeCombobox.setSelectedItem((Object)new VoiceGeographicCode(this.currentItem.getCodeId(), null));
            this.itemCostTextField.setText(this.currentItem.getItemCost().toString());
            this.itemPeriod.setPeriod(new Period(this.currentItem.getDateFrom(), this.currentItem.getDateTo()));
            this.parentPanel.getButtonPanel().setEnabled(false);
            VoiceCostMapService costMapService = (VoiceCostMapService)((ClientContext)this.getContext()).getPort(VoiceCostMapService.class);
            this.codeHistoryTableModel.setData(costMapService.costMapItemHistory(this.currentItem.getCodeId(), this.currentItem.getCostMapId()));
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItemEditorForm.this.currentItem.setItemCost(Utils.parseBigDecimal((String)VoiceCostMapItemEditorForm.this.itemCostTextField.getText(), (BigDecimal)BigDecimal.ZERO));
                if (VoiceCostMapItemEditorForm.this.currentItem.getId() <= 0) {
                    VoiceGeographicCode selectedGeocode = (VoiceGeographicCode)VoiceCostMapItemEditorForm.this.codeCombobox.getSelectedItem();
                    if (selectedGeocode == null || selectedGeocode.equals((Object)NOT_SELECTED_ITEM)) {
                        BGToolTip.showErrorMessage(VoiceCostMapItemEditorForm.this.codeCombobox, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0438\u0437 \u0432\u044b\u043f\u0430\u0434\u0430\u044e\u0449\u0435\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0430!");
                        return;
                    }
                    VoiceCostMapItemEditorForm.this.currentItem.setCodeId(selectedGeocode.getId());
                }
                Date dateFrom = VoiceCostMapItemEditorForm.this.itemPeriod.getDateFrom();
                Date dateTo = VoiceCostMapItemEditorForm.this.itemPeriod.getDateTo();
                if (dateFrom != null && dateTo != null && dateFrom.compareTo(dateTo) > 0) {
                    BGToolTip.showErrorMessage((JComponent)VoiceCostMapItemEditorForm.this.itemPeriod, (String)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f!");
                    return;
                }
                VoiceCostMapItemEditorForm.this.currentItem.setDateFrom(dateFrom);
                VoiceCostMapItemEditorForm.this.currentItem.setDateTo(dateTo);
                ((VoiceCostMapService)((ClientContext)VoiceCostMapItemEditorForm.this.getContext()).getPort(VoiceCostMapService.class)).voiceCostMapItemUpdate(VoiceCostMapItemEditorForm.this.currentItem);
                VoiceCostMapItemEditorForm.this.hideEditor();
                VoiceCostMapItemEditorForm.this.parentPanel.performAction("refresh");
            }
        };
        new AbstractBGUPanel.DefaultAction("reset", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItemEditorForm.this.performAction("edit");
            }
        };
        new AbstractBGUPanel.DefaultAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceCostMapItemEditorForm.this.hideEditor();
            }
        };
    }

    private void hideEditor() {
        this.parentPanel.setVisibleBottomPanels(false, false);
        this.parentPanel.getButtonPanel().setEnabled(true);
    }

    public void setCurrentItem(VoiceCostMapItem currentItem) {
        this.currentItem = currentItem;
    }
}

