/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.radius;

import bitel.billing.server.processor.voiceip.VoiceIpSessionRealtime;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnectionInspector;
import ru.bitel.bgbilling.modules.voiceip.server.bean.FindMode;
import ru.bitel.bgbilling.modules.voiceip.server.bean.FindModeManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginType;
import ru.bitel.bgbilling.modules.voiceip.server.bean.LoginTypeManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpSession;
import ru.bitel.bgbilling.modules.voiceip.server.radius.FindLoginProcessor;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpNasConnection;
import ru.bitel.bgbilling.modules.voiceip.server.radius.VoiceIpRadiusProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class VoiceIpNas
extends Nas<VoiceIpNasConnection, Setup, VoiceIpRadiusProcessor> {
    private static final Logger logger = LogManager.getLogger();
    public static final RadiusPacket.RadiusPacketOption<Integer> CALL_TYPE = new RadiusPacket.RadiusPacketOption("call.type");
    public static final RadiusPacket.RadiusPacketOption<Integer> FIND_MODE = new RadiusPacket.RadiusPacketOption("find.mode");
    public static final RadiusPacket.RadiusPacketOption<Integer> SERVICE = new RadiusPacket.RadiusPacketOption("service");
    public static final RadiusPacket.RadiusPacketOption<Integer> OPERATOR = new RadiusPacket.RadiusPacketOption("operator");
    public static final int OUTGOING_CALL = 1;
    public static final int INCOMING_CALL = 2;
    private final int sid;
    private final FindLoginProcessor findProcessor;
    private final boolean logErrorAcct;
    private final boolean authIncomeFull;
    private final List<String> realms = new ArrayList<String>();
    private RadiusAttributeInfo<?> realmAttr;
    private boolean useAcctSessionId;
    private boolean noCreditAmount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoiceIpNas(Setup setup, int moduleId, VoiceIpRadiusProcessor processor, int id, VoiceIpNas oldNas, InetAddress nasIPAddress, String nasIdentifier, int vendorCode, ParameterMap conf, byte[] secret, ConcurrentMap<Object, VoiceIpNasConnection> connections, String script, NasConnectionInspector inspector) {
        super((Preferences)setup, moduleId, (RadiusProcessor)processor, id, (Nas)oldNas, nasIPAddress, nasIdentifier, vendorCode, conf, secret, connections, script, inspector);
        this.sid = conf.getInt("service", -1);
        this.logErrorAcct = conf.getInt("acct.logError", -1) == 1;
        this.authIncomeFull = conf.getInt("auth.income.full", -1) == 1;
        int mid = moduleId;
        List<LoginType> typeList = null;
        Connection con = setup.getDBConnectionFromPool();
        try {
            LoginTypeManager ltm = new LoginTypeManager(con, mid);
            typeList = ltm.getTypeList();
            LoginType defaultType = new LoginType();
            this.fillDefaultLoginType(defaultType);
            typeList.add(defaultType);
            String logSessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)new Date(), (int)mid);
            if (ServerUtils.tableExists((Connection)con, (String)logSessionTableName)) {
                VoiceIpSession.addColumns(con, logSessionTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        Map<Integer, FindMode> modeMap = new FindModeManager(conf).getModeMap();
        List findOrder = Utils.toIntegerList((String)conf.get("find.order", ""));
        if (logger.isDebugEnabled()) {
            logger.debug("moduleId={}", (Object)moduleId);
            logger.debug("findOrder={}", (Object)Utils.toString((Iterable)findOrder));
        }
        this.findProcessor = new FindLoginProcessor(setup, moduleId, typeList, modeMap, findOrder);
        logger.info("Find modes: " + this.findProcessor.toString());
        String attrRealm = conf.get("realm.attr", null);
        if (!Utils.isEmptyString((String)attrRealm)) {
            try {
                String realmValue;
                this.realmAttr = RadiusDictionary.findAttributeInfo((String)attrRealm);
                if (this.realmAttr != null && (realmValue = conf.get("realm.value", null)) != null) {
                    for (String realm : realmValue.split(",")) {
                        this.realms.add(realm);
                    }
                    logger.debug("realms = " + realmValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.useAcctSessionId = conf.getBoolean("sip", false);
        this.noCreditAmount = conf.getBoolean("no.credit.amount", false);
    }

    public FindLoginProcessor getFindProcessor() {
        return this.findProcessor;
    }

    public int getService(int typeService, String realm, String param) {
        return this.sid;
    }

    public boolean needLogError() {
        return this.logErrorAcct;
    }

    protected String getPacketKey(String h323_id, String login) {
        if (h323_id != null && login != null) {
            return h323_id + "_" + login;
        }
        return null;
    }

    public VoiceIpNasConnection setConnection(VoiceIpNasConnection nasCon, RadiusPacket request, Connection con, Connection conSlave) {
        if (nasCon != null && request != null) {
            String key;
            String _H323_conf_id = this.getConfigId(request);
            String loginName = request.getStringAttribute(-1, 1, null);
            if (loginName == null) {
                loginName = request.getStringAttribute(-1, 31, null);
            }
            if ((key = this.getPacketKey(_H323_conf_id, loginName)) != null) {
                nasCon.setKey(key);
                VoiceIpSessionRealtime session = (VoiceIpSessionRealtime)nasCon.getSession();
                session.setNasId(this.getId());
                session.setH323ID(_H323_conf_id);
                this.connections.put(key, nasCon);
                return nasCon;
            }
        }
        return null;
    }

    public String getConfigId(RadiusPacket request) {
        if (this.useAcctSessionId) {
            return request.getStringAttribute(-1, 44, null);
        }
        return request.getStringAttribute(this.getVendorCode(), 24, null);
    }

    public int getCreditTimeAttrType() {
        if (this.useAcctSessionId) {
            return 46;
        }
        return 102;
    }

    public void fillDefaultLoginType(LoginType loginType) {
        loginType.setIgnoreAccount(((Setup)this.setup).getBoolean("default.login.ignore.stop", true));
    }

    public void removeRealm(RadiusPacket request) {
        String realm;
        int pos;
        if (this.realmAttr == null || this.realms.isEmpty()) {
            return;
        }
        String callingId = request.getStringAttribute(this.realmAttr.vendor, this.realmAttr.type, null);
        if (Utils.isEmptyString((String)callingId) && (pos = callingId.lastIndexOf("@")) != -1 && this.realms.contains(realm = callingId.substring(pos + 1, callingId.length()))) {
            callingId = callingId.substring(0, pos);
            request.setStringAttribute(this.realmAttr.vendor, this.realmAttr.type, callingId);
        }
    }

    public boolean isNoCreditAmount() {
        return this.noCreditAmount;
    }

    public boolean isAuthIncomeFull() {
        return this.authIncomeFull;
    }
}

