/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionCheckResultDTO;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistShopMode;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestGetOperations;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOperation;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOrder;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransfer;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransferException;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public static String DEFAULT_PAYMENT_COMMENT = "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. ${contract} \u0447\u0435\u0440\u0435\u0437 Assist (\u041f\u043b\u0430\u0442\u0451\u0436 #${billnumber}) \u043e\u0442 ${date}";

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "assist_payment");
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("status", "status");
        this.fields.put("createDatetime", "DATE");
        this.fields.put("transactionDatetime", "DATE");
        this.fields.put("sum", "TOTAL");
    }

    public Transaction addPayment(int contractId, BigDecimal sum, int recurringParentId) throws BGException {
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(contractId)).setCreateDate(new Date())).setSum(sum)).setStatus(TransactionStatus.NEW.getCode())).build();
        String query = "INSERT INTO " + this.tableName + " SET cid=?, DATE=?, TOTAL=?, status=?, recurringParentId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, transaction.getContractId());
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setBigDecimal(3, transaction.getSum());
            ps.setString(4, transaction.getStatus());
            ps.setInt(5, recurringParentId);
            ps.executeUpdate();
            transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return transaction;
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            ResultSet rs;
            PreparedStatement ps;
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM " + this.tableName + " AS assist LEFT JOIN contract ON contract.id=assist.cid WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND assist.DATE>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND assist.DATE<?");
                }
            }
            this.queryStatus(query, status);
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND contract.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND contract.id=").append(contractId);
            }
            String selectQuery = "SELECT assist.*, contract.title, contract.comment AS con_comment" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : "");
            try {
                ps = this.con.prepareStatement(selectQuery);
                try {
                    int i = 1;
                    if (period != null) {
                        if (period.getDateFrom() != null) {
                            ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                        }
                        if (period.getDateTo() != null) {
                            ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                        }
                    }
                    i = this.psStatus(ps, status, i);
                    if (Utils.notBlankString((String)contractTitle)) {
                        ps.setString(i++, "%" + contractTitle + "%");
                    }
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            Transaction transaction = this.getFromRS(rs);
                            this.setContractData(transaction, rs);
                            list.add(transaction);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            try {
                ps = this.con.prepareStatement("SELECT SUM(assist.TOTAL), COUNT(*) " + query.toString());
                try {
                    int index = 1;
                    if (period != null) {
                        if (period.getDateFrom() != null) {
                            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                        }
                        if (period.getDateTo() != null) {
                            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
                        }
                    }
                    index = this.psStatus(ps, status, index);
                    if (Utils.notBlankString((String)contractTitle)) {
                        ps.setString(index++, "%" + contractTitle + "%");
                    }
                    rs = ps.executeQuery();
                    try {
                        while (rs.next()) {
                            BigDecimal sum;
                            if (page != null) {
                                page.setRecordCount(rs.getInt(2));
                            }
                            if ((sum = rs.getBigDecimal(1)) == null) continue;
                            searchResult.setSum(sum);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status)) {
            query.append(" AND assist.status=?");
        }
    }

    public List<Transaction> getPaymentList(int contractId, Date from, Date until, List<String> statusList) throws BGException {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        try {
            StringBuffer query = new StringBuffer("SELECT * FROM " + this.tableName + " WHERE cid=?");
            query.append((String)(statusList != null && !statusList.isEmpty() ? " AND ( false " + " OR status=?".repeat(statusList.size()) + " )" : ""));
            if (from != null) {
                query.append(" AND (TO_DAYS(DATE)>=TO_DAYS(?))");
            }
            if (until != null) {
                query.append(" AND (TO_DAYS(DATE)<=TO_DAYS(?))");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int i = 1;
            ps.setInt(i++, contractId);
            if (statusList != null && statusList.size() > 0) {
                for (String status : statusList) {
                    ps.setString(i++, status);
                }
            }
            if (from != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)from));
            }
            if (until != null) {
                ps.setTimestamp(i++, TimeUtils.convertDateToTimestamp((Date)until));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public Transaction registerOrder(int contractId, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId) throws BGException {
        Transaction transaction = this.addPayment(contractId, sum, 0);
        dataMap.put("Merchant_ID", this.moduleSetup.get("assist.Merchant_ID"));
        dataMap.put("OrderNumber", String.valueOf(transaction.getId()));
        dataMap.put("OrderAmount", sum.toPlainString());
        dataMap.put("OrderCurrency", this.moduleSetup.get("assist.OrderCurrency", "RUB"));
        dataMap.put("OrderComment", AssistUtils.getPaymentDesc(this.con, this.moduleSetup.get("assist.OrderComment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. ${contract} (${contract_comment})"), contractId));
        dataMap.put("URL_RETURN_OK", this.moduleSetup.get("assist.url.return.ok"));
        dataMap.put("URL_RETURN_NO", this.moduleSetup.get("assist.url.return.no"));
        dataMap.put("formFields", new String[]{"Merchant_ID", "OrderNumber", "OrderAmount", "OrderCurrency", "OrderComment", "URL_RETURN_OK", "URL_RETURN_NO", "Delay", "CardPayment", "FastPayPayment", "WMPayment", "YMPayment", "AssistIDPayment", "QIWIPayment", "QIWIMtsPayment", "QIWIMegafonPayment", "QIWIBeelinePayment", "Checkvalue", "Signature"});
        this.addParam(dataMap, "Delay", "assist.Delay", "0");
        this.addParam(dataMap, "CardPayment", "assist.CardPayment", "1");
        this.addParam(dataMap, "FastPayPayment", "assist.FastPayPayment", "1");
        this.addParam(dataMap, "WMPayment", "assist.WMPayment");
        this.addParam(dataMap, "YMPayment", "assist.YMPayment");
        this.addParam(dataMap, "AssistIDPayment", "assist.AssistIDPayment");
        this.addParam(dataMap, "QIWIPayment", "assist.QIWIPayment");
        this.addParam(dataMap, "QIWIMtsPayment", "assist.QIWIMtsPayment");
        this.addParam(dataMap, "QIWIMegafonPayment", "assist.QIWIMegafonPayment");
        this.addParam(dataMap, "QIWIBeelinePayment", "assist.QIWIBeelinePayment");
        this.addSignature(dataMap);
        AssistShopMode shopMode = AssistShopMode.test;
        try {
            shopMode = AssistShopMode.valueOf(this.moduleSetup.get("assist.ShopMode", "test"));
        }
        catch (Exception ex) {
            this.getLogger().error("error parameter assist.ShopMode [{}]", (Object)ex.getMessage());
        }
        if (shopMode == AssistShopMode.battletest || shopMode == AssistShopMode.test) {
            dataMap.put("TestMode", "1");
        }
        return transaction;
    }

    private void addSignature(Map<String, Object> dataMap) {
        String privkey = this.moduleSetup.get("assist.PrivateKey");
        if (privkey != null) {
            String str = dataMap.get("Merchant_ID") + ";" + dataMap.get("OrderNumber") + ";" + dataMap.get("OrderAmount") + ";" + dataMap.get("OrderCurrency");
            try {
                PKCS8EncodedKeySpec privkeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privkey.getBytes()));
                PrivateKey privateKey = KeyFactory.getInstance("RSA").generatePrivate(privkeySpec);
                Signature signature = Signature.getInstance("MD5withRSA");
                signature.initSign(privateKey);
                signature.update(str.getBytes(StandardCharsets.UTF_8));
                dataMap.put("Signature", Base64.getEncoder().encodeToString(signature.sign()));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public List<TransactionCheckResultDTO> doCheckRequest(int contractId, boolean autopaymentTransaction) throws Exception {
        ArrayList<TransactionCheckResultDTO> checkResultDTOs = new ArrayList<TransactionCheckResultDTO>();
        for (Transaction transaction : this.list((String)(contractId > 0 ? "cid=" + contractId + " AND " : "") + "recurringParentId" + (autopaymentTransaction ? ">0" : "=0"), "DATE DESC", new Object[0])) {
            checkResultDTOs.add(this.doCheckRequest(transaction, contractId, transaction.getId()));
        }
        return checkResultDTOs;
    }

    public TransactionCheckResultDTO doCheckRequest(Transaction transaction, int contractId, int orderId) throws Exception {
        TransactionCheckResultDTO resultDTO = new TransactionCheckResultDTO();
        AssistProtocolTransferException exc = null;
        String merchantID = this.moduleSetup.get("assist.Merchant_ID", null);
        String login = this.moduleSetup.get("assist.login", null);
        String password = this.moduleSetup.get("assist.password", null);
        AssistProtocolTransfer atransfer = new AssistProtocolTransfer(merchantID, login, password);
        AssistPaymentRecurringManager prmanager = new AssistPaymentRecurringManager(this.con, this.moduleId);
        if (transaction == null) {
            this.getLogger().error("Assist: \u0412 \u0411\u0414 \u043d\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435 \u043d\u0430 \u043c\u043e\u043c\u0435\u043d\u0442 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ordernumber=" + orderId + ", contractId=" + contractId);
            resultDTO.addMessage("\u041e\u0448\u0438\u0431\u043a\u0430! \u0422\u0430\u043a\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0451\u0436\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043d\u0435\u0442!");
            resultDTO.setResult(TransactionStatus.FAIL);
        } else {
            AssistProtocolRequestGetOperations paymentRequest = null;
            try {
                paymentRequest = atransfer.getRequest(orderId, transaction.getCreateDate());
                if (paymentRequest.getOperations().size() > 1) {
                    throw new AssistProtocolTransferException("\u041d\u0435 \u0437\u043d\u0430\u044e \u0447\u0442\u043e \u0434\u0435\u043b\u0430\u0442\u044c, \u0435\u0441\u043b\u0438 \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u0434\u043d\u043e\u0439 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c");
                }
            }
            catch (AssistProtocolTransferException e) {
                exc = e;
            }
            if (paymentRequest == null) {
                this.getLogger().warn("Assist: \u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430: ordernumber=" + orderId + ", contractId=" + contractId);
                resultDTO.addMessage("\u041e\u0448\u0438\u0431\u043a\u0430! \u0417\u0430\u043f\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c.");
                resultDTO.setResult(TransactionStatus.FAIL);
            } else {
                AssistProtocolRequestOrder order = paymentRequest.getOrder();
                AssistProtocolRequestOperation operation = null;
                if (paymentRequest.getOperations().size() > 0) {
                    operation = paymentRequest.getOperations().get(0);
                }
                if (order != null && order.getOrderstate().isSuccessful()) {
                    boolean needPayment;
                    boolean bl = needPayment = transaction.getStatus().equals(TransactionStatus.FAIL.getCode()) || transaction.getStatus().equals(TransactionStatus.NEW.getCode());
                    if (transaction.getStatus().equals(TransactionStatus.FAIL.getCode())) {
                        resultDTO.addMessage("Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u043c: '" + transaction.getStatus() + "/" + (transaction.getResponseCode() != null ? transaction.getResponseCode().toString() : "?") + "', \u043d\u043e \u0431\u044b\u043b \u0441\u0434\u0435\u043b\u0430\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0441 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c \u0437\u0430\u043a\u0430\u0437\u0430 '" + order.getOrderstate() + "'");
                        this.getLogger().warn(resultDTO.getMessage());
                        resultDTO.addMessage("\n\u0421\u0442\u0430\u0442\u0443\u0441 \u0432 \u0411\u0414 \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0451\u043d!\n\n");
                    }
                    AssistUtils.fillPayment(transaction, order, operation);
                    transaction.setStatus(TransactionStatus.OK.getCode());
                    this.update(transaction);
                    if (needPayment) {
                        this.carryOutPayment(transaction);
                    }
                    resultDTO.addMessage("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e!\n\u041f\u043b\u0430\u0442\u0451\u0436 \u2116 " + transaction.getBillnumber() + "\n\u041f\u043e\u0441\u0442\u0443\u043f\u0438\u0432\u0448\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + transaction.getSum().toPlainString() + "\n");
                    resultDTO.setResult(TransactionStatus.OK);
                    resultDTO.addMessage(needPayment ? "\u0412 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0451\u0436!\n" : "\u041f\u043b\u0430\u0442\u0451\u0436 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u041d\u0415 \u0431\u044b\u043b (\u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d)!\n");
                    if (prmanager.updateBillnumber(orderId, transaction.getContractId(), transaction.getBillnumber())) {
                        resultDTO.addMessage("\u0411\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0451\u0436!\n");
                    }
                } else if (order != null && order.getOrderstate().isUnsuccessful()) {
                    if (transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
                        resultDTO.addMessage("Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439: '" + transaction.getStatus() + "', \u043d\u043e \u0431\u044b\u043b \u0441\u0434\u0435\u043b\u0430\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0441 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u043c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c \u0437\u0430\u043a\u0430\u0437\u0430 '" + order.getOrderstate() + "'");
                        this.getLogger().error(resultDTO.getMessage());
                        resultDTO.addMessage("\n\u0421\u0442\u0430\u0442\u0443\u0441 \u0432 \u0411\u0414 \u041d\u0415 \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0451\u043d!");
                        resultDTO.setResult(TransactionStatus.OK);
                    } else {
                        AssistUtils.fillPayment(transaction, order, operation);
                        transaction.setStatus(TransactionStatus.FAIL.getCode());
                        this.update(transaction);
                        resultDTO.addMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041f\u043b\u0430\u0442\u0451\u0436 \u0431\u044b\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e!\n\u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (responsecode): " + (Serializable)(operation != null ? operation.getResponsecode() : "?") + "\n\u0422\u043e\u043b\u043a\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0434\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (recommendation): " + (operation != null ? operation.getRecommendation() : "?") + "\n\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0430\u0437\u0430 (billnumber): " + order.getBillnumber() + "\n\u0421\u0442\u0430\u0442\u0443\u0441 \u0437\u0430\u043a\u0430\u0437\u0430 (orderstate): " + order.getOrderstate() + "\n");
                        resultDTO.setResult(TransactionStatus.FAIL);
                    }
                } else if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                    resultDTO.addMessage("Assist: \u041e\u0448\u0438\u0431\u043a\u0430! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0436\u0435 \u0431\u044b\u043b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u043c: '" + transaction.getStatus() + "', \u043d\u043e \u0431\u044b\u043b \u0441\u0434\u0435\u043b\u0430\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0441 \u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u043c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c \u0437\u0430\u043a\u0430\u0437\u0430 '" + (Serializable)(order != null ? order.getOrderstate() : "?") + "'");
                    this.getLogger().warn(resultDTO.getMessage());
                    resultDTO.setResult((TransactionStatus)TransactionStatus.ALL.getStatusByCode(transaction.getStatus()));
                } else {
                    AssistUtils.fillPayment(transaction, order, operation);
                    this.update(transaction);
                    resultDTO.addMessage("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435!");
                    resultDTO.setResult(TransactionStatus.NEW);
                }
            }
        }
        if (exc != null) {
            resultDTO.setSssistProtocolTransferExceptionMessage(exc.getMessage());
        }
        return resultDTO;
    }

    private void addParam(Map<String, Object> dataMap, String paramName, String key) {
        this.addParam(dataMap, paramName, key, null);
    }

    private void addParam(Map<String, Object> dataMap, String paramName, String key, String defaultValue) {
        String paramValue = this.moduleSetup.get(key, defaultValue);
        if (paramValue != null) {
            dataMap.put(paramName, paramValue);
        }
    }

    protected Transaction getImpl(int id) throws BGException, SQLException {
        Transaction transaction = null;
        String query = "SELECT assist.*, contract.title, contract.comment AS con_comment FROM " + this.tableName + " as assist LEFT JOIN contract ON contract.id=assist.cid WHERE assist.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    transaction = this.getFromRS(rs);
                    this.setContractData(transaction, rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return transaction;
    }

    public void carryOutPayment(Transaction transaction) throws BGException {
        int paymentType = this.moduleSetup.getInt("assist.paymenttype", 0);
        String commentTemplate = this.moduleSetup.get("assist.payment_comment", DEFAULT_PAYMENT_COMMENT);
        if (transaction != null && transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
            String comment = AssistUtils.getPaymentComment(this.con, commentTemplate, transaction);
            Payment payment = Payment.builder().setDate(transaction.getCreateDate()).setTypeId(paymentType).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(comment).build();
            try (PaymentDao paymentDao = new PaymentDao(this.con);){
                paymentDao.update((Object)payment);
            }
            ServerUtils.commitConnection((Connection)this.con);
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                Contract contract = (Contract)contractDao.get(transaction.getContractId());
                try (BalanceUtils bu = new BalanceUtils(this.con);){
                    bu.updateBalance(transaction.getCreateDate(), contract);
                }
                ServerUtils.commitConnection((Connection)this.con);
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contract.getId(), 3, payment.getSum()));
            }
        }
    }

    public int getFirstYear(int contractId) throws BGException {
        int n;
        block8: {
            Statement st = this.con.createStatement();
            try {
                ResultSet rs = st.executeQuery("SELECT MIN(DATE) FROM assist_payment_" + this.moduleId + " WHERE cid=" + contractId);
                int result = (rs.next() && rs.getDate(1) != null ? TimeUtils.convertDateToCalendar((Date)rs.getDate(1)) : new GregorianCalendar()).get(1);
                rs.close();
                n = result;
                if (st == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            st.close();
        }
        return n;
    }

    public Transaction getLastRecurringForCid(int contractId, int recurringParentId) throws BGException {
        Transaction result = null;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(" SELECT * FROM " + this.tableName + " WHERE cid=" + contractId + " AND recurringParentId=" + recurringParentId + " AND (status=1 OR status=2) ORDER BY date DESC LIMIT 1");
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    protected void setContractData(Transaction transaction, ResultSet rs) throws SQLException, BGException {
        transaction.setContractTitle(rs.getString("title"));
        transaction.setContractComment(rs.getString("con_comment"));
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("cid"))).setStatus(rs.getString("status"))).setSum(rs.getBigDecimal("TOTAL"))).setCreateDate((Date)rs.getTimestamp("DATE"))).setCardholderName(rs.getString("CARDHOLDER")).setComment(rs.getString("COMMENT")).setEmail(rs.getString("EMAIL")).setName(rs.getString("NAME")).setIpaddress(rs.getString("IPADDRESS")).setPan(rs.getString("CARDNUMBER")).setCardtype(rs.getString("CARDTYPE")).setCardsubtype(rs.getString("CARDSUBTYPE")).setBillnumber(Long.valueOf(rs.getLong("BILLNUMBER"))).setResponseCode(rs.getString("RESPONSE_CODE")).setRecurringParentId(rs.getInt("recurringParentId")).build();
    }

    protected void updateImpl(Transaction transaction) throws BGException, SQLException {
        String query = "UPDATE " + this.tableName + " SET cid=?, status=?, CARDHOLDER=?, COMMENT=?, EMAIL=?, NAME=?, IPADDRESS=?, CARDNUMBER=?, CARDTYPE=?, DATE=?, CARDSUBTYPE=?, TOTAL=?, BILLNUMBER=?, RESPONSE_CODE=?, recurringParentId=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getCardholderName());
            ps.setString(index++, transaction.getComment());
            ps.setString(index++, transaction.getEmail());
            ps.setString(index++, transaction.getName());
            ps.setString(index++, transaction.getIpaddress());
            ps.setString(index++, transaction.getPan());
            ps.setString(index++, transaction.getCardtype());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setString(index++, transaction.getCardsubtype());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setLong(index++, transaction.getBillnumber());
            ps.setString(index++, transaction.getResponseCode() != null ? transaction.getResponseCode() : null);
            ps.setInt(index++, transaction.getRecurringParentId());
            ps.setInt(index++, transaction.getId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

