/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolOperationType;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolOrderState;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestGetOperations;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOperation;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestOrder;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestPaymentResult;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolResponseCode;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransferException;
import ru.bitel.bgbilling.modules.assist.server.protocol.EnumGetFromString;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AssistProtocolTransfer {
    private static final Logger logger = LogManager.getLogger();
    public static final String DATE_FIELD_FORMAT = "dd.MM.yyyy HH:mm:ss";
    public static final String DATE_FIELD_FORMAT_2 = "dd.MM.yyyy HH:mm";
    public static final String DATE_TIMEZONE = "UTC";
    public static final String ENCODING = "utf-8";
    private String merchant_ID;
    private String login;
    private String password;
    private static final String RESULTS_URL = "https://payments.paysecure.ru/orderresult/orderresult.cfm";
    private static final String RECURRING_URL = "https://payments.paysecure.ru/recurrent/rp.cfm";
    public static final int FIRSTCODE_OK = 0;
    public static final int FIRSTCODE_ERROR = 1;
    public static final int FIRSTCODE_PARAMFORMAT_ERROR = 4;
    public static final int FIRSTCODE_PARAMVALUE_ERROR = 5;
    public static final int FIRSTCODE_ENCRYPT_ERROR = 9;
    public static final int SECONDCODE_NONE = 0;
    public static final int SECONDCODE_ORDERNUMBER = 107;

    public AssistProtocolTransfer(String merchant_ID, String login, String password) {
        this.merchant_ID = merchant_ID;
        this.login = login;
        this.password = password;
    }

    public static AssistProtocolRequestPaymentResult parseRequestSoapServlet(InputStream is) throws AssistProtocolTransferException, BGException {
        Element pushPaymentResult;
        Document doc = null;
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(false);
            dFactory.setValidating(false);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            doc = docBuilder.parse(new InputSource(is));
        }
        catch (Exception e) {
            throw new AssistProtocolTransferException("error read/parse input stream xml", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(XMLUtils.serializeToString((Node)doc, (boolean)false));
        }
        if ((pushPaymentResult = XMLUtils.selectElement((Node)doc, (String)"/Envelope/Body/PushPaymentResult")) == null) {
            throw new AssistProtocolTransferException("error get PushPaymentResult-node from xml");
        }
        AssistProtocolRequestPaymentResult result = new AssistProtocolRequestPaymentResult();
        result.setMerchant_id(AssistProtocolTransfer.getIntegerField(pushPaymentResult, "merchant_id"));
        result.setRate(AssistProtocolTransfer.getBigDecimalField(pushPaymentResult, "rate"));
        result.setOrder(AssistProtocolTransfer.parseRequestOrder(pushPaymentResult));
        result.setOperation(AssistProtocolTransfer.parseRequestOperation(pushPaymentResult));
        String billnumber = result.getOrder().getBillnumber();
        int idx = billnumber.indexOf(46);
        if (idx > -1) {
            billnumber = billnumber.substring(0, idx);
        }
        result.getOrder().setBillnumber(billnumber);
        return result;
    }

    private static String getStringField(Node parentnode, String elementname) {
        return XMLUtils.selectText((Node)parentnode, (String)(elementname + "/text()"));
    }

    private static Integer getIntegerField(Node parentnode, String elementname) throws AssistProtocolTransferException {
        String textvalue = AssistProtocolTransfer.getStringField(parentnode, elementname);
        if (textvalue == null) {
            return null;
        }
        try {
            return Integer.valueOf(textvalue);
        }
        catch (Exception ex) {
            throw new AssistProtocolTransferException("error number value " + elementname + "='" + textvalue + "'", ex);
        }
    }

    private static Boolean getBooleanField(Node parentnode, String elementname) throws AssistProtocolTransferException {
        String textvalue = AssistProtocolTransfer.getStringField(parentnode, elementname);
        if (textvalue == null) {
            return null;
        }
        if ("1".equals(textvalue)) {
            return Boolean.TRUE;
        }
        if ("0".equals(textvalue)) {
            return Boolean.FALSE;
        }
        throw new AssistProtocolTransferException("error boolean value " + elementname + "='" + textvalue + "'");
    }

    private static BigDecimal getBigDecimalField(Node parentnode, String elementname) throws AssistProtocolTransferException {
        String textvalue = AssistProtocolTransfer.getStringField(parentnode, elementname);
        if (textvalue == null) {
            return null;
        }
        try {
            return new BigDecimal(textvalue);
        }
        catch (Exception ex) {
            throw new AssistProtocolTransferException("error decimal value " + elementname + "='" + textvalue + "'", ex);
        }
    }

    private static Date getDateField(Node parentnode, String elementname) throws AssistProtocolTransferException {
        String textvalue = AssistProtocolTransfer.getStringField(parentnode, elementname);
        if (textvalue == null) {
            return null;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FIELD_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone(DATE_TIMEZONE));
            return sdf.parse(textvalue);
        }
        catch (Exception ex) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FIELD_FORMAT_2);
                sdf.setTimeZone(TimeZone.getTimeZone(DATE_TIMEZONE));
                return sdf.parse(textvalue);
            }
            catch (Exception ex2) {
                throw new AssistProtocolTransferException("error date value " + elementname + "='" + textvalue + "'", ex);
            }
        }
    }

    private static <E extends Enum<E>> E getEnumField(Class<E> enumm, Node parentnode, String elementname) throws AssistProtocolTransferException {
        String textvalue = AssistProtocolTransfer.getStringField(parentnode, elementname);
        if (textvalue == null) {
            return null;
        }
        for (Enum rs : (Enum[])enumm.getEnumConstants()) {
            if (!((EnumGetFromString)((Object)rs)).isThis(textvalue)) continue;
            return (E)rs;
        }
        throw new AssistProtocolTransferException("error enum value " + elementname + "='" + textvalue + "'");
    }

    public static void doReply(AssistProtocolRequestPaymentResult paymentRequest, PrintWriter out, int firstcode, int secondcode) throws IOException {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<pushpaymentresult firstcode=\"" + firstcode + "\" secondcode=\"" + secondcode + "\">");
        if (paymentRequest != null) {
            out.println("<order>");
            out.println("<billnumber>" + paymentRequest.getOperation().getBillnumber() + "</billnumber>");
            out.println("<packetdate>" + new SimpleDateFormat(DATE_FIELD_FORMAT).format(paymentRequest.getOrder().getPacketdate()) + "</packetdate>");
            out.println("</order>");
        }
        out.println("</pushpaymentresult>");
    }

    private static AssistProtocolRequestOrder parseRequestOrder(Element element) throws AssistProtocolTransferException {
        AssistProtocolRequestOrder request = new AssistProtocolRequestOrder();
        request.setOrdernumber(AssistProtocolTransfer.getIntegerField(element, "ordernumber"));
        request.setBillnumber(AssistProtocolTransfer.getStringField(element, "billnumber"));
        request.setTestmode(AssistProtocolTransfer.getBooleanField(element, "testmode"));
        request.setOrdercomment(AssistProtocolTransfer.getStringField(element, "ordercomment"));
        request.setOrderamount(AssistProtocolTransfer.getBigDecimalField(element, "orderamount"));
        request.setOrdercurrency(AssistProtocolTransfer.getStringField(element, "ordercurrency"));
        request.setFirstname(AssistProtocolTransfer.getStringField(element, "firstname"));
        request.setLastname(AssistProtocolTransfer.getStringField(element, "lastname"));
        request.setMiddlename(AssistProtocolTransfer.getStringField(element, "middlename"));
        request.setEmail(AssistProtocolTransfer.getStringField(element, "email"));
        request.setOrderdate(AssistProtocolTransfer.getDateField(element, "orderdate"));
        request.setOrderstate(AssistProtocolTransfer.getEnumField(AssistProtocolOrderState.class, element, "orderstate"));
        request.setPacketdate(AssistProtocolTransfer.getDateField(element, "packetdate"));
        request.setSignature(AssistProtocolTransfer.getStringField(element, "signature"));
        request.setCheckvalue(AssistProtocolTransfer.getStringField(element, "checkvalue"));
        return request;
    }

    private static AssistProtocolRequestOperation parseRequestOperation(Element element) throws AssistProtocolTransferException {
        AssistProtocolRequestOperation request = new AssistProtocolRequestOperation();
        request.setBillnumber(AssistProtocolTransfer.getStringField(element, "billnumber"));
        request.setAmount(AssistProtocolTransfer.getBigDecimalField(element, "amount"));
        request.setCurrency(AssistProtocolTransfer.getStringField(element, "currency"));
        request.setClientip(AssistProtocolTransfer.getStringField(element, "clientip"));
        request.setIpaddress(AssistProtocolTransfer.getStringField(element, "ipaddress"));
        request.setMeantype_id(AssistProtocolTransfer.getIntegerField(element, "meantype_id"));
        request.setMeantypename(AssistProtocolTransfer.getStringField(element, "meantypename"));
        request.setMeansubtype(AssistProtocolTransfer.getStringField(element, "meansubtype"));
        request.setMeannumber(AssistProtocolTransfer.getStringField(element, "meannumber"));
        request.setCardholder(AssistProtocolTransfer.getStringField(element, "cardholder"));
        request.setIssuebank(AssistProtocolTransfer.getStringField(element, "issuebank"));
        request.setBankcountry(AssistProtocolTransfer.getStringField(element, "bankcountry"));
        request.setResponsecode(AssistProtocolTransfer.getEnumField(AssistProtocolResponseCode.class, element, "responsecode"));
        request.setMessage(AssistProtocolTransfer.getStringField(element, "message"));
        request.setCustomermessage(AssistProtocolTransfer.getStringField(element, "customermessage"));
        request.setRecommendation(AssistProtocolTransfer.getStringField(element, "recommendation"));
        request.setApprovalcode(AssistProtocolTransfer.getStringField(element, "approvalcode"));
        request.setProtocoltypename(AssistProtocolTransfer.getStringField(element, "protocoltypename"));
        request.setProcessingname(AssistProtocolTransfer.getStringField(element, "processingname"));
        request.setOperationtype(AssistProtocolTransfer.getEnumField(AssistProtocolOperationType.class, element, "operationtype"));
        return request;
    }

    private Document getDoc(String documentUrl, Map<String, String> parameters) throws AssistProtocolTransferException {
        HttpURLConnection con = null;
        try {
            URL url = new URL(documentUrl);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            PrintStream ps = new PrintStream(con.getOutputStream(), true);
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                ps.print(param.getKey());
                ps.print('=');
                ps.print(URLEncoder.encode(param.getValue(), ENCODING));
                ps.print('&');
            }
            ps.print("Merchant_ID=" + String.valueOf(this.merchant_ID) + "&");
            ps.print("LOGIN=" + this.login + "&");
            ps.print("PASSWORD=" + this.password + "&");
            ps.print("FORMAT=3&");
            if (con.getResponseCode() == 200) {
                BufferedInputStream bis = new BufferedInputStream(con.getInputStream());
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                Document document = docBuilder.parse(new InputSource(bis));
                if (logger.isDebugEnabled()) {
                    logger.debug(XMLUtils.serializeToString((Node)document, (boolean)false));
                }
                bis.close();
                Document document2 = document;
                return document2;
            }
            try {
                throw new AssistProtocolTransferException("HTTP response code '" + con.getResponseCode() + "' not equals HTTP_OK");
            }
            catch (Exception e) {
                logger.error("error get document", (Throwable)e);
                if (e instanceof AssistProtocolTransferException) {
                    throw (AssistProtocolTransferException)e;
                }
                throw new AssistProtocolTransferException("error get document", e);
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public AssistProtocolRequestGetOperations getRequest(long ordernumber, Date date) throws AssistProtocolTransferException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("ordernumber", String.valueOf(ordernumber));
        if (date != null) {
            Calendar periodBegin = Calendar.getInstance();
            periodBegin.setTimeInMillis(date.getTime() - 86400000L);
            periodBegin.setTimeZone(TimeZone.getTimeZone("GMT"));
            Calendar periodEnd = Calendar.getInstance();
            periodEnd.setTimeInMillis(date.getTime() + 172800000L);
            periodEnd.setTimeZone(TimeZone.getTimeZone("GMT"));
            parameters.put("STARTDAY", String.valueOf(periodBegin.get(5)));
            parameters.put("STARTMONTH", String.valueOf(periodBegin.get(2) + 1));
            parameters.put("STARTYEAR", String.valueOf(periodBegin.get(1)));
            parameters.put("StartHour", String.valueOf(periodBegin.get(11)));
            parameters.put("StartMin", String.valueOf(periodBegin.get(12)));
            parameters.put("ENDDAY", String.valueOf(periodEnd.get(5)));
            parameters.put("ENDMONTH", String.valueOf(periodEnd.get(2) + 1));
            parameters.put("ENDYEAR", String.valueOf(periodEnd.get(1)));
            parameters.put("EndHour", String.valueOf(periodEnd.get(11)));
            parameters.put("EndMin", String.valueOf(periodEnd.get(12)));
        }
        Document doc = this.getDoc(RESULTS_URL, parameters);
        int firstcode = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@firstcode"), (int)-1);
        int secondcode = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@secondcode"), (int)-1);
        int count = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@count"), (int)-1);
        if (firstcode == 0 && secondcode == 0 && count > 0) {
            AssistProtocolRequestOrder order = AssistProtocolTransfer.parseRequestOrder(XMLUtils.selectElement((Node)doc, (String)"/result/order"));
            ArrayList<AssistProtocolRequestOperation> operations = new ArrayList<AssistProtocolRequestOperation>();
            for (Element el : XMLUtils.selectElements((Node)doc, (String)"/result/order/operation")) {
                operations.add(AssistProtocolTransfer.parseRequestOperation(el));
            }
            AssistProtocolRequestGetOperations result = new AssistProtocolRequestGetOperations();
            result.setOrder(order);
            result.setOperations(operations);
            return result;
        }
        if ((firstcode >= 0 || secondcode >= 0) && count >= 0) {
            throw new AssistProtocolTransferException(firstcode, secondcode);
        }
        throw new AssistProtocolTransferException("Error parse xml (strange structure or invalid attributes)");
    }

    public AssistProtocolRequestOrder doRecurring(long billnumber, long ordernumber, BigDecimal amount, String orderComment) throws AssistProtocolTransferException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("BillNumber", String.valueOf(billnumber));
        parameters.put("OrderNumber", String.valueOf(ordernumber));
        parameters.put("Amount", amount.toPlainString());
        parameters.put("Currency", "RUB");
        parameters.put("Language", "RU");
        if (orderComment != null) {
            parameters.put("OrderComment", orderComment);
        }
        Document doc = this.getDoc(RECURRING_URL, parameters);
        int firstcode = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@firstcode"), (int)-1);
        int secondcode = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@secondcode"), (int)-1);
        int count = Utils.parseInt((String)XMLUtils.selectText((Node)doc, (String)"/result/@count"), (int)-1);
        if (firstcode == 0 && secondcode == 0 && count > 0) {
            AssistProtocolRequestOrder order = AssistProtocolTransfer.parseRequestOrder(XMLUtils.selectElement((Node)doc, (String)"/result/orders/order"));
            return order;
        }
        if ((firstcode >= 0 || secondcode >= 0) && count >= 0) {
            throw new AssistProtocolTransferException(firstcode, secondcode);
        }
        throw new AssistProtocolTransferException("Error parse xml (strange structure or invalid attributes)");
    }
}

