/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.assist.common.bean.Transaction;
import ru.bitel.bgbilling.modules.assist.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.bgbilling.modules.assist.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolRequestPaymentResult;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransfer;
import ru.bitel.bgbilling.modules.assist.server.protocol.AssistProtocolTransferException;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.util.DebugUtils;

@WebServlet(name="AssistExecutor", urlPatterns={"/assistexecuter/*"})
public class ModuleExecuter
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            try {
                int moduleId = ModuleExecuter.getModuleId((HttpServletRequest)request);
                AssistProtocolRequestPaymentResult paymentRequest = null;
                try {
                    paymentRequest = AssistProtocolTransfer.parseRequestSoapServlet((InputStream)request.getInputStream());
                }
                catch (AssistProtocolTransferException e) {
                    ModuleExecuter.doReply(null, response, 1, 0);
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043e\u0442 assist", (Throwable)e);
                    if (con != null) {
                        con.close();
                    }
                    return;
                }
                logger.debug("get request : " + DebugUtils.dumpObject((Object)paymentRequest));
                try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                    int ordernumber = paymentRequest.getOrder().getOrdernumber();
                    Transaction transaction = (Transaction)transactionManager.get(ordernumber);
                    if (transaction == null) {
                        logger.error("\u041e\u0448\u0438\u0431\u043a\u0430: \u043f\u043b\u0430\u0442\u0435\u0436\u0430 (\u0437\u0430\u043a\u0430\u0437\u0430) #" + ordernumber + " \u043d\u0435\u0442 \u0432 \u0431\u0430\u0437\u0435");
                        ModuleExecuter.doReply(null, response, 5, 107);
                        return;
                    }
                    if (paymentRequest.getOperation().getResponsecode().isSuccessful()) {
                        Object message;
                        boolean needPayment;
                        boolean bl = needPayment = transaction.getStatus().equals(TransactionStatus.FAIL.getCode()) || transaction.getStatus().equals(TransactionStatus.NEW.getCode());
                        if (transaction.getStatus().equals(TransactionStatus.FAIL.getCode())) {
                            message = "Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0439: " + transaction.getStatus() + "/" + (transaction.getResponseCode() != null ? transaction.getResponseCode().toString() : "?") + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439: " + paymentRequest.getOperation().getResponsecode();
                            logger.warn((String)message);
                        }
                        AssistUtils.fillPayment(transaction, paymentRequest.getOrder(), paymentRequest.getOperation());
                        transaction.setStatus(TransactionStatus.OK.getCode());
                        transactionManager.update(transaction);
                        if (needPayment) {
                            transactionManager.carryOutPayment(transaction);
                        }
                        message = needPayment ? "\u0412 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0431\u044b\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u043f\u043b\u0430\u0442\u0451\u0436!\n" : "\u041f\u043b\u0430\u0442\u0451\u0436 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0451\u043d \u041d\u0415 \u0431\u044b\u043b (\u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d)!\n";
                        logger.info("\u0421\u0442\u0430\u0442\u0443\u0441: \u0443\u0441\u043f\u0435\u0448\u043d\u043e, " + (transaction.getRecurringParentId() > 0 ? "\u0410\u0412\u0422\u041e" : "") + "\u043f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + ", billnumber: " + transaction.getBillnumber() + ", \u043f\u043e\u0441\u0442\u0443\u043f\u0438\u0432\u0448\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + transaction.getSum().toPlainString() + "; " + (String)message);
                        AssistPaymentRecurringManager assistPaymentRecurringManager = new AssistPaymentRecurringManager(con, moduleId);
                        if (assistPaymentRecurringManager.updateBillnumber(ordernumber, transaction.getContractId(), transaction.getBillnumber())) {
                            logger.info("\u042d\u0442\u0438\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u043e\u043c \u0431\u044b\u043b \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0451\u0436!");
                        }
                    } else if (paymentRequest.getOperation().getResponsecode().isUnsuccessful()) {
                        if (transaction.getStatus().equals(TransactionStatus.OK.getCode())) {
                            String message = "Assist: \u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439: " + transaction.getStatus() + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435\u0443\u0434\u0430\u0447\u0435\u043d: " + paymentRequest.getOperation().getResponsecode();
                            logger.error(message);
                        } else {
                            AssistUtils.fillPayment(transaction, paymentRequest.getOrder(), paymentRequest.getOperation());
                            transaction.setStatus(TransactionStatus.FAIL.getCode());
                            transactionManager.update(transaction);
                            logger.info("\u0421\u0442\u0430\u0442\u0443\u0441: \u043d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e, " + (transaction.getRecurringParentId() > 0 ? "\u0410\u0412\u0422\u041e" : "") + "\u043f\u043b\u0430\u0442\u0451\u0436 #" + ordernumber + ". \u041a\u043e\u0434 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (responsecode): " + paymentRequest.getOperation().getResponsecode() + ", \u0442\u043e\u043b\u043a\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0434\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 (recommendation): " + paymentRequest.getOperation().getRecommendation() + ", ");
                        }
                    } else if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                        String message = "Assist: \u041e\u0448\u0438\u0431\u043a\u0430! \u0412 \u0411\u0414 \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: " + transaction.getStatus() + ", \u043d\u043e \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435\u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0439: " + paymentRequest.getOperation().getResponsecode();
                        logger.warn(message);
                    } else {
                        AssistUtils.fillPayment(transaction, paymentRequest.getOrder(), paymentRequest.getOperation());
                        transactionManager.update(transaction);
                    }
                    ModuleExecuter.doReply(paymentRequest, response, 0, 0);
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("error do post", (Throwable)ex);
            ModuleExecuter.doReply(null, response, 1, 0);
        }
    }

    public static void doReply(AssistProtocolRequestPaymentResult paymentRequest, HttpServletResponse response, int firstcode, int secondcode) throws IOException {
        PrintWriter out = response.getWriter();
        AssistProtocolTransfer.doReply(paymentRequest, out, firstcode, secondcode);
        out.flush();
        out.close();
        logger.debug("do reply firstcode=" + firstcode + ",secondcode=" + secondcode);
    }
}

