/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.extractor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.ExtractorPositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.extractor.Extractor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class NpayExtractor
extends Extractor {
    private boolean ext;
    private Calendar month;
    private int moduleId;
    private Connection con;
    private String cids;
    private ContractObjectDao objectDao;

    private ContractObjectDao getContractObjectDao() {
        if (this.objectDao == null) {
            this.objectDao = new ContractObjectDao(this.con, 0);
        }
        return this.objectDao;
    }

    @Override
    public List<PositionValue> extract(String function, Connection con, String cids, Calendar month, List<String> paramList, String posName) {
        ArrayList<PositionValue> result = new ArrayList<PositionValue>();
        this.con = con;
        this.cids = cids;
        this.objectDao = null;
        try {
            HashSet<String> acceptFunctionSet = new HashSet<String>(Arrays.asList("SERVICES", "SERVICES_EXT", "SERVICES_EXCEPT", "SERVICES_EXT_EXCEPT"));
            this.moduleId = this.getIntParam(paramList, 0);
            this.month = this.getMonthParam(month, paramList, 1);
            if (function.equals("SERVICES_DETAIL")) {
                this.extractDetail(result, posName, paramList);
            } else if (acceptFunctionSet.contains(function)) {
                String serviceTable = "npay_service_object_" + this.moduleId;
                if (!ServerUtils.tableExists((Connection)con, (String)serviceTable)) {
                    return result;
                }
                String sids = paramList.size() > 2 ? Utils.toString(paramList, (int)2) : null;
                boolean except = function.indexOf("EXCEPT") > -1;
                boolean withPeriod = posName != null && posName.indexOf("$period") > -1;
                boolean bl = this.ext = function.indexOf("SERVICES_EXT") > -1;
                if (this.ext) {
                    this.serviceExt(result, serviceTable, sids, posName, except, withPeriod);
                } else {
                    this.service(result, serviceTable, sids, posName, except, withPeriod);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void service(List<PositionValue> result, String serviceTable, String sids, String posName, boolean except, boolean withPeriod) throws Exception {
        List<ServiceObject> serviceObjects = this.getServiceList(serviceTable, sids, except, withPeriod);
        Map<Integer, List<ServiceObject>> serviceQuantity = serviceObjects.stream().collect(Collectors.groupingBy(ServiceObject::getServiceId));
        String query = "SELECT cid, ca.sid, SUM(ca.summa) AS summ, service.title FROM contract_account AS ca INNER JOIN service ON ca.sid=service.id AND service.mid=? WHERE cid IN (" + this.cids + ") AND ca.yy=? AND ca.mm=?";
        if (Utils.notBlankString((String)sids)) {
            query = query + " AND sid " + (except ? "NOT " : "") + "IN (" + sids + ")";
        }
        query = query + " GROUP BY ca.sid HAVING summ>0";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, this.moduleId);
            ps.setInt(2, this.month.get(1));
            ps.setInt(3, this.month.get(2) + 1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int serviceId = rs.getInt("ca.sid");
                BigDecimal sum = Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal("summ"));
                String title = rs.getString("service.title");
                List<ServiceObject> list = serviceQuantity.get(serviceId);
                if (list.size() <= 0) continue;
                ServiceObject serviceObject = list.get(0);
                ExtractorPositionValue value = new ExtractorPositionValue();
                value.setQuantity(this.getTotalCount(list));
                value.setSum(sum);
                value.setName(this.makeTitle(posName, title, serviceObject.comment, serviceObject, this.month));
                value.setServiceId(serviceId);
                value.setModuleId(this.moduleId);
                result.add(value);
            }
        }
    }

    private void serviceExt(List<PositionValue> result, String serviceTable, String sids, String posName, boolean except, boolean withPeriod) throws Exception {
        List<ServiceObject> serviceObjects = this.getServiceList(serviceTable, sids, except, withPeriod);
        Map<Integer, Map<Integer, List<ServiceObject>>> serviceQuantity = serviceObjects.stream().collect(Collectors.groupingBy(ServiceObject::getContractId, Collectors.groupingBy(ServiceObject::getServiceId)));
        String query = "SELECT cid, ca.sid, SUM(ca.summa) AS summ, service.title FROM contract_account AS ca INNER JOIN service ON ca.sid=service.id AND service.mid=? WHERE cid IN (" + this.cids + ") AND ca.yy=? AND ca.mm=?";
        if (Utils.notBlankString((String)sids)) {
            query = query + " AND sid " + (except ? "NOT " : "") + "IN (" + sids + ")";
        }
        query = query + " GROUP BY cid,ca.sid HAVING summ>0";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, this.moduleId);
            ps.setInt(2, this.month.get(1));
            ps.setInt(3, this.month.get(2) + 1);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int contractId = rs.getInt("cid");
                    int serviceId = rs.getInt("ca.sid");
                    BigDecimal sum = Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal("summ"));
                    List<ServiceObject> list = serviceQuantity.get(contractId).get(serviceId);
                    sum = sum.divide(this.getTotalCount(list), 20, RoundingMode.HALF_DOWN);
                    String title = rs.getString("service.title");
                    for (ServiceObject so : list) {
                        ExtractorPositionValue value = new ExtractorPositionValue();
                        value.setQuantity(so.quantity);
                        value.setSum(sum.multiply(so.quantity));
                        value.setName(this.makeTitle(posName, title, so.comment, so, this.month));
                        value.setServiceId(serviceId);
                        value.setModuleId(this.moduleId);
                        result.add(value);
                    }
                }
            }
        }
    }

    private BigDecimal getTotalCount(List<ServiceObject> list) {
        BigDecimal total = BigDecimal.ZERO;
        for (ServiceObject serviceObject : list) {
            total = total.add(serviceObject.quantity);
        }
        return total;
    }

    private List<ServiceObject> getServiceList(String serviceTable, String sids, boolean except, boolean withPeriod) throws Exception {
        ArrayList<ServiceObject> list = new ArrayList<ServiceObject>();
        String query = "SELECT * FROM " + serviceTable + " WHERE cid IN (" + this.cids + " ) AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ";
        if (Utils.notBlankString((String)sids)) {
            query = query + " AND sid " + (except ? "NOT " : "") + "IN (" + sids + ")";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            Calendar monthEnd = TimeUtils.getEndMonth((Calendar)this.month);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)monthEnd));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.month));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceObject current = new ServiceObject(rs.getInt("cid"), rs.getInt("sid"), rs.getBigDecimal("col"), rs.getString("comment"), rs.getInt("oid"));
                if (withPeriod) {
                    current.period = new Period(this.month.getTime(), monthEnd.getTime());
                    if (this.ext) {
                        Period period = new Period((Date)rs.getDate("date1"), (Date)rs.getDate("date2"));
                        if (period.getDateFrom() == null || TimeUtils.dateBefore((Calendar)TimeUtils.convertDateToCalendar((Date)period.getDateFrom()), (Calendar)this.month)) {
                            period.setDateFrom(this.month.getTime());
                        }
                        if (period.getDateTo() == null || TimeUtils.dateBefore((Calendar)monthEnd, (Calendar)TimeUtils.convertDateToCalendar((Date)period.getDateFrom()))) {
                            period.setDateTo(monthEnd.getTime());
                        }
                        current.period = period;
                    }
                }
                list.add(current);
            }
        }
        return list;
    }

    private String makeTitle(String posName, String servTitle, String serComment, ServiceObject serviceObject, Calendar month) throws BGException {
        ContractObject object;
        if (posName == null || posName.trim().equals("$default")) {
            return this.makeTitle(servTitle, this.ext ? serComment : null);
        }
        String title = posName;
        if (serviceObject.period != null) {
            title = title.replaceAll("\\$period", TimeUtils.formatPeriod((Period)serviceObject.period));
        }
        title = title.replaceAll("\\$title", servTitle);
        title = title.replaceAll("\\$comment", this.ext ? serComment : "");
        if (serviceObject.objectId > 0 && title.indexOf("$oid.name") > -1 && (object = (ContractObject)this.getContractObjectDao().get(serviceObject.objectId)) != null && Utils.notBlankString((String)object.getTitle())) {
            title = title.replaceAll("\\$oid.name", object.getTitle());
        }
        title = title.replaceAll("\\$oid.name", "");
        title = BillUtil.parsePositionName(title, month);
        return title;
    }

    private void extractDetail(List<PositionValue> result, String posName, List<String> paramList) throws SQLException {
        String npayDetailTable;
        String sids = null;
        if (paramList.size() > 2) {
            sids = Utils.toString(paramList, (int)2);
        }
        if (ServerUtils.tableExists((Connection)this.con, (String)(npayDetailTable = ServerUtils.getModuleMonthTableName((String)"npay_detail", (Date)this.month.getTime(), (int)this.moduleId)))) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT detail.sid, SUM(detail.col), SUM(detail.summa), service.title FROM " + npayDetailTable + " as detail LEFT JOIN service ON service.id=detail.sid WHERE detail.cid IN (" + this.cids + " )");
            if (Utils.notBlankString((String)sids)) {
                sb.append(" AND detail.sid IN ( " + sids + " )");
            }
            sb.append(" GROUP BY detail.sid, detail.summa/detail.col");
            try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int serviceId = rs.getInt(1);
                    BigDecimal quantity = BigDecimal.valueOf(rs.getInt(2));
                    BigDecimal summa = Utils.roundBigDecimalSumm((BigDecimal)rs.getBigDecimal(3));
                    String title = posName.replaceAll("\\$title", rs.getString(4));
                    ExtractorPositionValue value = new ExtractorPositionValue();
                    value.setSum(summa);
                    value.setName(BillUtil.parsePositionName(title, this.month));
                    value.setQuantity(quantity);
                    value.setServiceId(serviceId);
                    value.setModuleId(this.moduleId);
                    result.add(value);
                }
            }
        }
    }

    private class ServiceObject {
        public int contractId;
        public int serviceId;
        public BigDecimal quantity;
        public String comment;
        public Period period;
        public int objectId;

        public ServiceObject(int contractId, int serviceId, BigDecimal quantity, String comment, int objectId) {
            this.contractId = contractId;
            this.serviceId = serviceId;
            this.comment = comment;
            this.quantity = quantity;
            if (this.quantity.compareTo(BigDecimal.ONE) < 0) {
                this.quantity = BigDecimal.ONE;
            }
            this.objectId = objectId;
        }

        public int getContractId() {
            return this.contractId;
        }

        public int getServiceId() {
            return this.serviceId;
        }
    }
}

