/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotDialogConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ExportImport;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.common.Utils;

public class BotExportDialog
extends ExportImport {
    private BotDialog dialogForExport;

    protected BotExportDialog(BotDialogConfigurePanel parentPanel, BotDialog dialogForExport) {
        super(parentPanel, "\u042d\u043a\u0441\u043f\u043e\u0440\u0442 \u0434\u0438\u0430\u043b\u043e\u0433\u0430", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        if (dialogForExport == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u0430\u043b\u043e\u0433 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430!");
            return;
        }
        this.dialogForExport = dialogForExport;
    }

    @Override
    protected void configurateFileChooser(JFileChooser fileChooser) {
        fileChooser.setFileSelectionMode(1);
    }

    @Override
    protected void process(JFileChooser fileChooser) throws BGException {
        File directory = fileChooser.getSelectedFile();
        try {
            File file = new File(directory.getAbsolutePath() + File.separator + this.dialogForExport.getTitle() + ".bm");
            byte[] bytes = this.convertBotDialogToString(this.dialogForExport).getBytes("UTF-8");
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(bytes);
            }
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String convertBotDialogToString(BotDialog dialog) throws IOException, BGException {
        JSONObject json = new JSONObject();
        json.put("title", (Object)dialog.getTitle());
        JSONArray elements = new JSONArray();
        for (BotDialogElement element : dialog.getDialogElements()) {
            JSONObject jsonElement = new JSONObject();
            jsonElement.put("config", (Object)element.getJSONConfig());
            jsonElement.put("elementType", element.getElementType().ordinal());
            elements.put((Object)jsonElement);
        }
        json.put("elements", (Object)elements);
        json.put("onlySignedUser", dialog.isOnlySignedUser());
        String processingClass = dialog.getProcessingClass();
        if (Utils.notBlankString((String)processingClass)) {
            json.put("processingClassName", (Object)processingClass);
            json.put("processingClass", (Object)this.getDialogProcessingClassSource(processingClass));
        }
        return json.toString();
    }

    private String getDialogProcessingClassSource(String processingClass) throws IOException, BGException {
        return this.dynamicCodeService.getSource(processingClass);
    }
}

