/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.idealer;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.card.common.bean.DealerPayment;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBaseIDealer;
import ru.bitel.bgbilling.modules.card.server.bean.DealerPaymentDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;

public class ActionPaymentList
extends ActionBaseIDealer {
    public void doAction() throws SQLException, BGException {
        if (this.mid < 0 || this.dealer == null) {
            return;
        }
        Page page = this.getPage();
        Date from = this.getDateParameter("from");
        Date until = this.getDateParameter("until");
        int type = this.getIntParameter("type", 3);
        String contractTitle = this.getParameter("contract");
        if (from == null) {
            from = new Date();
        }
        DealerPaymentDao dao = new DealerPaymentDao(this.con, this.mid, from);
        Result<DealerPayment> result = dao.list(Collections.singleton(this.dealer.getId()), from, until, type, null, contractTitle, 0L, null, page);
        Element payments = this.createElement(this.rootNode, "payments");
        for (DealerPayment payment : result.getList()) {
            Element payEl = this.createElement(payments, "payment");
            int status = payment.getStatus();
            payEl.setAttribute("id", String.valueOf(payment.getId()));
            payEl.setAttribute("cid", String.valueOf(payment.getContractId()));
            payEl.setAttribute("trans", payment.getTransId());
            payEl.setAttribute("summ", Utils.formatCost((BigDecimal)payment.getSumma()));
            payEl.setAttribute("date", TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH.mm.ss"));
            payEl.setAttribute("comment", payment.getPaymentComment());
            payEl.setAttribute("contract", payment.getContractTitle());
            payEl.setAttribute("contract_comment", payment.getContractComment());
            payEl.setAttribute("status", String.valueOf(status));
            if (status != 1) continue;
        }
        payments.setAttribute("number", String.valueOf(result.getAttribute("payedCount")));
        payments.setAttribute("total", Utils.formatCost((BigDecimal)((BigDecimal)result.getAttribute("payedTotal"))));
        this.setPageAttribute(payments, page);
    }
}

