/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.list.BGUList;

public class ServicePropertiesPanel
extends ServicePanel {
    private boolean loadList = true;
    private String sid = "0";
    private JPasswordField cardPinCode = new JPasswordField();
    private BGTable tableContractCard = new BGTable();
    private JPanel editor = new JPanel();
    private JTextField cardCode = new JTextField();
    private BGUList<BGUListItem> serviceList = new BGUList();

    public ServicePropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.setVisible(false);
        this.tableContractCard.setHeader(this.rb_name, "0");
    }

    private void jbInit() throws Exception {
        this.serviceList.addListSelectionListener(e -> this.serviceList_valueChanged(e));
        this.editor.setLayout(new GridBagLayout());
        this.editor.setBorder((Border)new BGTitleBorder(" \u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 "));
        this.cardCode.setMinimumSize(new Dimension(110, 20));
        this.cardCode.setColumns(10);
        this.cardCode.setHorizontalAlignment(0);
        this.cardPinCode.setMinimumSize(new Dimension(110, 20));
        this.cardPinCode.setPreferredSize(new Dimension(110, 20));
        this.cardPinCode.setColumns(10);
        this.cardPinCode.setHorizontalAlignment(0);
        JButton okButton = new JButton("\u041e\u043a");
        okButton.addActionListener(e -> this.okButton_actionPerformed(e));
        JButton cancelButton = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        cancelButton.addActionListener(e -> this.cancelButton_actionPerformed(e));
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder((Border)new BGTitleBorder(" \u0422\u0438\u043f\u044b \u043a\u0430\u0440\u0442 "));
        jPanel1.add((Component)new JScrollPane((Component)this.serviceList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder((Border)new BGTitleBorder(" \u041a\u0430\u0440\u0442\u044b "));
        jPanel3.add((Component)new JScrollPane((Component)this.tableContractCard), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane jSplitPane1 = new JSplitPane();
        jSplitPane1.setDividerSize(5);
        jSplitPane1.setDividerLocation(300);
        jSplitPane1.add((Component)jPanel1, "left");
        jSplitPane1.add((Component)jPanel2, "right");
        this.setLayout(new GridLayout());
        this.add(jSplitPane1, null);
        JLabel jLabel2 = new JLabel("PIN-\u043a\u043e\u0434 (\u043f\u0430\u0440\u043e\u043b\u044c):");
        jLabel2.setRequestFocusEnabled(true);
        this.editor.add((Component)new JLabel("\u041a\u043e\u0434 (\u043b\u043e\u0433\u0438\u043d) \u043a\u0430\u0440\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.add((Component)this.cardCode, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.add((Component)this.cardPinCode, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)okButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)cancelButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    public void setData() {
        if (this.getContractId() == -1 || this.getModuleId() == -1) {
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setContractId(this.getContractId());
        request.setModuleId(this.getModuleId());
        request.setAttribute("sid", this.sid);
        request.setAttribute("list", this.loadList ? "1" : "0");
        request.setAction("CardContractInfo");
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (!ClientUtils.checkStatus((Document)doc)) {
            return;
        }
        if (this.loadList) {
            this.loadList = false;
            ArrayList list = new ArrayList();
            XMLUtils.selectElements((Node)doc, (String)"//services/item").forEach(a -> list.add(new BGUListItem(Utils.parseInt((String)a.getAttribute("id")), a.getAttribute("title"))));
            this.serviceList.setData(list);
        }
        this.tableContractCard.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.cardCode.setText("");
            this.cardPinCode.setText("");
            this.editor.setVisible(true);
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        }
    }

    private void serviceList_valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.serviceList.optSelectedValue().ifPresent(a -> {
            this.sid = String.valueOf(a.getId());
        });
        this.setData();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        if (this.serviceList.isSelectionEmpty()) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0430\u0440\u0442\u044b", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
        if (this.cardCode.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
        String pinCode = new String(this.cardPinCode.getPassword());
        if (pinCode.trim().length() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 PIN-\u043a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ActiveCard");
        request.setContractId(this.getContractId());
        request.setModuleId(this.getModuleId());
        request.setAttribute("sid", String.valueOf(this.sid));
        request.setAttribute("cardCode", this.cardCode.getText().trim());
        request.setAttribute("cardPinCode", pinCode.trim());
        request.setAttribute("status", "3");
        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
            this.editor.setVisible(false);
            this.setData();
        }
    }

    private void cancelButton_actionPerformed(ActionEvent e) {
        this.editor.setVisible(false);
    }
}

