/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server;

import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.ChannelMapping;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.DigitalTVServiceActivator;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class TestServiceActivator
extends DigitalTVServiceActivator {
    private static final Logger log = LogManager.getLogger();

    public TestServiceActivator(ParameterMap moduleSetup, Connection con, Connection conSlave, int mid, Calendar time) throws BGException {
        super(moduleSetup, con, conSlave, mid, time);
        log.info("activator: construct");
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult modifyImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        String loginfo = "activator: modify: card=" + card.getGuiTitle() + "; cardPacketList=" + TestServiceActivator.cardPacketListToString(cardPacketList);
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(UserCard card, List<CardPacket> cardPacketList) throws BGException {
        String loginfo = "activator: cancel: card=" + card.getGuiTitle() + "; cardPacketList=" + TestServiceActivator.cardPacketListToString(cardPacketList);
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    private static String cardPacketListToString(List<CardPacket> cardPacketList) {
        StringBuilder sb = new StringBuilder();
        for (CardPacket cp : cardPacketList) {
            sb.append(cp.toString()).append(", ");
        }
        return sb.toString();
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult cancelImpl(long cardNumber) throws BGException {
        String loginfo = "activator: cancel: cardNumber=" + cardNumber;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    public void destroy() {
        log.info("activator: destroy");
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult parentalPinCodeImpl(long cardNumber, String pinCode) throws BGException {
        String loginfo = "activator: parentalPinCode: cardNumber=" + cardNumber + "; pinCode=" + pinCode;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult sendMessagesImpl(List<Long> cardNumbers, String title, String message, boolean ismail) throws BGException {
        String loginfo = "activator: sendMessage: cardNumbers=" + (cardNumbers != null ? Utils.toString(cardNumbers) : "ALL") + "; title=" + title + "; message=" + message + "; ismail=" + ismail;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    public void checkChannelMapping(ChannelMapping cm) throws BGException {
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult activateImpl(long cardNumber, UserCard card, List<CardPacket> cardPacketList) throws BGException {
        String loginfo = "activator: activate: cardNumber=" + cardNumber + "; usercard=" + (card != null ? card.getGuiTitle() : "null") + "; cardPacketList=" + (cardPacketList != null ? TestServiceActivator.cardPacketListToString(cardPacketList) : "null");
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult deactivateImpl(long cardNumber) throws BGException {
        String loginfo = "activator: deactivate: cardNumber=" + cardNumber;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getSubscribeInfoImpl(long cardNumber) throws BGException {
        String loginfo = "activator: getSubscribeInfoImpl: cardNumber=" + cardNumber;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "\u041a\u0430\u043a \u0431\u0443\u0434\u0442\u043e \u0431\u044b \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043f\u043e \u043a\u0430\u0440\u0442\u0435 " + cardNumber + "\n\n...", loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult getPairingImpl(long cardNumber) throws BGException {
        String loginfo = "activator: getPairingImpl: cardNumber=" + cardNumber;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "test", loginfo, null);
    }

    @Override
    protected DigitalTVServiceActivator.ServiceActivationResult setPairingImpl(long cardNumber, String pairingModule) throws BGException {
        String loginfo = "activator: setPairingImpl: cardNumber=" + cardNumber + "; pairingModule=" + pairingModule;
        log.info(loginfo);
        return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
    }

    @Override
    public DigitalTVServiceActivator.ServiceActivationResult customCommandImpl(long cardNumber, String action, String[] params) throws BGException {
        if ("test".equals(action)) {
            String loginfo = "activator: customCommandImpl - TEST: cardNumber=" + cardNumber;
            log.info(loginfo);
            return new DigitalTVServiceActivator.ServiceActivationResult(true, "ok", loginfo, null);
        }
        throw new UnsupportedOperationException();
    }
}

