<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
        <xsl:call-template name="table"/><br/>
        <xsl:call-template name="sums"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/table">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Контракт:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2><br/>
         Логин:<xsl:value-of select="@login"/>&#160;Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
		 <td>Логин</td>
         <td>Время входа</td>
         <td>Время выхода</td>
         <td>Длительность[в секундах]</td>
         <td>Стоимость</td>
         <td>С номера/На номер</td>
        <xsl:for-each select="/data/table/data/traffic_title">
			<td>
				<xsl:value-of select="@title"/>
			</td>
		</xsl:for-each>
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@login"/></td> 
             <td><xsl:value-of select="@f0"/></td>
             <td><xsl:value-of select="@f1"/></td>
             <td><xsl:value-of select="@f2"/></td>
             <td><xsl:value-of select="@f3"/></td>
             <td><xsl:value-of select="@f4"/></td>
             <xsl:for-each select="traffic">
				<td>
			    	<xsl:value-of select="."/>
				</td>
			</xsl:for-each>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
<br/>
	Количество сессий:&#160;<xsl:value-of select="/data/table/data/@count_amount"/>&#160;
    Итого [в секундах]:&#160;<xsl:value-of select="/data/table/data/@time_amount"/>&#160;
    Итого [в рублях]:&#160;<xsl:value-of select="/data/table/data/@money_amount"/>&#160;
</xsl:template>

</xsl:stylesheet>
