/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.provider.sbis;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;

public class SbisAPI {
    private Logger logger = LogManager.getLogger();
    private int userId = 0;
    private BGPluginServer plugin = null;
    private static Map<Integer, String> tokenMap = new HashMap<Integer, String>();

    public SbisAPI(int userId) {
        this.userId = userId;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.edo");
    }

    public List<String> doChangeList() {
        JSONObject filter = new JSONObject();
        filter.put("\u041f\u043e\u043b\u043d\u044b\u0439\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u042d\u041f", (Object)"\u041d\u0435\u0442");
        JSONObject params = new JSONObject();
        params.put("\u0424\u0438\u043b\u044c\u0442\u0440", (Object)filter);
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.doRequest("", this.getMethod("\u0421\u0411\u0418\u0421.\u0421\u043f\u0438\u0441\u043e\u043a\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", params).toString(), this.getToken()));
        return list;
    }

    private String getToken() {
        String token = tokenMap.get(this.userId);
        if (token == null) {
            JSONObject loginPassword = new JSONObject();
            loginPassword.put("\u041b\u043e\u0433\u0438\u043d", (Object)"bitel");
            loginPassword.put("\u041f\u0430\u0440\u043e\u043b\u044c", (Object)System.getProperty("sbis.password"));
            JSONObject params = new JSONObject();
            params.put("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (Object)loginPassword);
            JSONObject result = new JSONObject(this.doAuthRequest("POST", this.getMethod("\u0421\u0411\u0418\u0421.\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c", params).toString(), null));
            if (result.has("result")) {
                token = result.optString("result");
                tokenMap.put(this.userId, token);
            }
        }
        return token;
    }

    private String doAuthRequest(String method, String outputData, String sessionId) {
        String result = null;
        String url = this.plugin.getSetup().get("sbis.auth.url", "https://online.sbis.ru/auth/service/");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(outputData)).uri(URI.create(url)).header("Content-Type", "application/json-rpc;charset=utf-8").setHeader("User-Agent", "BGBilling 8.0");
        if (sessionId != null) {
            builder.setHeader("X-SBISSessionID", sessionId);
        }
        HttpRequest request = builder.build();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("request = " + request);
            }
            result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("result = " + result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String doRequest(String method, String outputData, String sessionId) {
        String url = this.plugin.getSetup().get("sbis.service.url", "https://online.sbis.ru/service/?srv=1");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(outputData)).uri(URI.create(url)).header("Content-Type", "application/json-rpc;charset=utf-8").setHeader("User-Agent", "BGBilling 8.0");
        if (sessionId != null) {
            builder.setHeader("X-SBISSessionID", sessionId);
        }
        String result = null;
        HttpRequest request = builder.build();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("request = " + request);
            }
            result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("result = " + result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    private JSONObject getMethod(String method, JSONObject params) {
        JSONObject json = new JSONObject();
        json.put("jsonrpc", (Object)"2.0");
        json.put("method", (Object)method);
        json.put("params", (Object)params);
        json.put("id", 0);
        return json;
    }
}

