/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;

public abstract class EmailServiceActivator
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();

    public void create(Account account) throws BGException {
        log.debug("Create service " + account.getAccount());
        try {
            this.createImpl(account);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void cancel(Account account) throws BGException {
        log.debug("Cancel service " + account.getAccount());
        try {
            this.cancelImpl(account);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void modify(Account account) throws BGException {
        log.debug("Modify service " + account.getAccount());
        try {
            this.modifyImpl(account);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected abstract void createImpl(Account var1) throws BGException;

    protected abstract void cancelImpl(Account var1) throws BGException;

    protected abstract void modifyImpl(Account var1) throws BGException;

    @Override
    public void close() {
    }

    public void updateDomain(Domain domain) throws BGException {
        log.debug("Update domain " + domain.getId());
        try {
            this.updateDomainImpl(domain);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void removeDomain(Domain domain) throws BGException {
        log.debug("Remove domain - {}", (Object)domain.getId());
        try {
            this.removeDomainImpl(domain);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    protected abstract void updateDomainImpl(Domain var1) throws BGException;

    protected abstract void removeDomainImpl(Domain var1) throws BGException;
}

