/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.xml.JAXBUtils;

public class SPP_General
extends ServicePanel {
    private JPasswordField password1_TF = new JPasswordField();
    private JPasswordField password2_TF = new JPasswordField();
    private JCheckBox generate = new JCheckBox("\u0430\u0432\u0442\u043e");
    private BGUComboBox<Domain> domain_CB = new BGUComboBox();
    private JComboBox<ComboBoxItem> status_CB = new JComboBox();
    private JTextField account_TF = new JTextField();
    private JComboBox<ComboBoxItem> quota_CB = new JComboBox();
    private JTextArea comment_TA = new JTextArea();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();

    public SPP_General() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.status_CB.addItem(new ComboBoxItem((Object)"0", "\u043e\u0442\u043a\u0440\u044b\u0442"));
        this.status_CB.addItem(new ComboBoxItem((Object)"1", "\u0437\u0430\u043a\u0440\u044b\u0442"));
        this.status_CB.addItem(new ComboBoxItem((Object)"2", "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JPanel accountPanel = new JPanel();
        accountPanel.setLayout(new GridBagLayout());
        accountPanel.add((Component)this.account_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 4), 0, 0));
        accountPanel.add((Component)new JLabel("@"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 5), 0, 0));
        accountPanel.add((Component)this.domain_CB, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 3, 3), 0, 0));
        accountPanel.setBorder((Border)new BGTitleBorder(" E-Mail "));
        this.add(accountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.status_CB, (String)" \u0421\u0442\u0430\u0442\u0443\u0441 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.quota_CB, (String)" \u041a\u0432\u043e\u0442\u0430 "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel passwordPanel = new JPanel();
        passwordPanel.setLayout(new GridBagLayout());
        passwordPanel.add((Component)this.password1_TF, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 3, 3, 10), 0, 0));
        passwordPanel.add((Component)this.password2_TF, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 3, 10), 0, 0));
        passwordPanel.add((Component)this.generate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        passwordPanel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u043e\u043b\u044c "));
        this.add(passwordPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.period, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane(this.comment_TA), (String)" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.comment_TA.setMargin(new Insets(3, 3, 3, 3));
        this.comment_TA.setLineWrap(true);
        this.comment_TA.setWrapStyleWord(true);
        this.account_TF.setMinimumSize(new Dimension(110, 25));
        this.account_TF.setPreferredSize(new Dimension(110, 25));
        this.account_TF.setColumns(10);
        this.account_TF.setHorizontalAlignment(0);
        this.password2_TF.setMinimumSize(new Dimension(4, 25));
        this.password2_TF.setPreferredSize(new Dimension(4, 25));
        this.password1_TF.setMinimumSize(new Dimension(4, 25));
        this.password1_TF.setPreferredSize(new Dimension(4, 25));
        this.password1_TF.setText("");
    }

    public boolean updateData() {
        char[] pswd1 = this.password1_TF.getPassword();
        char[] pswd2 = this.password2_TF.getPassword();
        if (Utils.isEmptyString((String)this.period.getDateString1())) {
            ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
            return false;
        }
        if (pswd1.length != pswd2.length) {
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
            return false;
        }
        for (int i = 0; i < pswd1.length; ++i) {
            if (pswd1[i] == pswd2[i]) continue;
            ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
            return false;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("UpdateAccount");
        request.setModuleId(this.getModuleId());
        request.setAttribute("id", Utils.parseInt((String)this.id) <= 0 ? "new" : this.id);
        request.setContractId(this.getContractId());
        request.setAttribute("account", this.account_TF.getText());
        request.setAttribute("domain", ((Domain)this.domain_CB.getSelectedItem()).getId());
        request.setAttribute("password", new String(this.password1_TF.getPassword()));
        request.setAttribute("status", ((ComboBoxItem)this.status_CB.getSelectedItem()).getObject());
        if (this.generate.isSelected()) {
            request.setAttribute("set_pswd", "1");
        }
        request.setAttribute("quota", ((ComboBoxItem)this.quota_CB.getSelectedItem()).getObject());
        request.setAttribute("comment", this.comment_TA.getText().trim());
        request.setAttribute("date1", this.period.getDateString1());
        request.setAttribute("date2", this.period.getDateString2());
        return ClientUtils.checkStatus((Document)this.getDocument(request));
    }

    public void setData() {
        if (!this.init) {
            this.init();
        }
        if (Utils.parseInt((String)this.id) > 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetAccount");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", this.id);
            this.setDocument(this.getDocument(request));
        } else {
            this.account_TF.setText("");
            this.comment_TA.setText("");
            this.status_CB.setSelectedIndex(0);
            this.quota_CB.setSelectedIndex(0);
            this.password1_TF.setText("");
            this.password2_TF.setText("");
            this.period.setDateCalendar1((Calendar)new GregorianCalendar());
            this.period.setDateCalendar2(null);
        }
        this.account_TF.setEnabled(Utils.parseInt((String)this.id) <= 0);
        this.domain_CB.setEnabled(Utils.parseInt((String)this.id) <= 0);
    }

    private void init() {
        this.init = true;
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("QuotaList");
        request.setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.quota_CB.setModel(ClientUtils.buildComboBox((Node)XMLUtils.getNode((Document)doc, (String)"quota_list"), (String)""));
        }
        request.setModule(this.module);
        request.setAction("Domain");
        request.setModuleId(this.getModuleId());
        doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.domain_CB.setData(JAXBUtils.unmarshalResult((Document)doc, Domain.class).getList());
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element node = XMLUtils.getElement((Document)doc, (String)"account");
            this.account_TF.setText(node.getAttribute("account"));
            this.domain_CB.setSelectedItem((Object)node.getAttribute("domain"));
            ClientUtils.setComboBoxSelection(this.quota_CB, (Object)node.getAttribute("quota"));
            ClientUtils.setComboBoxSelection(this.status_CB, (Object)node.getAttribute("status"));
            this.comment_TA.setText(node.getAttribute("comment"));
            this.password1_TF.setText(node.getAttribute("password"));
            this.password2_TF.setText(node.getAttribute("password"));
            this.period.setDateString1(node.getAttribute("date1"));
            this.period.setDateString2(node.getAttribute("date2"));
        }
    }
}

