/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.helpdesk.client.admin.HelpDeskPackageEditor;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Page;

public class HelpDeskPackageTab
extends BGUPanel {
    private BGTable table = new BGTable();
    private HelpDeskPackageEditor packageEditor = null;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();

    public HelpDeskPackageTab() {
        super(new ClientContext("ru.bitel.bgbilling.plugins.helpdesk", -1, -1, ActionConfig.class.getPackage().getName() + ".setup"));
    }

    protected void jbInit() throws Exception {
        this.panelPages.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String propertyName = event.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    HelpDeskPackageTab.this.performAction("refresh");
                }
            }
        });
        BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("package"), "package");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() > 1) {
                    HelpDeskPackageTab.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void initPackageEditor() {
        if (this.packageEditor == null) {
            this.packageEditor = new HelpDeskPackageEditor();
            this.packageEditor.setVisible(false);
            this.packageEditor.init(((ClientContext)this.getContext()).getModule(), -1);
            this.packageEditor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    HelpDeskPackageTab.this.performAction("refresh");
                }
            });
            this.add((Component)((Object)this.packageEditor), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            Request request = ((ClientContext)this.getContext()).newRequest("GetPackageList");
            request.setPage(this.panelPages);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table");
                this.table.updateData((Node)tableElement);
                this.panelPages.setPageInfo(tableElement);
                this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.initPackageEditor();
            this.packageEditor.setId("-1");
            this.packageEditor.setData();
            this.packageEditor.setVisible(true);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            String id = ClientUtils.getRowId((BGTable)this.table);
            if (id != null) {
                this.initPackageEditor();
                this.packageEditor.setId(id);
                this.packageEditor.setData();
                this.packageEditor.setVisible(true);
            }
        });
    }
}

