/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAccountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.recalculate.SessionRecalculateTarifficationManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public class RecalculateDAO {
    private static final Logger logger = LogManager.getLogger();
    protected PreparedStatement updateSessionCostLogPS;
    protected PreparedStatement updateSessionAccountLogPS;
    protected static final String UPDATE_SESSION_ACCOUNNT_TEMPLATE = "INSERT INTO sessionAccountTableName (amount, account, contractId, sessionId, serviceId) VALUES (?,?,?,?,?)  ON DUPLICATE KEY UPDATE  amount = ?, account = ?";
    protected static final String DELETE_BAD_ACCOUNT_FOR_VALID_SESSIONS_TEMPLATE = "DELETE FROM sessionAccountTableName  WHERE  contractId=? AND sessionId=?  AND serviceId NOT IN (serviceSet)";
    protected static final String UPDATE_SESSION_COST_TEMPLATE = "UPDATE sessionTableName  SET sessionCost=? WHERE id=? ";
    protected String sessionAccountLogTableName;
    protected String sessionLogTableName;
    protected final String sessionLogDetailTableName;
    protected final String servTableName;
    protected final Date dateFrom;
    protected final Date dateTo;
    protected final Connection con;
    protected Set<Pair<Integer, Integer>> contractsForUpdateBalance = new HashSet<Pair<Integer, Integer>>();

    public RecalculateDAO(Date dateFrom, Date dateTo, int moduleId, Connection con) throws SQLException {
        this.sessionAccountLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_account", (Date)dateFrom, (int)moduleId);
        this.sessionLogDetailTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log_detail", (Date)dateFrom, (int)moduleId);
        this.sessionLogTableName = ServerUtils.getModuleMonthTableName((String)"inet_session_log", (Date)dateFrom, (int)moduleId);
        this.servTableName = "inet_serv_" + moduleId;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.con = con;
    }

    public void init() throws SQLException {
        this.updateSessionAccountLogPS = this.con.prepareStatement(UPDATE_SESSION_ACCOUNNT_TEMPLATE.replaceAll("sessionAccountTableName", this.sessionAccountLogTableName));
        this.updateSessionCostLogPS = this.con.prepareStatement(UPDATE_SESSION_COST_TEMPLATE.replaceAll("sessionTableName", this.sessionLogTableName));
    }

    public void recycle() throws SQLException {
        this.updateSessionCostLogPS.close();
        this.updateSessionAccountLogPS.close();
    }

    public BigDecimal flushSessisonAccount(InetConnectionRuntime connectionRuntime, int contractId, int roundingScale, RoundingMode roundingMode, Map<Integer, BigDecimal> accountMapForContract) throws SQLException {
        logger.debug("flush  session account for session " + connectionRuntime.sessionId);
        PreparedStatement updateSessionAccountPS = this.getUpdateSessionAccountPS(connectionRuntime.sessionId);
        BigDecimal accountSum = BigDecimal.ZERO;
        updateSessionAccountPS.setInt(3, contractId);
        updateSessionAccountPS.setLong(4, connectionRuntime.sessionId);
        HashSet<Integer> affectedServices = new HashSet<Integer>();
        for (Map.Entry<Integer, TrafficAccountDelta> accountEntry : connectionRuntime.accountDelta.entrySet()) {
            int serviceId = accountEntry.getKey();
            TrafficAccountDelta account = accountEntry.getValue();
            BigDecimal accountDelta = account.accountDelta.setScale(roundingScale, roundingMode);
            if (accountDelta.compareTo(BigDecimal.ZERO) == 0 && account.amountDelta == 0L) continue;
            affectedServices.add(serviceId);
            long amountDelta = account.amountDelta;
            updateSessionAccountPS.setLong(1, amountDelta);
            updateSessionAccountPS.setBigDecimal(2, accountDelta);
            updateSessionAccountPS.setInt(5, serviceId);
            updateSessionAccountPS.setLong(6, amountDelta);
            updateSessionAccountPS.setBigDecimal(7, accountDelta);
            updateSessionAccountPS.addBatch();
            BigDecimal globalAccount = accountMapForContract.get(serviceId);
            if (globalAccount == null) {
                globalAccount = BigDecimal.ZERO;
            }
            globalAccount = globalAccount.add(accountDelta, MathContext.DECIMAL64);
            accountMapForContract.put(serviceId, globalAccount);
            accountSum = accountSum.add(accountDelta, MathContext.DECIMAL64);
        }
        updateSessionAccountPS.executeBatch();
        logger.debug("session account updated " + connectionRuntime.sessionId);
        connectionRuntime.accountDelta.clear();
        if (affectedServices.size() == 0) {
            affectedServices.add(-1);
        }
        PreparedStatement deleteBadAccountForValidSessionPS = this.getDeleteBadAccountForValidSessionPS(connectionRuntime.sessionId, affectedServices);
        deleteBadAccountForValidSessionPS.setInt(1, contractId);
        deleteBadAccountForValidSessionPS.setLong(2, connectionRuntime.sessionId);
        deleteBadAccountForValidSessionPS.executeUpdate();
        deleteBadAccountForValidSessionPS.close();
        logger.debug("after flush  session account for session " + connectionRuntime.sessionId);
        return accountSum;
    }

    protected PreparedStatement getUpdateSessionAccountPS(long sessionId) {
        return this.updateSessionAccountLogPS;
    }

    protected void updateSessionCostAndTime(InetConnectionRuntime connectionRuntime, BigDecimal accountSum, int roundingScale, RoundingMode roundingMode, InetSessionLog session) throws SQLException {
        BigDecimal accountSumRound = accountSum.setScale(roundingScale, roundingMode);
        if (session == null || session.getSessionCost().compareTo(accountSumRound) != 0) {
            if (session == null) {
                logger.error("session is NULL for " + connectionRuntime.sessionId);
            }
            logger.debug("updating  session cost and time for session " + connectionRuntime.sessionId);
            PreparedStatement updateSessionCostTimePS = this.getUpdateSessionCostLogPS(connectionRuntime.sessionId);
            updateSessionCostTimePS.setBigDecimal(1, accountSumRound);
            updateSessionCostTimePS.setLong(2, connectionRuntime.sessionId);
            if (updateSessionCostTimePS.executeUpdate() == 0) {
                logger.error("Cannot find session with id=" + connectionRuntime.sessionId + "in DB!");
            }
        }
    }

    protected PreparedStatement getDeleteBadAccountForValidSessionPS(long sessionId, Set<Integer> serviceSet) throws SQLException {
        PreparedStatement deleteBadAccountForValidSessionPS = this.con.prepareStatement(DELETE_BAD_ACCOUNT_FOR_VALID_SESSIONS_TEMPLATE.replaceAll("sessionAccountTableName", this.sessionAccountLogTableName).replaceAll("serviceSet", Utils.toString(serviceSet)));
        return deleteBadAccountForValidSessionPS;
    }

    protected PreparedStatement getUpdateSessionCostLogPS(long sessionId) {
        return this.updateSessionCostLogPS;
    }

    public void flushContract(int contractId, int superContractId, int yy, int mm, Set<Long> affectedSessionsForContract, Map<Integer, BigDecimal> accountMapForContract, Set<Integer> allSids) throws BGException, SQLException {
        logger.debug("flushing contract contractId=" + contractId);
        try (BalanceDao balanceDao = new BalanceDao(this.con);){
            String query = "DELETE FROM  " + this.sessionAccountLogTableName + " WHERE  contractId = ? AND sessionId  NOT IN (" + Utils.toString(affectedSessionsForContract) + ")";
            PreparedStatement deleteInvalidSessionAccountLogForContractPS = this.con.prepareStatement(query);
            deleteInvalidSessionAccountLogForContractPS.setInt(1, contractId);
            deleteInvalidSessionAccountLogForContractPS.executeUpdate();
            deleteInvalidSessionAccountLogForContractPS.close();
            HashSet<Integer> notEmptySet = new HashSet<Integer>();
            for (Map.Entry<Integer, BigDecimal> entry : accountMapForContract.entrySet()) {
                int serviceId = entry.getKey();
                BigDecimal account = entry.getValue();
                if (account == null || account.compareTo(BigDecimal.ZERO) == 0) continue;
                notEmptySet.add(serviceId);
                logger.debug("cid=" + contractId + ";serviceId=" + serviceId + ";account=" + account.doubleValue() + ";yy=" + yy + ";mm=" + mm);
                balanceDao.setContractAccount(contractId, yy, mm, serviceId, account);
            }
            HashSet<Integer> sids = new HashSet<Integer>(allSids);
            sids.removeAll(notEmptySet);
            if (sids.size() > 0) {
                balanceDao.removeContractAccount(contractId, yy, mm, Utils.toString(sids));
            }
        }
    }

    public void removeAllExtraData(Set<Integer> allSids, Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> affectedContracts) throws BGException, SQLException {
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        String query = "DELETE FROM " + this.sessionAccountLogTableName + "  WHERE 1 = 1 " + andCidPartWithAffected.replace("cid", "contractId");
        PreparedStatement ps = this.con.prepareStatement(query);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 1, cids, idDivizor, idRemainder);
        ps.executeUpdate();
        ps.close();
    }

    public void removeExtraContractAccount(Set<Integer> cids, int idDivizor, int idRemainder, Set<Integer> allSids, Set<Integer> affectedContracts) throws SQLException {
        int yy = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar((Date)this.dateFrom).get(2) + 1;
        String andCidPartWithAffected = SessionRecalculateTarifficationManager.getSqlAndcidPartWithAffected(cids, affectedContracts);
        HashSet<Integer> services = new HashSet<Integer>(allSids);
        if (services.size() == 0) {
            services.add(-1);
        }
        String query = "SELECT   contract_account.cid as contractId,  contract.scid as superContractId FROM contract_account  LEFT JOIN contract on contract_account.cid = contract.id WHERE yy=? AND mm=? AND sid IN (" + Utils.toString(services) + ")" + andCidPartWithAffected;
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, yy);
        ps.setInt(2, mm);
        SessionRecalculateTarifficationManager.setDivizorAndRemainder(ps, 3, cids, idDivizor, idRemainder);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Integer contractId = rs.getInt("contractId");
            Integer superContractId = rs.getInt("superContractId");
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>((Object)contractId, (Object)superContractId);
            this.contractsForUpdateBalance.add(pair);
        }
        rs.close();
        ps.close();
        String delQuery = "DELETE FROM contract_account WHERE yy=? AND mm=? AND  cid = ? AND sid IN (" + Utils.toString(services) + ")";
        ps = this.con.prepareStatement(delQuery);
        for (Pair<Integer, Integer> pair : this.contractsForUpdateBalance) {
            Integer contractId = (Integer)pair.getFirst();
            int idx = 1;
            ps.setInt(idx++, yy);
            ps.setInt(idx++, mm);
            ps.setInt(idx++, contractId);
            ps.executeUpdate();
        }
        ps.close();
    }

    public Set<Pair<Integer, Integer>> getContractsForUpdateBalance() {
        return this.contractsForUpdateBalance;
    }
}

