/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetInterfaceMap;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterface;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceInterfaceService;

public class InetInterfaceFactory {
    private static final Logger logger = LogManager.getLogger();
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(0, (ThreadFactory)new WorkerThreadFactory("iface-factory-s", null, null));
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(256), (ThreadFactory)new WorkerThreadFactory("iface-factory", null, (ThreadContextFactory)new ThreadContextFactory<ServerContext>(){

        public ServerContext newThreadContext() {
            return new ServerContext(Setup.getSetup(), 0, 0);
        }
    }), new ThreadPoolExecutor.DiscardOldestPolicy());
    private static final ConcurrentMap<Integer, InetInterfaceFactory> INSTANCE_MAP = new ConcurrentHashMap<Integer, InetInterfaceFactory>();
    private final TimeoutMap<Key, Boolean> current = new TimeoutMap(SCHEDULED_EXECUTOR, 30L, 30L, TimeUnit.SECONDS);
    private final Setup setup;
    private final int moduleId;
    private final InetInterfaceMap inetInterfaceMap;

    private InetInterfaceFactory(Setup setup, int moduleId) {
        this.setup = setup;
        this.moduleId = moduleId;
        InetInterfaceMap inetInterfaceMap = null;
        try {
            inetInterfaceMap = InetInterfaceMap.getInstance(moduleId);
        }
        catch (BGException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.inetInterfaceMap = inetInterfaceMap;
    }

    public static InetInterfaceFactory getInstance(Setup setup, int moduleId) {
        return INSTANCE_MAP.computeIfAbsent(moduleId, k -> new InetInterfaceFactory(setup, (int)k));
    }

    private boolean check(Key key) {
        try {
            String oldTitle;
            Integer id;
            if (this.current.get((Object)key) != null) {
                return true;
            }
            if (key.interfaceId == -1 ? (id = this.inetInterfaceMap.getInterfaceId(key.invDeviceId, key.title)) != null : (oldTitle = this.inetInterfaceMap.getInterfaceTitle(key.invDeviceId, key.interfaceId)) != null) {
                return true;
            }
            return this.current.putIfAbsent((Object)key, (Object)Boolean.TRUE, System.currentTimeMillis()) != null;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(Key key, String comment) {
        logger.info("Try create interface " + key.invDeviceId + " " + key.interfaceId + " " + key.title);
        ServerContext context = new ServerContext(this.setup, 0, 0);
        try {
            DeviceInterfaceService ifaceService = (DeviceInterfaceService)context.getService(DeviceInterfaceService.class, this.moduleId);
            DeviceInterface iface = new DeviceInterface();
            iface.setDeviceId(key.invDeviceId);
            iface.setPort(key.interfaceId);
            iface.setTitle(key.title);
            iface.setComment(comment);
            iface.setStatus(1);
            if (key.interfaceId == -1) {
                Connection con = context.getConnection();
                PreparedStatement ps = con.prepareStatement("SELECT * FROM inv_device_" + this.moduleId + " WHERE id=? FOR UPDATE");
                ps.setInt(1, key.invDeviceId);
                ps.executeQuery();
                ps.close();
                int maxId = -1;
                List list = ifaceService.devicePortList(key.invDeviceId, false);
                for (DeviceInterface i : list) {
                    if (i.getTitle().equals(key.title)) {
                        return;
                    }
                    if (i.getPort() <= maxId) continue;
                    maxId = i.getPort();
                }
                iface.setPort(maxId + 1);
            }
            ifaceService.devicePortUpdate(iface, false);
            context.commit();
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            context.recycle();
        }
    }

    public void createIfAbsent(int invDeviceId, int interfaceId, String title, String comment) {
        Key key = new Key(invDeviceId, interfaceId, Utils.maskNull((String)title));
        if (this.check(key)) {
            return;
        }
        EXECUTOR.execute(() -> this.create(key, Utils.maskNull((String)comment)));
    }

    private static class Key {
        private int invDeviceId;
        private int interfaceId;
        private String title;

        public Key(int invDeviceId, int interfaceId, String title) {
            this.invDeviceId = invDeviceId;
            this.interfaceId = interfaceId;
        }

        public int hashCode() {
            return 31 * (31 + this.interfaceId) + this.invDeviceId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            if (this.interfaceId != other.interfaceId) {
                return false;
            }
            if (this.invDeviceId != other.invDeviceId) {
                return false;
            }
            return !(this.title == null ? other.title != null : !this.title.equals(other.title));
        }
    }
}

