/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.SnmpUtils;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import uk.co.westhawk.snmp.stack.AgentException;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.SetPdu;
import uk.co.westhawk.snmp.stack.SnmpContext;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextv2c;

public class SwitchGateWorker
extends GateWorker
implements Observer {
    private static final String PDU_PREFIX = "1.3.6.1.2.1.2.2.1.7";
    private int requestCount = 0;
    private SnmpContext context;

    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        int gid = this.gate.getId();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        String retryIntervals = gateSetup.get("retry.intervals", "500,1000,2000,5000,5000");
        String[] intervalsStr = retryIntervals.split(",");
        int[] intervals = new int[intervalsStr.length];
        for (int i = 0; i < intervalsStr.length; ++i) {
            intervals[i] = Utils.parseInt((String)intervalsStr[i]);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port + " commutinty " + this.gate.getKeyword());
        }
        try {
            String snmpVersion = this.gate.getGateType().getConfigOption("snmp.version");
            if (Utils.isBlankString((String)snmpVersion)) {
                snmpVersion = "1";
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("SNMP version: " + snmpVersion);
            }
            if (!snmpVersion.equals("0")) {
                this.context = snmpVersion.equals("2") || snmpVersion.equals("2c") ? new SnmpContextv2c(host, port) : new SnmpContext(host, port);
                this.context.setCommunity(this.gate.getKeyword());
                SnmpUtils.setBufferSizes((SnmpContext)this.context, (int)2, (int)2);
                SetPdu setPdu = new SetPdu((SnmpContextBasisFace)this.context);
                setPdu.setRetryIntervals(intervals);
                setPdu.addObserver((Observer)this);
                for (UserStatus status : this.statusList) {
                    String ports = status.rule.getRuleText();
                    StringTokenizer st = new StringTokenizer(ports, ",");
                    while (st.hasMoreTokens()) {
                        int ifNumber = Utils.parseInt((String)st.nextToken().trim(), (int)-1);
                        if (ifNumber < 0) continue;
                        int value = 2;
                        value = status.status == 0 ? 1 : 2;
                        setPdu.addOid("1.3.6.1.2.1.2.2.1.7." + ifNumber, (AsnObject)new AsnInteger(value));
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Add oid " + host + " 1.3.6.1.2.1.2.2.1.7." + ifNumber + " i " + value);
                    }
                }
                setPdu.send();
                ++this.requestCount;
                this.waitResponse();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.context != null) {
                this.context.destroy();
            }
        }
    }

    protected void waitResponse() throws InterruptedException {
        while (this.requestCount != 0) {
            Thread.sleep(100L);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        --this.requestCount;
        if (arg instanceof AgentException) {
            this.log.error(arg);
            this.gateErrors.append("\u041e\u0448\u0438\u0431\u043a\u0430 \u0448\u043b\u044e\u0437\u0430 " + this.gate.getHost() + " : " + ((AgentException)arg).getMessage());
            if (this.context != null) {
                this.context.destroy();
            }
            this.interrupt();
        }
    }
}

