/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.collector;

import bitel.billing.server.load.bean.Source;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogWriter;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowArray;
import ru.bitel.bgbilling.kernel.network.flow.NetFlowRecord;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorker;
import ru.bitel.bgbilling.modules.ipn.server.collector.FlowListenerWorkerContext;
import ru.bitel.common.model.Idable;

class FlowListenerWorkerNetFlow
extends FlowListenerWorker {
    private static final Logger log = LogManager.getLogger();

    public FlowListenerWorkerNetFlow(List<FlowPacket> packetList) {
        super(packetList);
    }

    @Override
    protected void process(Source source, FlowPacket packet) {
        long currentHour;
        NetFlowArray netFlowArray = ((FlowListenerWorkerContext)this.context).netFlowArray;
        long now = System.currentTimeMillis();
        if (!netFlowArray.parsePacket(packet.data, now)) {
            return;
        }
        if (((FlowListenerWorkerContext)this.context).realtime) {
            NetFlowRecord rec = ((NetFlowRecord[])netFlowArray.array)[0];
            long millis = rec.getMilliseconds();
            currentHour = millis / 3600000L * 3600000L;
        } else {
            currentHour = now / 3600000L * 3600000L;
        }
        if (currentHour != ((FlowListenerWorkerContext)this.context).hour) {
            ((FlowListenerWorkerContext)this.context).hourEntryMap = ((FlowListenerWorkerContext)this.context).dataLogger.getForHourPart(Long.valueOf(currentHour));
            ((FlowListenerWorkerContext)this.context).hour = currentHour;
        }
        IPDataLogWriter writer = (IPDataLogWriter)((FlowListenerWorkerContext)this.context).dataLogger.getWriter(((FlowListenerWorkerContext)this.context).hourEntryMap, ((FlowListenerWorkerContext)this.context).writerMap, currentHour, (Idable)source);
        try {
            writer.writeRecord(packet.data, now);
        }
        catch (IOException e) {
            log.error("IOException", (Throwable)e);
        }
    }
}

