/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccount;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountStatus;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoFee;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoPhone;
import ru.bitel.bgbilling.modules.mangooffice.common.service.MangoService;
import ru.bitel.bgbilling.modules.mangooffice.server.MangoApi;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoAccountDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoAccountProductDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoFeeDao;
import ru.bitel.bgbilling.modules.mangooffice.server.bean.MangoPhoneDao;
import ru.bitel.bgbilling.modules.mangooffice.server.task.MangoFeesFtpReloader;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mangooffice.common.service.MangoService")
public class MangoServiceImpl
extends AbstractService
implements MangoService {
    private MangoAccountDao accountDao = null;
    private MangoPhoneDao phoneDao = null;
    private MangoAccountProductDao productDao = null;

    private MangoAccountDao getAccountDao() {
        if (this.accountDao == null) {
            this.accountDao = new MangoAccountDao(this.getConnection(), this.moduleId);
        }
        return this.accountDao;
    }

    private MangoPhoneDao getPhoneDao() {
        if (this.phoneDao == null) {
            this.phoneDao = new MangoPhoneDao(this.getConnection(), this.moduleId);
        }
        return this.phoneDao;
    }

    private MangoAccountProductDao getProductDao() {
        if (this.productDao == null) {
            this.productDao = new MangoAccountProductDao(this.getConnection(), this.moduleId);
        }
        return this.productDao;
    }

    public MangoAccount createAccount(int contractId) throws BGException {
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        return mangoApi.createAccount(contractId);
    }

    public MangoAccount bindAccount(int contractId, int accountId) throws BGException {
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        return mangoApi.bindAccount(contractId, accountId);
    }

    public MangoAccount getContractAccount(int contractId) throws BGException {
        return this.getAccountDao().getByContractId(contractId);
    }

    public MangoAccountStatus getMangoAccountStatus(String control) throws BGException {
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        return mangoApi.getMangoStatus(control);
    }

    public BigDecimal changeMangoBalance(int contractId, BigDecimal sum, String comment) throws BGException {
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        return mangoApi.changeBalance(contractId, sum, comment);
    }

    public List<MangoFee> getContractFee(int contractId, Date date) throws BGException {
        MangoAccount account = this.getAccountDao().getByContractId(contractId);
        if (account == null) {
            return null;
        }
        try (MangoFeeDao feeDao = new MangoFeeDao(this.getConnection(), this.moduleId, date);){
            List<MangoFee> list = feeDao.getListMangoFee(account.getControl());
            return list;
        }
    }

    public void reloadFees(Date date) throws BGException {
        System.out.println(TimeUtils.formatDate((Date)date));
        if (date == null) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new MangoFeesFtpReloader(this.moduleId, TimeUtils.convertDateToCalendar((Date)date)));
    }

    public List<IdTitle> getTariffTypeList() throws BGException {
        String tariffsStr = this.getModuleSetup().get("tariffs");
        if (Utils.isBlankString((String)tariffsStr)) {
            return null;
        }
        List list = Utils.stringToPairs((String)tariffsStr);
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        for (String[] mas : list) {
            int id;
            if (mas.length != 2 || (id = Utils.parseInt((String)mas[0].trim(), (int)-1)) <= 0) continue;
            result.add(new IdTitle(id, mas[1]));
        }
        return result;
    }

    public MangoAccountProduct productAdd(int contractId, int planId) throws BGException {
        MangoAccount account = this.getAccountDao().getByContractId(contractId);
        if (account == null) {
            throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        return mangoApi.productAdd(account.getAccountId(), planId, -1);
    }

    public void productRemove(int productId) throws BGException {
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        mangoApi.productRemove(productId);
    }

    public List<MangoAccountProduct> getProductList(int contractId) throws BGException {
        MangoAccount account = this.getAccountDao().getByContractId(contractId);
        if (account == null) {
            return null;
        }
        return this.getProductDao().getList(account.getAccountId());
    }

    public List<MangoPhone> getPhoneList(int contractId) throws BGException {
        return this.getPhoneDao().phoneList(contractId);
    }

    public void phoneAdd(int productId, String phone) throws BGException {
        MangoAccountProduct product = (MangoAccountProduct)this.getProductDao().get(productId);
        if (product == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        if (product.getProductStatus() != 200 && product.getProductStatus() != 100) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432 \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \"\u0412 \u0440\u0430\u0431\u043e\u0442\u0435\" \u043b\u0438\u0431\u043e \"\u041d\u043e\u0432\u044b\u0439\" ");
        }
        MangoAccount account = this.getAccountDao().getByAccountId(product.getAccountId());
        if (account == null) {
            throw new BGMessageException("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        MangoApi mangoApi = new MangoApi(this.moduleId, this.userId, this.getConnection());
        mangoApi.phoneAdd(account.getContractId(), product, phone);
    }

    public void phoneRemove(int phoneId) throws BGException {
        new MangoApi(this.moduleId, this.userId, this.getConnection()).phoneRemove(phoneId);
    }
}

