/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionKit;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class MegafonOptionKitDao
extends AbstractIdDao<MegafonOptionKit> {
    private final MegafonOptionDao optionDao;
    private final String OPTION_KIT_LINK_TABLE;

    public MegafonOptionKitDao(Connection con, int moduleId) {
        super(con, moduleId, "megafon_option_kit");
        this.OPTION_KIT_LINK_TABLE = ServerUtils.getModuleTableName((String)"option_kit_link", (int)moduleId);
        this.optionDao = new MegafonOptionDao(con, moduleId);
    }

    public List<MegafonOptionKit> list(String filter, String orderBy, Object ... params) throws BGException {
        return super.list(filter, orderBy, params);
    }

    protected MegafonOptionKit getFromRS(ResultSet rs) throws SQLException, BGException {
        MegafonOptionKit kit = new MegafonOptionKit();
        kit.setId(rs.getInt("id"));
        kit.setTitle(rs.getString("title"));
        kit.setOptions(this.getOptionsByKitId(kit.getId()));
        return kit;
    }

    private List<MegafonOption> getOptionsByKitId(int kitId) throws BGException {
        ArrayList<MegafonOption> optionList = new ArrayList<MegafonOption>();
        try (PreparedStatement ps = this.con.prepareStatement("SELECT option_id FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?");){
            ps.setInt(1, kitId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    MegafonOption option = (MegafonOption)this.optionDao.get(rs.getInt("option_id"));
                    if (option == null) continue;
                    optionList.add(option);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return optionList;
    }

    protected void updateImpl(MegafonOptionKit kit) throws BGException, SQLException {
        String query = kit.getId() > 0 ? "UPDATE " : "INSERT INTO " + this.tableName + " SET title=?" + (kit.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, kit.getTitle());
            if (kit.getId() > 0) {
                ps.setInt(2, kit.getId());
            }
            ps.executeUpdate();
            int id = kit.getId();
            if (id <= 0) {
                id = ServerUtils.lastInsertId((Connection)this.con);
            }
            this.updateOptionKitLink(id, kit.getOptions());
        }
    }

    private void updateOptionKitLink(int kitId, List<MegafonOption> options) throws SQLException {
        if (Utils.notEmptyCollection(options)) {
            PreparedStatement ps;
            if (this.needClear(kitId)) {
                ps = this.con.prepareStatement("DELETE FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?");
                try {
                    ps.setInt(1, kitId);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            ps = this.con.prepareStatement("INSERT INTO " + this.OPTION_KIT_LINK_TABLE + " SET kit_id=?, option_id=?");
            try {
                for (MegafonOption option : options) {
                    ps.setInt(1, kitId);
                    ps.setInt(2, option.getId());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    private boolean needClear(int kitId) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + this.OPTION_KIT_LINK_TABLE + " WHERE kit_id=?");){
            boolean bl;
            block16: {
                ResultSet rs;
                block14: {
                    boolean bl2;
                    block15: {
                        ps.setInt(1, kitId);
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            bl2 = true;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block16;
                rs.close();
            }
            return bl;
        }
    }
}

