/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.Utils;

public class UnikassaTransactionManager
extends MPSTransactionManager {
    private static final Logger logger = LogManager.getLogger();
    private static final int ANSWER_SUCCESS = 0;
    private static final int ANSWER_SUCCESS_EXIST = 1;
    private static final int ANSWER_ERROR_CID = -1;
    private static final int ANSWER_ERROR_PARAM = -3;
    private static final int ANSWER_ERROR_SERVER = -100;

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        try {
            String duser = request.getParameter("duser");
            String dpass = request.getParameter("dpass");
            logger.debug("authorization using login and password...");
            if (!duser.equals(system.login) || !dpass.equals(system.password)) {
                throw new MPSException(2, "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438! \u041b\u043e\u0433\u0438\u043d \u0438(\u0438\u043b\u0438) \u043f\u0430\u0440\u043e\u043b\u044c \u043d\u0435 \u0432\u0435\u0440\u043d\u044b!");
            }
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    this.actionCheck(mpsRequest);
                    break;
                }
                case 2: {
                    Contract contract = this.actionCheck(mpsRequest);
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getSessionId(), mpsRequest.getTime());
                    if (transaction == null) {
                        logger.debug("add new payment...");
                        this.checkTime(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getSessionId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setResult(0);
                        break;
                    }
                    logger.warn("operation of id=" + mpsRequest.getSessionId() + " has already been committed!");
                    mpsResponse.setResult(1);
                    break;
                }
            }
        }
        catch (MPSException ex) {
            logger.error("error process request", (Throwable)((Object)ex));
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            logger.error("error process request", (Throwable)e);
            this.processError(new MPSException(-1), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        req.setType(0);
        String cid = request.getParameter("cid");
        req.setNumber(cid);
        req.setRawNumber(cid);
        String uact = request.getParameter("uact");
        if ("get_info".equals(uact)) {
            req.setAction(1);
        } else if ("payment".equals(uact)) {
            req.setAction(2);
        }
        if (req.getAction() == 2) {
            req.setSessionId(request.getParameter("term") + "_" + request.getParameter("trans"));
            String sum = request.getParameter("sum");
            req.setSum(Utils.parseBigDecimal((String)sum, (BigDecimal)BigDecimal.ZERO));
        }
        req.setTime(new Date());
        return req;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(-3);
                break;
            }
            case 3: {
                response.setResult(-1);
                break;
            }
            default: {
                response.setResult(-100);
            }
        }
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        return String.format("status=%s", response.getResult()).getBytes();
    }
}

